/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kyuubi.server.http;

import java.io.IOException;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.security.SecureRandom;
import java.util.Hashtable;
import java.util.Set;
import javax.security.sasl.AuthenticationException;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpUtils;
import javax.ws.rs.core.NewCookie;
import org.apache.hadoop.hive.shims.Utils;
import org.apache.kyuubi.Logging;
import org.apache.kyuubi.config.ConfigEntry;
import org.apache.kyuubi.config.KyuubiConf;
import org.apache.kyuubi.config.KyuubiConf$;
import org.apache.kyuubi.server.http.authentication.AuthenticationFilter;
import org.apache.kyuubi.server.http.util.CookieSigner;
import org.apache.kyuubi.server.http.util.HttpAuthUtils$;
import org.apache.kyuubi.server.http.util.SessionManager$;
import org.apache.kyuubi.service.authentication.KyuubiAuthenticationFactory;
import org.apache.thrift.TProcessor;
import org.apache.thrift.protocol.TProtocolFactory;
import org.apache.thrift.server.TServlet;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.ObjectRef;

@ScalaSignature(bytes="\u0006\u0001\t=d\u0001\u0002\u0017.\u0001aB\u0001\u0002\u0012\u0001\u0003\u0002\u0003\u0006I!\u0012\u0005\t\u0013\u0002\u0011\t\u0011)A\u0005\u0015\"A\u0001\u000b\u0001B\u0001B\u0003%\u0011\u000b\u0003\u0005Z\u0001\t\u0005\t\u0015!\u0003[\u0011\u0015\u0001\u0007\u0001\"\u0001b\u0011%A\u0007\u00011AA\u0002\u0013%\u0011\u000eC\u0005q\u0001\u0001\u0007\t\u0019!C\u0005c\"I!\u0010\u0001a\u0001\u0002\u0003\u0006KA\u001b\u0005\bw\u0002\u0011\r\u0011\"\u0001}\u0011\u001d\tY\u0001\u0001Q\u0001\nuD\u0011\"!\u0004\u0001\u0005\u0004%I!a\u0004\t\u0011\u0005u\u0001\u0001)A\u0005\u0003#A\u0011\"a\b\u0001\u0001\u0004%I!!\t\t\u0013\u0005%\u0002\u00011A\u0005\n\u0005-\u0002\u0002CA\u0018\u0001\u0001\u0006K!a\t\t\u0017\u0005E\u0002\u00011AA\u0002\u0013%\u00111\u0007\u0005\f\u0003\u0013\u0002\u0001\u0019!a\u0001\n\u0013\tY\u0005C\u0006\u0002P\u0001\u0001\r\u0011!Q!\n\u0005U\u0002bCA)\u0001\u0001\u0007\t\u0019!C\u0005\u0003gA1\"a\u0015\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u0002V!Y\u0011\u0011\f\u0001A\u0002\u0003\u0005\u000b\u0015BA\u001b\u0011%\tY\u0006\u0001a\u0001\n\u0013\ti\u0006C\u0005\u0002f\u0001\u0001\r\u0011\"\u0003\u0002h!A\u00111\u000e\u0001!B\u0013\ty\u0006C\u0005\u0002n\u0001\u0001\r\u0011\"\u0003\u0002\"!I\u0011q\u000e\u0001A\u0002\u0013%\u0011\u0011\u000f\u0005\t\u0003k\u0002\u0001\u0015)\u0003\u0002$!I\u0011q\u000f\u0001A\u0002\u0013%\u0011\u0011\u0005\u0005\n\u0003s\u0002\u0001\u0019!C\u0005\u0003wB\u0001\"a \u0001A\u0003&\u00111\u0005\u0005\t\u0003\u0003\u0003!\u0019!C\u0005y\"9\u00111\u0011\u0001!\u0002\u0013i\b\"CAC\u0001\t\u0007I\u0011BAD\u0011!\t\u0019\n\u0001Q\u0001\n\u0005%\u0005bBAK\u0001\u0011\u0005\u0013q\u0013\u0005\b\u00033\u0003A\u0011IAN\u0011\u001d\u0011Y\u0002\u0001C\u0005\u0005;AqAa\f\u0001\t\u0013\u0011\t\u0004C\u0004\u00036\u0001!IAa\u000e\t\u000f\tm\u0002\u0001\"\u0003\u0003>!9!q\u000b\u0001\u0005\n\te\u0003b\u0002B0\u0001\u0011%!\u0011\r\u0005\b\u0005O\u0002A\u0011\u0002B5\u0005E!\u0006N]5gi\"#H\u000f]*feZdW\r\u001e\u0006\u0003]=\nA\u0001\u001b;ua*\u0011\u0001'M\u0001\u0007g\u0016\u0014h/\u001a:\u000b\u0005I\u001a\u0014AB6zkV\u0014\u0017N\u0003\u00025k\u00051\u0011\r]1dQ\u0016T\u0011AN\u0001\u0004_J<7\u0001A\n\u0004\u0001e\u0002\u0005C\u0001\u001e?\u001b\u0005Y$B\u0001\u0019=\u0015\ti4'\u0001\u0004uQJLg\r^\u0005\u0003\u007fm\u0012\u0001\u0002V*feZdW\r\u001e\t\u0003\u0003\nk\u0011!M\u0005\u0003\u0007F\u0012q\u0001T8hO&tw-A\u0005qe>\u001cWm]:peB\u0011aiR\u0007\u0002y%\u0011\u0001\n\u0010\u0002\u000b)B\u0013xnY3tg>\u0014\u0018a\u00049s_R|7m\u001c7GC\u000e$xN]=\u0011\u0005-sU\"\u0001'\u000b\u00055c\u0014\u0001\u00039s_R|7m\u001c7\n\u0005=c%\u0001\u0005+Qe>$xnY8m\r\u0006\u001cGo\u001c:z\u0003-\tW\u000f\u001e5GC\u000e$xN]=\u0011\u0005I;V\"A*\u000b\u0005Q+\u0016AD1vi\",g\u000e^5dCRLwN\u001c\u0006\u0003-F\nqa]3sm&\u001cW-\u0003\u0002Y'\nY2*_;vE&\fU\u000f\u001e5f]RL7-\u0019;j_:4\u0015m\u0019;pef\fAaY8oMB\u00111LX\u0007\u00029*\u0011Q,M\u0001\u0007G>tg-[4\n\u0005}c&AC&zkV\u0014\u0017nQ8oM\u00061A(\u001b8jiz\"RA\u00193fM\u001e\u0004\"a\u0019\u0001\u000e\u00035BQ\u0001R\u0003A\u0002\u0015CQ!S\u0003A\u0002)CQ\u0001U\u0003A\u0002ECQ!W\u0003A\u0002i\u000baa]5h]\u0016\u0014X#\u00016\u0011\u0005-tW\"\u00017\u000b\u00055l\u0013\u0001B;uS2L!a\u001c7\u0003\u0019\r{wn[5f'&<g.\u001a:\u0002\u0015MLwM\\3s?\u0012*\u0017\u000f\u0006\u0002sqB\u00111O^\u0007\u0002i*\tQ/A\u0003tG\u0006d\u0017-\u0003\u0002xi\n!QK\\5u\u0011\u001dIx!!AA\u0002)\f1\u0001\u001f\u00132\u0003\u001d\u0019\u0018n\u001a8fe\u0002\n1\"Q+U\u0011~\u001bujT&J\u000bV\tQ\u0010E\u0002\u007f\u0003\u000fi\u0011a \u0006\u0005\u0003\u0003\t\u0019!\u0001\u0003mC:<'BAA\u0003\u0003\u0011Q\u0017M^1\n\u0007\u0005%qP\u0001\u0004TiJLgnZ\u0001\r\u0003V#\u0006jX\"P\u001f.KU\tI\u0001\u0004%\u0006sUCAA\t!\u0011\t\u0019\"!\u0007\u000e\u0005\u0005U!\u0002BA\f\u0003\u0007\t\u0001b]3dkJLG/_\u0005\u0005\u00037\t)B\u0001\u0007TK\u000e,(/\u001a*b]\u0012|W.\u0001\u0003S\u0003:\u0003\u0013aE5t\u0007>|7.[3BkRDWI\\1cY\u0016$WCAA\u0012!\r\u0019\u0018QE\u0005\u0004\u0003O!(a\u0002\"p_2,\u0017M\\\u0001\u0018SN\u001cun\\6jK\u0006+H\u000f[#oC\ndW\rZ0%KF$2A]A\u0017\u0011!Ih\"!AA\u0002\u0005\r\u0012\u0001F5t\u0007>|7.[3BkRDWI\\1cY\u0016$\u0007%\u0001\u0007d_>\\\u0017.\u001a#p[\u0006Lg.\u0006\u0002\u00026A!\u0011qGA#\u001d\u0011\tI$!\u0011\u0011\u0007\u0005mB/\u0004\u0002\u0002>)\u0019\u0011qH\u001c\u0002\rq\u0012xn\u001c;?\u0013\r\t\u0019\u0005^\u0001\u0007!J,G-\u001a4\n\t\u0005%\u0011q\t\u0006\u0004\u0003\u0007\"\u0018\u0001E2p_.LW\rR8nC&tw\fJ3r)\r\u0011\u0018Q\n\u0005\tsF\t\t\u00111\u0001\u00026\u0005i1m\\8lS\u0016$u.\\1j]\u0002\n!bY8pW&,\u0007+\u0019;i\u00039\u0019wn\\6jKB\u000bG\u000f[0%KF$2A]A,\u0011!IH#!AA\u0002\u0005U\u0012aC2p_.LW\rU1uQ\u0002\nAbY8pW&,W*\u0019=BO\u0016,\"!a\u0018\u0011\u0007M\f\t'C\u0002\u0002dQ\u00141!\u00138u\u0003A\u0019wn\\6jK6\u000b\u00070Q4f?\u0012*\u0017\u000fF\u0002s\u0003SB\u0001\"_\f\u0002\u0002\u0003\u0007\u0011qL\u0001\u000eG>|7.[3NCb\fu-\u001a\u0011\u0002\u001d%\u001c8i\\8lS\u0016\u001cVmY;sK\u0006\u0011\u0012n]\"p_.LWmU3dkJ,w\fJ3r)\r\u0011\u00181\u000f\u0005\tsj\t\t\u00111\u0001\u0002$\u0005y\u0011n]\"p_.LWmU3dkJ,\u0007%\u0001\tjg\"#H\u000f](oYf\u001cun\\6jK\u0006!\u0012n\u001d%uiB|e\u000e\\=D_>\\\u0017.Z0%KF$2A]A?\u0011!IX$!AA\u0002\u0005\r\u0012!E5t\u0011R$\bo\u00148ms\u000e{wn[5fA\u00051\u0002l\u0018$P%^\u000b%\u000bR#E?\u001a{%k\u0018%F\u0003\u0012+%+A\fY?\u001a{%kV!S\t\u0016#uLR(S?\"+\u0015\tR#SA\u0005!\u0012-\u001e;iK:$\u0018nY1uS>tg)\u001b7uKJ,\"!!#\u0011\t\u0005-\u0015qR\u0007\u0003\u0003\u001bS!\u0001V\u0017\n\t\u0005E\u0015Q\u0012\u0002\u0015\u0003V$\b.\u001a8uS\u000e\fG/[8o\r&dG/\u001a:\u0002+\u0005,H\u000f[3oi&\u001c\u0017\r^5p]\u001aKG\u000e^3sA\u0005!\u0011N\\5u)\u0005\u0011\u0018A\u00023p!>\u001cH\u000fF\u0003s\u0003;\u000b\u0019\fC\u0004\u0002 \u0012\u0002\r!!)\u0002\u000fI,\u0017/^3tiB!\u00111UAX\u001b\t\t)KC\u0002/\u0003OSA!!+\u0002,\u000691/\u001a:wY\u0016$(BAAW\u0003\u0015Q\u0017M^1y\u0013\u0011\t\t,!*\u0003%!#H\u000f]*feZdW\r\u001e*fcV,7\u000f\u001e\u0005\b\u0003k#\u0003\u0019AA\\\u0003!\u0011Xm\u001d9p]N,\u0007\u0003BAR\u0003sKA!a/\u0002&\n\u0019\u0002\n\u001e;q'\u0016\u0014h\u000f\\3u%\u0016\u001c\bo\u001c8tK\"*A%a0\u0002RB)1/!1\u0002F&\u0019\u00111\u0019;\u0003\rQD'o\\<t!\u0011\t9-!4\u000e\u0005\u0005%'\u0002BAf\u0003\u0007\t!![8\n\t\u0005=\u0017\u0011\u001a\u0002\f\u0013>+\u0005pY3qi&|g.M\u0004\u001f\u0003k\t\u0019Na\u00012\u0013\r\n).a7\u0002z\u0006uW\u0003BA\u001a\u0003/$q!!78\u0005\u0004\t\u0019OA\u0001U\u0013\u0011\ti.a8\u00027\u0011bWm]:j]&$He\u001a:fCR,'\u000f\n3fM\u0006,H\u000e\u001e\u00132\u0015\r\t\t\u000f^\u0001\u0007i\"\u0014xn^:\u0012\t\u0005\u0015\u00181\u001e\t\u0004g\u0006\u001d\u0018bAAui\n9aj\u001c;iS:<\u0007\u0003BAw\u0003gt1a]Ax\u0013\r\t\t\u0010^\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\t)0a>\u0003\u0013QC'o\\<bE2,'bAAyiFJ1%a?\u0002~\u0006}\u0018\u0011\u001d\b\u0004g\u0006u\u0018bAAqiF*!e\u001d;\u0003\u0002\t)1oY1mCF\u001aa%!2)\u000b\u0011\u00129A!\u0005\u0011\u000bM\f\tM!\u0003\u0011\t\t-!QB\u0007\u0003\u0003OKAAa\u0004\u0002(\n\u00012+\u001a:wY\u0016$X\t_2faRLwN\\\u0019\b=\u0005U\"1\u0003B\rc%\u0019\u0013Q[An\u0005+\ti.M\u0005$\u0003w\fiPa\u0006\u0002bF*!e\u001d;\u0003\u0002E\u001aaE!\u0003\u0002/\u001d,Go\u00117jK:$h*Y7f\rJ|WnQ8pW&,G\u0003BA\u001b\u0005?AqA!\t&\u0001\u0004\u0011\u0019#A\u0004d_>\\\u0017.Z:\u0011\u000bM\u0014)C!\u000b\n\u0007\t\u001dBOA\u0003BeJ\f\u0017\u0010\u0005\u0003\u0002$\n-\u0012\u0002\u0002B\u0017\u0003K\u0013aaQ8pW&,\u0017a\u0003;p\u0007>|7.[3TiJ$2! B\u001a\u0011\u001d\u0011\tC\na\u0001\u0005G\taB^1mS\u0012\fG/Z\"p_.LW\r\u0006\u0003\u00026\te\u0002bBAPO\u0001\u0007\u0011\u0011U\u0001\rGJ,\u0017\r^3D_>\\\u0017.\u001a\u000b\u0005\u0005S\u0011y\u0004C\u0004\u0003B!\u0002\r!!\u000e\u0002\u0007M$(\u000fK\u0003)\u0005\u000b\u0012i\u0005E\u0003t\u0003\u0003\u00149\u0005\u0005\u0003\u0002H\n%\u0013\u0002\u0002B&\u0003\u0013\u0014A$\u00168tkB\u0004xN\u001d;fI\u0016s7m\u001c3j]\u001e,\u0005pY3qi&|g.M\u0004\u001f\u0003k\u0011yE!\u00162\u0013\r\n).a7\u0003R\u0005u\u0017'C\u0012\u0002|\u0006u(1KAqc\u0015\u00113\u000f\u001eB\u0001c\r1#qI\u0001\u0018O\u0016$\b\n\u001e;q\u001f:d\u0017pQ8pW&,\u0007*Z1eKJ$B!!\u000e\u0003\\!9!QL\u0015A\u0002\t%\u0012AB2p_.LW-\u0001\u0007bkRDWM\u001c;jG\u0006$X\r\u0006\u0004\u00026\t\r$Q\r\u0005\b\u0003?S\u0003\u0019AAQ\u0011\u001d\t)L\u000ba\u0001\u0003o\u000b\u0011cZ3u\t>\f5/U;fef\u0004\u0016M]1n)\u0011\t)Da\u001b\t\u000f\t54\u00061\u0001\u00026\u0005Y\u0011/^3ssN#(/\u001b8h\u0001")
public class ThriftHttpServlet
extends TServlet
implements Logging {
    private final KyuubiAuthenticationFactory authFactory;
    private final KyuubiConf conf;
    private CookieSigner signer;
    private final String AUTH_COOKIE;
    private final SecureRandom RAN;
    private boolean isCookieAuthEnabled;
    private String cookieDomain;
    private String cookiePath;
    private int cookieMaxAge;
    private boolean isCookieSecure;
    private boolean isHttpOnlyCookie;
    private final String X_FORWARDED_FOR_HEADER;
    private final AuthenticationFilter authenticationFilter;
    private transient Logger org$apache$kyuubi$Logging$$log_;

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public void debug(Function0<Object> message) {
        Logging.debug$((Logging)this, message);
    }

    public void debug(Function0<Object> message, Throwable t) {
        Logging.debug$((Logging)this, message, (Throwable)t);
    }

    public void info(Function0<Object> message) {
        Logging.info$((Logging)this, message);
    }

    public void info(Function0<Object> message, Throwable t) {
        Logging.info$((Logging)this, message, (Throwable)t);
    }

    public void warn(Function0<Object> message) {
        Logging.warn$((Logging)this, message);
    }

    public void warn(Function0<Object> message, Throwable t) {
        Logging.warn$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<Object> message, Throwable t) {
        Logging.error$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<Object> message) {
        Logging.error$((Logging)this, message);
    }

    public void initializeLoggerIfNecessary(boolean isInterpreter) {
        Logging.initializeLoggerIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public Logger org$apache$kyuubi$Logging$$log_() {
        return this.org$apache$kyuubi$Logging$$log_;
    }

    public void org$apache$kyuubi$Logging$$log__$eq(Logger x$1) {
        this.org$apache$kyuubi$Logging$$log_ = x$1;
    }

    private CookieSigner signer() {
        return this.signer;
    }

    private void signer_$eq(CookieSigner x$1) {
        this.signer = x$1;
    }

    public String AUTH_COOKIE() {
        return this.AUTH_COOKIE;
    }

    private SecureRandom RAN() {
        return this.RAN;
    }

    private boolean isCookieAuthEnabled() {
        return this.isCookieAuthEnabled;
    }

    private void isCookieAuthEnabled_$eq(boolean x$1) {
        this.isCookieAuthEnabled = x$1;
    }

    private String cookieDomain() {
        return this.cookieDomain;
    }

    private void cookieDomain_$eq(String x$1) {
        this.cookieDomain = x$1;
    }

    private String cookiePath() {
        return this.cookiePath;
    }

    private void cookiePath_$eq(String x$1) {
        this.cookiePath = x$1;
    }

    private int cookieMaxAge() {
        return this.cookieMaxAge;
    }

    private void cookieMaxAge_$eq(int x$1) {
        this.cookieMaxAge = x$1;
    }

    private boolean isCookieSecure() {
        return this.isCookieSecure;
    }

    private void isCookieSecure_$eq(boolean x$1) {
        this.isCookieSecure = x$1;
    }

    private boolean isHttpOnlyCookie() {
        return this.isHttpOnlyCookie;
    }

    private void isHttpOnlyCookie_$eq(boolean x$1) {
        this.isHttpOnlyCookie = x$1;
    }

    private String X_FORWARDED_FOR_HEADER() {
        return this.X_FORWARDED_FOR_HEADER;
    }

    private AuthenticationFilter authenticationFilter() {
        return this.authenticationFilter;
    }

    public void init() {
        this.isCookieAuthEnabled_$eq(BoxesRunTime.unboxToBoolean((Object)this.conf.get(KyuubiConf$.MODULE$.FRONTEND_THRIFT_HTTP_COOKIE_AUTH_ENABLED())));
        if (this.isCookieAuthEnabled()) {
            String secret = Long.toString(this.RAN().nextLong());
            this.debug((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new java.lang.StringBuilder(60).append("Using the random number as the secret for cookie generation ").append(secret).toString());
            this.signer_$eq(new CookieSigner(secret.getBytes()));
            this.cookieMaxAge_$eq(BoxesRunTime.unboxToInt((Object)this.conf.get(KyuubiConf$.MODULE$.FRONTEND_THRIFT_HTTP_COOKIE_MAX_AGE())));
            this.cookieDomain_$eq((String)((Option)this.conf.get((ConfigEntry)KyuubiConf$.MODULE$.FRONTEND_THRIFT_HTTP_COOKIE_DOMAIN())).orNull(Predef$.MODULE$.$conforms()));
            this.cookiePath_$eq((String)((Option)this.conf.get((ConfigEntry)KyuubiConf$.MODULE$.FRONTEND_THRIFT_HTTP_COOKIE_PATH())).orNull(Predef$.MODULE$.$conforms()));
            this.isCookieSecure_$eq(BoxesRunTime.unboxToBoolean((Object)this.conf.get(KyuubiConf$.MODULE$.FRONTEND_THRIFT_HTTP_USE_SSL())));
            this.isHttpOnlyCookie_$eq(BoxesRunTime.unboxToBoolean((Object)this.conf.get(KyuubiConf$.MODULE$.FRONTEND_THRIFT_HTTP_COOKIE_IS_HTTPONLY())));
        }
        this.authenticationFilter().initAuthHandlers();
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        block18: {
            block17: {
                ObjectRef clientUserName = ObjectRef.create(null);
                boolean requireNewCookie = false;
                try {
                    try {
                        boolean continueProcessing;
                        if (BoxesRunTime.unboxToBoolean((Object)this.conf.get(KyuubiConf$.MODULE$.FRONTEND_THRIFT_HTTP_XSRF_FILTER_ENABLED())) && !(continueProcessing = Utils.doXsrfFilter((ServletRequest)request, (ServletResponse)response, null, null))) {
                            this.warn((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> "Request did not have valid XSRF header, rejecting.");
                            break block17;
                        }
                        if (this.isCookieAuthEnabled()) {
                            this.debug((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> "Cookie Auth Enabled");
                            clientUserName.elem = this.validateCookie(request);
                            boolean bl = requireNewCookie = (String)clientUserName.elem == null;
                            if (requireNewCookie) {
                                this.info((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> "Could not validate cookie sent, will try to generate a new cookie");
                            } else {
                                this.debug((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new java.lang.StringBuilder(26).append("Got userName From Cookie: ").append((String)clientUserName$1.elem).toString());
                            }
                        }
                        if ((String)clientUserName.elem == null) {
                            clientUserName.elem = this.authenticate(request, response);
                        }
                        Predef$.MODULE$.require((String)clientUserName.elem != null, (Function0 & Serializable & scala.Serializable)() -> "No valid authorization provided");
                        this.debug((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new java.lang.StringBuilder(17).append("Client username: ").append((String)clientUserName$1.elem).toString());
                        SessionManager$.MODULE$.setUserName((String)clientUserName.elem);
                        String doAsQueryParam = this.getDoAsQueryParam(request.getQueryString());
                        if (doAsQueryParam != null) {
                            SessionManager$.MODULE$.setProxyUserName(doAsQueryParam);
                        }
                        String clientIpAddress = request.getRemoteAddr();
                        this.debug((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new java.lang.StringBuilder(19).append("Client IP Address: ").append(clientIpAddress).toString());
                        SessionManager$.MODULE$.setIpAddress(clientIpAddress);
                        Option$.MODULE$.apply((Object)request.getHeader((String)this.conf.get(KyuubiConf$.MODULE$.FRONTEND_PROXY_HTTP_CLIENT_IP_HEADER()))).foreach((Function1 & Serializable & scala.Serializable)ipAddress -> {
                            ThriftHttpServlet.$anonfun$doPost$8(this, ipAddress);
                            return BoxedUnit.UNIT;
                        });
                        String forwarded_for = request.getHeader(this.X_FORWARDED_FOR_HEADER());
                        if (forwarded_for != null) {
                            this.debug((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new java.lang.StringBuilder(1).append(this.X_FORWARDED_FOR_HEADER()).append(":").append(forwarded_for).toString());
                            List forwardedAddresses = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])forwarded_for.split(","))).toList();
                            SessionManager$.MODULE$.setForwardedAddresses((List<String>)forwardedAddresses);
                        } else {
                            SessionManager$.MODULE$.setForwardedAddresses((List<String>)List$.MODULE$.empty());
                        }
                        if (requireNewCookie && !this.authFactory.saslDisabled()) {
                            String cookieToken = HttpAuthUtils$.MODULE$.createCookieToken((String)clientUserName.elem);
                            Cookie hs2Cookie = this.createCookie(this.signer().signCookie(cookieToken));
                            if (this.isHttpOnlyCookie()) {
                                response.setHeader("SET-COOKIE", this.getHttpOnlyCookieHeader(hs2Cookie));
                            } else {
                                response.addCookie(hs2Cookie);
                            }
                            this.info((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new java.lang.StringBuilder(32).append("Cookie added for clientUserName ").append((String)clientUserName$1.elem).toString());
                        }
                        super.doPost(request, response);
                        break block18;
                    }
                    catch (AuthenticationException e) {
                        this.error((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> "Error: ", e);
                        response.setStatus(401);
                        response.getWriter().println(new java.lang.StringBuilder(22).append("Authentication Error: ").append(e.getMessage()).toString());
                        break block18;
                    }
                    catch (Throwable e) {
                        this.error((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> "Error: ", e);
                        throw e;
                    }
                }
                finally {
                    SessionManager$.MODULE$.clearUserName();
                    SessionManager$.MODULE$.clearIpAddress();
                    SessionManager$.MODULE$.clearProxyHttpHeaderIpAddress();
                    SessionManager$.MODULE$.clearProxyUserName();
                    SessionManager$.MODULE$.clearForwardedAddresses();
                }
            }
            return;
        }
    }

    private String getClientNameFromCookie(Cookie[] cookies) {
        String string;
        Object object = new Object();
        try {
            ObjectRef currName = ObjectRef.create(null);
            ObjectRef currValue = ObjectRef.create(null);
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])cookies)).foreach((Function1 & Serializable & scala.Serializable)currCookie -> {
                ThriftHttpServlet.$anonfun$getClientNameFromCookie$1(this, currName, currValue, object, currCookie);
                return BoxedUnit.UNIT;
            });
            string = null;
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                string = (String)ex.value();
            }
            throw ex;
        }
        return string;
    }

    private String toCookieStr(Cookie[] cookies) {
        StringBuilder cookieStr = new StringBuilder();
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])cookies)).foreach((Function1 & Serializable & scala.Serializable)c -> cookieStr.append(c.getName()).append('=').append(c.getValue()).append(" ;\n"));
        return cookieStr.toString();
    }

    private String validateCookie(HttpServletRequest request) {
        Cookie[] cookies = request.getCookies();
        if (cookies == null) {
            this.debug((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new java.lang.StringBuilder(45).append("No valid cookies associated with the request ").append(request).toString());
            return null;
        }
        this.debug((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new java.lang.StringBuilder(18).append("Received cookies: ").append(this.toCookieStr(cookies)).toString());
        return this.getClientNameFromCookie(cookies);
    }

    private Cookie createCookie(String str) throws UnsupportedEncodingException {
        this.debug((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new java.lang.StringBuilder(23).append("Cookie name = ").append(this.AUTH_COOKIE()).append(" value = ").append(str).toString());
        Cookie cookie = new Cookie(this.AUTH_COOKIE(), str);
        cookie.setMaxAge(this.cookieMaxAge());
        if (this.cookieDomain() != null) {
            cookie.setDomain(this.cookieDomain());
        }
        if (this.cookiePath() != null) {
            cookie.setPath(this.cookiePath());
        }
        cookie.setSecure(this.isCookieSecure());
        return cookie;
    }

    private String getHttpOnlyCookieHeader(Cookie cookie) {
        NewCookie newCookie = new NewCookie(cookie.getName(), cookie.getValue(), cookie.getPath(), cookie.getDomain(), cookie.getVersion(), cookie.getComment(), cookie.getMaxAge(), cookie.getSecure());
        return Predef.any2stringadd$.MODULE$.$plus$extension(Predef$.MODULE$.any2stringadd((Object)newCookie), "; HttpOnly");
    }

    private String authenticate(HttpServletRequest request, HttpServletResponse response) {
        String authorization = request.getHeader(HttpAuthUtils$.MODULE$.AUTHORIZATION_HEADER());
        return (String)this.authenticationFilter().getMatchedHandler(authorization).map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.authenticate(request, response)).orNull(Predef$.MODULE$.$conforms());
    }

    private String getDoAsQueryParam(String queryString) {
        String string;
        Object object = new Object();
        try {
            this.debug((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new java.lang.StringBuilder(17).append("URL query string:").append(queryString).toString());
            if (queryString == null) {
                return null;
            }
            Hashtable params = HttpUtils.parseQueryString((String)queryString);
            Set keySet = params.keySet();
            keySet.forEach(key -> {
                if (key.equalsIgnoreCase("doAs")) {
                    throw new NonLocalReturnControl(object, (Object)((String[])params.get(key))[0]);
                }
            });
            string = null;
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                string = (String)ex.value();
            }
            throw ex;
        }
        return string;
    }

    public static final /* synthetic */ void $anonfun$doPost$8(ThriftHttpServlet $this, String ipAddress) {
        $this.debug((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new java.lang.StringBuilder(37).append("Proxy Http Header Client IP Address: ").append(ipAddress).toString());
        SessionManager$.MODULE$.setProxyHttpHeaderIpAddress(ipAddress);
    }

    public static final /* synthetic */ void $anonfun$getClientNameFromCookie$1(ThriftHttpServlet $this, ObjectRef currName$1, ObjectRef currValue$1, Object nonLocalReturnKey1$1, Cookie currCookie) {
        currName$1.elem = currCookie.getName();
        String string = (String)currName$1.elem;
        String string2 = $this.AUTH_COOKIE();
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            currValue$1.elem = currCookie.getValue();
            try {
                currValue$1.elem = $this.signer().verifyAndExtract((String)currValue$1.elem);
            }
            catch (IllegalArgumentException e) {
                $this.debug((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new java.lang.StringBuilder(14).append("Invalid cookie").append(e.getMessage()).toString());
                currValue$1.elem = null;
            }
            if ((String)currValue$1.elem != null) {
                String userName = HttpAuthUtils$.MODULE$.getUserNameFromCookieToken((String)currValue$1.elem);
                if (userName == null) {
                    $this.warn((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new java.lang.StringBuilder(21).append("Invalid cookie token ").append((String)currValue$1.elem).toString());
                    return;
                }
                $this.debug((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new java.lang.StringBuilder(30).append("Validated the cookie for user ").append(userName).toString());
                throw new NonLocalReturnControl(nonLocalReturnKey1$1, (Object)userName);
            }
            return;
        }
    }

    public ThriftHttpServlet(TProcessor processor, TProtocolFactory protocolFactory, KyuubiAuthenticationFactory authFactory, KyuubiConf conf) {
        this.authFactory = authFactory;
        this.conf = conf;
        super(processor, protocolFactory);
        Logging.$init$((Logging)this);
        this.AUTH_COOKIE = "hive.server2.auth";
        this.RAN = new SecureRandom();
        this.isCookieAuthEnabled = false;
        this.cookieMaxAge = 0;
        this.isCookieSecure = false;
        this.isHttpOnlyCookie = false;
        this.X_FORWARDED_FOR_HEADER = "X-Forwarded-For";
        this.authenticationFilter = new AuthenticationFilter(conf);
    }
}

