/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kyuubi.jdbc.hive.arrow;

import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.arrow.memory.RootAllocator;
import org.apache.arrow.vector.types.DateUnit;
import org.apache.arrow.vector.types.FloatingPointPrecision;
import org.apache.arrow.vector.types.IntervalUnit;
import org.apache.arrow.vector.types.TimeUnit;
import org.apache.arrow.vector.types.pojo.ArrowType;
import org.apache.arrow.vector.types.pojo.Field;
import org.apache.arrow.vector.types.pojo.FieldType;
import org.apache.arrow.vector.types.pojo.Schema;
import org.apache.hive.service.rpc.thrift.TTypeId;
import org.apache.kyuubi.jdbc.hive.JdbcColumnAttributes;

public class ArrowUtils {
    public static final RootAllocator rootAllocator = new RootAllocator(Long.MAX_VALUE);

    public static Schema toArrowSchema(List<String> columnNames, List<TTypeId> ttypes, List<JdbcColumnAttributes> columnAttributes) {
        List fields = IntStream.range(0, columnNames.size()).mapToObj(i -> ArrowUtils.toArrowField((String)columnNames.get(i), (TTypeId)ttypes.get(i), (JdbcColumnAttributes)columnAttributes.get(i))).collect(Collectors.toList());
        return new Schema(fields);
    }

    public static Field toArrowField(String name, TTypeId ttype, JdbcColumnAttributes jdbcColumnAttributes) {
        boolean nullable = true;
        return new Field(name, new FieldType(nullable, ArrowUtils.toArrowType(ttype, jdbcColumnAttributes), null), Collections.emptyList());
    }

    public static ArrowType toArrowType(TTypeId ttype, JdbcColumnAttributes jdbcColumnAttributes) {
        switch (ttype) {
            case NULL_TYPE: {
                return ArrowType.Null.INSTANCE;
            }
            case BOOLEAN_TYPE: {
                return ArrowType.Bool.INSTANCE;
            }
            case TINYINT_TYPE: {
                return new ArrowType.Int(8, true);
            }
            case SMALLINT_TYPE: {
                return new ArrowType.Int(16, true);
            }
            case INT_TYPE: {
                return new ArrowType.Int(32, true);
            }
            case BIGINT_TYPE: {
                return new ArrowType.Int(64, true);
            }
            case FLOAT_TYPE: {
                return new ArrowType.FloatingPoint(FloatingPointPrecision.SINGLE);
            }
            case DOUBLE_TYPE: {
                return new ArrowType.FloatingPoint(FloatingPointPrecision.DOUBLE);
            }
            case STRING_TYPE: {
                return ArrowType.Utf8.INSTANCE;
            }
            case DECIMAL_TYPE: {
                if (jdbcColumnAttributes != null) {
                    return ArrowType.Decimal.createDecimal((int)jdbcColumnAttributes.precision, (int)jdbcColumnAttributes.scale, null);
                }
                throw new IllegalStateException("Missing precision and scale where it is mandatory.");
            }
            case DATE_TYPE: {
                return new ArrowType.Date(DateUnit.DAY);
            }
            case TIMESTAMP_TYPE: {
                if (jdbcColumnAttributes != null) {
                    return new ArrowType.Timestamp(TimeUnit.MICROSECOND, jdbcColumnAttributes.timeZone);
                }
                throw new IllegalStateException("Missing timezoneId where it is mandatory.");
            }
            case BINARY_TYPE: {
                return ArrowType.Binary.INSTANCE;
            }
            case INTERVAL_DAY_TIME_TYPE: {
                return new ArrowType.Duration(TimeUnit.MICROSECOND);
            }
            case INTERVAL_YEAR_MONTH_TYPE: {
                return new ArrowType.Interval(IntervalUnit.YEAR_MONTH);
            }
        }
        throw new IllegalArgumentException("Unrecognized type name: " + ttype.name());
    }
}

