/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kyuubi.engine.jdbc.session;

import java.io.Serializable;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import org.apache.hive.service.rpc.thrift.TGetInfoType;
import org.apache.hive.service.rpc.thrift.TGetInfoValue;
import org.apache.hive.service.rpc.thrift.TProtocolVersion;
import org.apache.kyuubi.KyuubiSQLException$;
import org.apache.kyuubi.config.KyuubiConf;
import org.apache.kyuubi.engine.jdbc.connection.ConnectionProvider$;
import org.apache.kyuubi.session.AbstractSession;
import org.apache.kyuubi.session.SessionManager;
import scala.Function0;
import scala.MatchError;
import scala.Predef$;
import scala.collection.immutable.Map;
import scala.reflect.ScalaSignature;
import scala.runtime.java8.JFunction0;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0001\u0005ua\u0001B\n\u0015\u0001\u0005B\u0011b\n\u0001\u0003\u0002\u0003\u0006I\u0001\u000b\u001b\t\u0013U\u0002!\u0011!Q\u0001\nY\u001a\u0005\"\u0003#\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u001cF\u0011%1\u0005A!A!\u0002\u00131t\tC\u0005I\u0001\t\u0005\t\u0015!\u0003J\u0019\"IQ\n\u0001B\u0001B\u0003%a*\u0015\u0005\u0006%\u0002!\ta\u0015\u0005\u000b9\u0002\u0001\r\u00111A\u0005\u0002Yi\u0006B\u00034\u0001\u0001\u0004\u0005\r\u0011\"\u0001\u0017O\"Ia\u000e\u0001a\u0001\u0002\u0003\u0006KA\u0018\u0005\n_\u0002\u0001\r\u00111A\u0005\nAD\u0011\u0002\u001e\u0001A\u0002\u0003\u0007I\u0011B;\t\u0013]\u0004\u0001\u0019!A!B\u0013\t\bb\u0002=\u0001\u0005\u0004%I!\u001f\u0005\b\u0003\u0003\u0001\u0001\u0015!\u0003{\u0011\u001d\t\u0019\u0001\u0001C!\u0003\u000bAq!a\u0002\u0001\t\u0003\nI\u0001C\u0004\u0002\u001c\u0001!\t%!\u0002\u0003\u001f)#'mY*fgNLwN\\%na2T!!\u0006\f\u0002\u000fM,7o]5p]*\u0011q\u0003G\u0001\u0005U\u0012\u00147M\u0003\u0002\u001a5\u00051QM\\4j]\u0016T!a\u0007\u000f\u0002\r-LX/\u001e2j\u0015\tib$\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002?\u0005\u0019qN]4\u0004\u0001M\u0011\u0001A\t\t\u0003G\u0015j\u0011\u0001\n\u0006\u0003+iI!A\n\u0013\u0003\u001f\u0005\u00137\u000f\u001e:bGR\u001cVm]:j_:\f\u0001\u0002\u001d:pi>\u001cw\u000e\u001c\t\u0003SIj\u0011A\u000b\u0006\u0003W1\na\u0001\u001e5sS\u001a$(BA\u0017/\u0003\r\u0011\bo\u0019\u0006\u0003_A\nqa]3sm&\u001cWM\u0003\u000229\u0005!\u0001.\u001b<f\u0013\t\u0019$F\u0001\tU!J|Go\\2pYZ+'o]5p]&\u0011q%J\u0001\u0005kN,'\u000f\u0005\u00028\u0001:\u0011\u0001H\u0010\t\u0003sqj\u0011A\u000f\u0006\u0003w\u0001\na\u0001\u0010:p_Rt$\"A\u001f\u0002\u000bM\u001c\u0017\r\\1\n\u0005}b\u0014A\u0002)sK\u0012,g-\u0003\u0002B\u0005\n11\u000b\u001e:j]\u001eT!a\u0010\u001f\n\u0005U*\u0013\u0001\u00039bgN<xN\u001d3\n\u0005\u0011+\u0013!C5q\u0003\u0012$'/Z:t\u0013\t1U%\u0001\u0003d_:4\u0007\u0003B\u001cKmYJ!a\u0013\"\u0003\u00075\u000b\u0007/\u0003\u0002IK\u0005q1/Z:tS>tW*\u00198bO\u0016\u0014\bCA\u0012P\u0013\t\u0001FE\u0001\bTKN\u001c\u0018n\u001c8NC:\fw-\u001a:\n\u00055+\u0013A\u0002\u001fj]&$h\bF\u0004U-^C\u0016LW.\u0011\u0005U\u0003Q\"\u0001\u000b\t\u000b\u001d:\u0001\u0019\u0001\u0015\t\u000bU:\u0001\u0019\u0001\u001c\t\u000b\u0011;\u0001\u0019\u0001\u001c\t\u000b\u0019;\u0001\u0019\u0001\u001c\t\u000b!;\u0001\u0019A%\t\u000b5;\u0001\u0019\u0001(\u0002#M,7o]5p]\u000e{gN\\3di&|g.F\u0001_!\tyF-D\u0001a\u0015\t\t'-A\u0002tc2T\u0011aY\u0001\u0005U\u00064\u0018-\u0003\u0002fA\nQ1i\u001c8oK\u000e$\u0018n\u001c8\u0002+M,7o]5p]\u000e{gN\\3di&|gn\u0018\u0013fcR\u0011\u0001\u000e\u001c\t\u0003S*l\u0011\u0001P\u0005\u0003Wr\u0012A!\u00168ji\"9Q.CA\u0001\u0002\u0004q\u0016a\u0001=%c\u0005\u00112/Z:tS>t7i\u001c8oK\u000e$\u0018n\u001c8!\u0003A!\u0017\r^1cCN,W*\u001a;b\t\u0006$\u0018-F\u0001r!\ty&/\u0003\u0002tA\n\u0001B)\u0019;bE\u0006\u001cX-T3uC\u0012\u000bG/Y\u0001\u0015I\u0006$\u0018MY1tK6+G/\u0019#bi\u0006|F%Z9\u0015\u0005!4\bbB7\r\u0003\u0003\u0005\r!]\u0001\u0012I\u0006$\u0018MY1tK6+G/\u0019#bi\u0006\u0004\u0013AC6zkV\u0014\u0017nQ8oMV\t!\u0010\u0005\u0002|}6\tAP\u0003\u0002~5\u000511m\u001c8gS\u001eL!a ?\u0003\u0015-KX/\u001e2j\u0007>tg-A\u0006lsV,(-[\"p]\u001a\u0004\u0013\u0001B8qK:$\u0012\u0001[\u0001\bO\u0016$\u0018J\u001c4p)\u0011\tY!!\u0005\u0011\u0007%\ni!C\u0002\u0002\u0010)\u0012Q\u0002V$fi&sgm\u001c,bYV,\u0007bBA\n#\u0001\u0007\u0011QC\u0001\tS:4w\u000eV=qKB\u0019\u0011&a\u0006\n\u0007\u0005e!F\u0001\u0007U\u000f\u0016$\u0018J\u001c4p)f\u0004X-A\u0003dY>\u001cX\r")
public class JdbcSessionImpl
extends AbstractSession {
    private Connection sessionConnection;
    private DatabaseMetaData databaseMetaData;
    private final KyuubiConf kyuubiConf = super.sessionManager().getConf();

    public Connection sessionConnection() {
        return this.sessionConnection;
    }

    public void sessionConnection_$eq(Connection x$1) {
        this.sessionConnection = x$1;
    }

    private DatabaseMetaData databaseMetaData() {
        return this.databaseMetaData;
    }

    private void databaseMetaData_$eq(DatabaseMetaData x$1) {
        this.databaseMetaData = x$1;
    }

    private KyuubiConf kyuubiConf() {
        return this.kyuubiConf;
    }

    public void open() {
        this.info((Function0 & Serializable & scala.Serializable)() -> "Starting to open jdbc session.");
        if (this.sessionConnection() == null) {
            this.sessionConnection_$eq(ConnectionProvider$.MODULE$.create(this.kyuubiConf()));
            this.databaseMetaData_$eq(this.sessionConnection().getMetaData());
        }
        super.open();
        this.info((Function0 & Serializable & scala.Serializable)() -> "The jdbc session is started.");
    }

    public TGetInfoValue getInfo(TGetInfoType infoType) {
        return (TGetInfoValue)this.withAcquireRelease(this.withAcquireRelease$default$1(), (Function0 & Serializable & scala.Serializable)() -> {
            Predef$.MODULE$.assert(this.databaseMetaData() != null, (Function0 & Serializable & scala.Serializable)() -> "JDBC session has not been initialized");
            TGetInfoType tGetInfoType = infoType;
            if (TGetInfoType.CLI_SERVER_NAME.equals(tGetInfoType) ? true : TGetInfoType.CLI_DBMS_NAME.equals(tGetInfoType)) {
                return TGetInfoValue.stringValue((String)this.databaseMetaData().getDatabaseProductName());
            }
            if (TGetInfoType.CLI_DBMS_VER.equals(tGetInfoType)) {
                return TGetInfoValue.stringValue((String)this.databaseMetaData().getDatabaseProductVersion());
            }
            if (TGetInfoType.CLI_ODBC_KEYWORDS.equals(tGetInfoType)) {
                return TGetInfoValue.stringValue((String)"Unimplemented");
            }
            if (TGetInfoType.CLI_MAX_COLUMN_NAME_LEN.equals(tGetInfoType)) {
                return TGetInfoValue.lenValue((long)this.databaseMetaData().getMaxColumnNameLength());
            }
            if (TGetInfoType.CLI_MAX_SCHEMA_NAME_LEN.equals(tGetInfoType)) {
                return TGetInfoValue.lenValue((long)this.databaseMetaData().getMaxSchemaNameLength());
            }
            if (TGetInfoType.CLI_MAX_TABLE_NAME_LEN.equals(tGetInfoType)) {
                return TGetInfoValue.lenValue((long)this.databaseMetaData().getMaxTableNameLength());
            }
            throw KyuubiSQLException$.MODULE$.apply(new StringBuilder(32).append("Unrecognized GetInfoType value: ").append(infoType).toString(), KyuubiSQLException$.MODULE$.apply$default$2(), KyuubiSQLException$.MODULE$.apply$default$3(), KyuubiSQLException$.MODULE$.apply$default$4());
        });
    }

    public void close() {
        Try try_ = Try$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            if (this.sessionConnection() != null) {
                this.sessionConnection().close();
                return;
            }
        });
        if (try_ instanceof Success) {
            this.info((Function0 & Serializable & scala.Serializable)() -> "Closed session connection.");
        } else if (try_ instanceof Failure) {
            Failure failure = (Failure)try_;
            Throwable exception = failure.exception();
            this.warn((Function0 & Serializable & scala.Serializable)() -> "Failed to close session connection, ignored it.", exception);
        } else {
            throw new MatchError((Object)try_);
        }
        super.close();
    }

    public JdbcSessionImpl(TProtocolVersion protocol, String user, String password, String ipAddress, Map<String, String> conf, SessionManager sessionManager) {
        super(protocol, user, password, ipAddress, conf, sessionManager);
    }
}

