/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kyuubi.jdbc.hive;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.KeyStore;
import java.security.SecureRandom;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLTimeoutException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.locks.ReentrantLock;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManagerFactory;
import javax.security.auth.Subject;
import org.apache.commons.lang3.ClassUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.hive.service.rpc.thrift.TCLIService;
import org.apache.hive.service.rpc.thrift.TCancelDelegationTokenReq;
import org.apache.hive.service.rpc.thrift.TCancelDelegationTokenResp;
import org.apache.hive.service.rpc.thrift.TCloseSessionReq;
import org.apache.hive.service.rpc.thrift.TFetchOrientation;
import org.apache.hive.service.rpc.thrift.TFetchResultsReq;
import org.apache.hive.service.rpc.thrift.TFetchResultsResp;
import org.apache.hive.service.rpc.thrift.TGetDelegationTokenReq;
import org.apache.hive.service.rpc.thrift.TGetDelegationTokenResp;
import org.apache.hive.service.rpc.thrift.TGetOperationStatusReq;
import org.apache.hive.service.rpc.thrift.TGetOperationStatusResp;
import org.apache.hive.service.rpc.thrift.THandleIdentifier;
import org.apache.hive.service.rpc.thrift.TOpenSessionReq;
import org.apache.hive.service.rpc.thrift.TOpenSessionResp;
import org.apache.hive.service.rpc.thrift.TOperationHandle;
import org.apache.hive.service.rpc.thrift.TOperationType;
import org.apache.hive.service.rpc.thrift.TProtocolVersion;
import org.apache.hive.service.rpc.thrift.TRenewDelegationTokenReq;
import org.apache.hive.service.rpc.thrift.TRenewDelegationTokenResp;
import org.apache.hive.service.rpc.thrift.TSessionHandle;
import org.apache.hive.service.rpc.thrift.TSetClientInfoReq;
import org.apache.hive.service.rpc.thrift.TSetClientInfoResp;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.HttpResponse;
import org.apache.http.NoHttpResponseException;
import org.apache.http.client.CookieStore;
import org.apache.http.client.HttpClient;
import org.apache.http.client.ServiceUnavailableRetryStrategy;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.config.Lookup;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.ssl.DefaultHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.impl.client.BasicCookieStore;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.conn.BasicHttpClientConnectionManager;
import org.apache.http.protocol.HttpContext;
import org.apache.http.ssl.SSLContexts;
import org.apache.kyuubi.jdbc.hive.ClosedOrCancelledException;
import org.apache.kyuubi.jdbc.hive.JdbcConnectionParams;
import org.apache.kyuubi.jdbc.hive.KyuubiDatabaseMetaData;
import org.apache.kyuubi.jdbc.hive.KyuubiPreparedStatement;
import org.apache.kyuubi.jdbc.hive.KyuubiSQLException;
import org.apache.kyuubi.jdbc.hive.KyuubiStatement;
import org.apache.kyuubi.jdbc.hive.Utils;
import org.apache.kyuubi.jdbc.hive.ZooKeeperHiveClientException;
import org.apache.kyuubi.jdbc.hive.ZooKeeperHiveClientHelper;
import org.apache.kyuubi.jdbc.hive.adapter.SQLConnection;
import org.apache.kyuubi.jdbc.hive.auth.HttpBasicAuthInterceptor;
import org.apache.kyuubi.jdbc.hive.auth.HttpKerberosRequestInterceptor;
import org.apache.kyuubi.jdbc.hive.auth.HttpRequestInterceptorBase;
import org.apache.kyuubi.jdbc.hive.auth.HttpXsrfRequestInterceptor;
import org.apache.kyuubi.jdbc.hive.auth.KerberosAuthenticationManager;
import org.apache.kyuubi.jdbc.hive.auth.KerberosSaslHelper;
import org.apache.kyuubi.jdbc.hive.auth.PlainSaslHelper;
import org.apache.kyuubi.jdbc.hive.auth.SaslQOP;
import org.apache.kyuubi.jdbc.hive.auth.ThriftUtils;
import org.apache.kyuubi.jdbc.hive.cli.FetchType;
import org.apache.kyuubi.jdbc.hive.cli.RowSet;
import org.apache.kyuubi.jdbc.hive.cli.RowSetFactory;
import org.apache.kyuubi.jdbc.hive.logs.KyuubiLoggable;
import org.apache.thrift.TException;
import org.apache.thrift.protocol.TBinaryProtocol;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.transport.THttpClient;
import org.apache.thrift.transport.TTransport;
import org.apache.thrift.transport.TTransportException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KyuubiConnection
implements SQLConnection,
KyuubiLoggable {
    public static final Logger LOG = LoggerFactory.getLogger((String)KyuubiConnection.class.getName());
    public static final String BEELINE_MODE_PROPERTY = "BEELINE_MODE";
    public static final String HS2_PROXY_USER = "hive.server2.proxy.user";
    public static int DEFAULT_ENGINE_LOG_THREAD_TIMEOUT = 10000;
    private String jdbcUriString;
    private String host;
    private int port;
    private final Map<String, String> sessConfMap;
    private JdbcConnectionParams connParams;
    private TTransport transport;
    private TCLIService.Iface client;
    private boolean isClosed = true;
    private SQLWarning warningChain = null;
    private TSessionHandle sessHandle = null;
    private final List<TProtocolVersion> supportedProtocols = new LinkedList<TProtocolVersion>();
    private int connectTimeout = 0;
    private int socketTimeout = 0;
    private TProtocolVersion protocol;
    private int fetchSize = 1000;
    private String initFile = null;
    private String wmPool = null;
    private String wmApp = null;
    private Properties clientInfo;
    private boolean initFileCompleted = false;
    private TOperationHandle launchEngineOpHandle = null;
    private Thread engineLogThread;
    private boolean engineLogInflight = true;
    private volatile boolean launchEngineOpCompleted = false;
    private boolean launchEngineOpSupportResult = false;
    private String engineId = "";
    private String engineName = "";
    private String engineUrl = "";
    private boolean isBeeLineMode;

    public static List<JdbcConnectionParams> getAllUrls(String zookeeperBasedHS2Url) throws Exception {
        JdbcConnectionParams params = Utils.parseURL(zookeeperBasedHS2Url, new Properties());
        if (params.getZooKeeperEnsemble() == null) {
            return Collections.singletonList(params);
        }
        return ZooKeeperHiveClientHelper.getDirectParamsList(params);
    }

    public KyuubiConnection(String uri, Properties info) throws SQLException {
        this.isBeeLineMode = Boolean.parseBoolean(info.getProperty(BEELINE_MODE_PROPERTY));
        try {
            this.connParams = Utils.parseURL(uri, info);
        }
        catch (ZooKeeperHiveClientException e) {
            throw new KyuubiSQLException(e);
        }
        this.jdbcUriString = this.connParams.getJdbcUriString();
        this.sessConfMap = this.connParams.getSessionVars();
        if (!this.sessConfMap.containsKey("principal") && this.sessConfMap.containsKey("kyuubiServerPrincipal")) {
            this.sessConfMap.put("principal", this.sessConfMap.get("kyuubiServerPrincipal"));
        }
        this.host = this.isKerberosAuthMode() ? Utils.getCanonicalHostName(this.connParams.getHost()) : this.connParams.getHost();
        this.port = this.connParams.getPort();
        this.setupTimeout();
        if (this.sessConfMap.containsKey("fetchSize")) {
            this.fetchSize = Integer.parseInt(this.sessConfMap.get("fetchSize"));
        }
        if (this.sessConfMap.containsKey("initFile")) {
            this.initFile = this.sessConfMap.get("initFile");
        }
        this.wmPool = this.sessConfMap.get("wmPool");
        for (String application : JdbcConnectionParams.APPLICATION) {
            this.wmApp = this.sessConfMap.get(application);
            if (this.wmApp != null) break;
        }
        Collections.addAll(this.supportedProtocols, TProtocolVersion.values());
        int maxRetries = 1;
        try {
            String strRetries = this.sessConfMap.get("retries");
            if (StringUtils.isNotBlank((CharSequence)strRetries)) {
                maxRetries = Integer.parseInt(strRetries);
            }
        }
        catch (NumberFormatException strRetries) {
            // empty catch block
        }
        int numRetries = 0;
        while (true) {
            try {
                this.openTransport();
                TCLIService.Client _client = new TCLIService.Client((TProtocol)new TBinaryProtocol(this.transport));
                this.client = KyuubiConnection.newSynchronizedClient((TCLIService.Iface)_client);
                this.openSession();
                if (this.isBeeLineMode) break;
                this.showLaunchEngineLog();
                this.waitLaunchEngineToComplete();
                this.executeInitSql();
            }
            catch (Exception e) {
                LOG.warn("Failed to connect to " + this.connParams.getHost() + ":" + this.connParams.getPort());
                String errMsg = null;
                String warnMsg = "Could not open client transport with JDBC Uri: " + this.jdbcUriString + ": ";
                try {
                    this.close();
                }
                catch (Exception ex) {
                    LOG.debug("Error while closing the connection", (Throwable)ex);
                }
                if (ZooKeeperHiveClientHelper.isZkDynamicDiscoveryMode(this.sessConfMap)) {
                    errMsg = "Could not open client transport for any of the Server URI's in ZooKeeper: ";
                    while (!Utils.updateConnParamsFromZooKeeper(this.connParams) && ++numRetries < maxRetries) {
                        this.connParams.getRejectedHostZnodePaths().clear();
                    }
                    this.jdbcUriString = this.connParams.getJdbcUriString();
                    this.host = this.isKerberosAuthMode() ? Utils.getCanonicalHostName(this.connParams.getHost()) : this.connParams.getHost();
                    this.port = this.connParams.getPort();
                } else {
                    errMsg = warnMsg;
                    ++numRetries;
                }
                if (numRetries >= maxRetries) {
                    throw new KyuubiSQLException(errMsg + e.getMessage(), "08S01", e);
                }
                LOG.warn(warnMsg + e.getMessage() + " Retrying " + numRetries + " of " + maxRetries);
                continue;
            }
            break;
        }
    }

    @Override
    public boolean hasMoreLogs() {
        return this.launchEngineOpHandle != null && (this.engineLogInflight || !this.launchEngineOpCompleted);
    }

    @Override
    public List<String> getExecLog() throws SQLException, ClosedOrCancelledException {
        if (this.isClosed()) {
            throw new ClosedOrCancelledException("Method getExecLog() failed. The connection has been closed.");
        }
        if (this.launchEngineOpHandle == null) {
            return Collections.emptyList();
        }
        TFetchResultsReq fetchResultsReq = new TFetchResultsReq(this.launchEngineOpHandle, TFetchOrientation.FETCH_NEXT, (long)this.fetchSize);
        fetchResultsReq.setFetchType(FetchType.LOG.toTFetchType());
        ArrayList<String> logs = new ArrayList<String>();
        try {
            TFetchResultsResp tFetchResultsResp = this.client.FetchResults(fetchResultsReq);
            RowSet rowSet = RowSetFactory.create(tFetchResultsResp.getResults(), this.getProtocol());
            for (Object[] row : rowSet) {
                logs.add(String.valueOf(row[0]));
            }
        }
        catch (TException e) {
            throw new KyuubiSQLException("Error building result set for query log", e);
        }
        this.engineLogInflight = !logs.isEmpty();
        return Collections.unmodifiableList(logs);
    }

    private void showLaunchEngineLog() {
        if (this.launchEngineOpHandle != null) {
            LOG.info("Starting to get launch engine log.");
            this.engineLogThread = new Thread("engine-launch-log"){

                @Override
                public void run() {
                    try {
                        while (KyuubiConnection.this.hasMoreLogs()) {
                            List<String> logs = KyuubiConnection.this.getExecLog();
                            for (String log : logs) {
                                LOG.info(log);
                            }
                            Thread.sleep(300L);
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    LOG.info("Finished to get launch engine log.");
                }
            };
            this.engineLogThread.start();
        }
    }

    public void setEngineLogThread(Thread logThread) {
        this.engineLogThread = logThread;
    }

    public void executeInitSql() throws SQLException {
        if (this.initFileCompleted) {
            return;
        }
        if (this.initFile != null) {
            try {
                List<String> sqlList = KyuubiConnection.parseInitFile(this.initFile);
                try (Statement st = this.createStatement();){
                    for (String sql : sqlList) {
                        boolean hasResult = st.execute(sql);
                        if (!hasResult) continue;
                        ResultSet rs = st.getResultSet();
                        Throwable throwable = null;
                        try {
                            while (rs.next()) {
                                System.out.println(rs.getString(1));
                            }
                        }
                        catch (Throwable throwable2) {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        finally {
                            if (rs == null) continue;
                            if (throwable != null) {
                                try {
                                    rs.close();
                                }
                                catch (Throwable throwable3) {
                                    throwable.addSuppressed(throwable3);
                                }
                                continue;
                            }
                            rs.close();
                        }
                    }
                }
            }
            catch (Exception e) {
                LOG.error("Failed to execute initial SQL");
                throw new KyuubiSQLException(e.getMessage());
            }
        }
        this.initFileCompleted = true;
    }

    public static List<String> parseInitFile(String initFile) throws IOException {
        File file = new File(initFile);
        List<String> initSqlList = null;
        try (BufferedReader br = null;){
            String line;
            FileInputStream input = new FileInputStream(file);
            br = new BufferedReader(new InputStreamReader((InputStream)input, StandardCharsets.UTF_8));
            StringBuilder sb = new StringBuilder();
            while ((line = br.readLine()) != null) {
                if ((line = line.trim()).length() == 0 || line.startsWith("#") || line.startsWith("--")) continue;
                line = line.concat(" ");
                sb.append(line);
            }
            initSqlList = KyuubiConnection.getInitSql(sb.toString());
        }
        return initSqlList;
    }

    private static List<String> getInitSql(String sbLine) {
        char[] sqlArray = sbLine.toCharArray();
        ArrayList<String> initSqlList = new ArrayList<String>();
        int beginIndex = 0;
        for (int index = 0; index < sqlArray.length; ++index) {
            if (sqlArray[index] != ';') continue;
            String sql = sbLine.substring(beginIndex, index).trim();
            initSqlList.add(sql);
            beginIndex = index + 1;
        }
        return initSqlList;
    }

    private void openTransport() throws Exception {
        TTransport tTransport = this.transport = this.isHttpTransportMode() ? this.createHttpTransport() : this.createBinaryTransport();
        if (!this.transport.isOpen()) {
            this.transport.open();
        }
        this.logZkDiscoveryMessage("Connected to " + this.connParams.getHost() + ":" + this.connParams.getPort());
    }

    public String getConnectedUrl() {
        return this.jdbcUriString;
    }

    private String getServerHttpUrl(boolean useSsl) {
        String schemeName = useSsl ? "https" : "http";
        String httpPath = this.sessConfMap.get("httpPath");
        if (httpPath == null) {
            httpPath = "/";
        } else if (!httpPath.startsWith("/")) {
            httpPath = "/" + httpPath;
        }
        return schemeName + "://" + this.host + ":" + this.port + httpPath;
    }

    private TTransport createHttpTransport() throws SQLException, TTransportException {
        boolean useSsl = this.isSslConnection();
        CloseableHttpClient httpClient = this.getHttpClient(useSsl);
        this.transport = new THttpClient(this.getServerHttpUrl(useSsl), (HttpClient)httpClient);
        return this.transport;
    }

    private CloseableHttpClient getHttpClient(Boolean useSsl) throws SQLException {
        HttpRequestInterceptorBase requestInterceptor;
        boolean isCookieEnabled = this.isCookieEnabled();
        String cookieName = this.sessConfMap.getOrDefault("cookieName", "hive.server2.auth");
        BasicCookieStore cookieStore = isCookieEnabled ? new BasicCookieStore() : null;
        HashMap<String, String> additionalHttpHeaders = new HashMap<String, String>();
        HashMap<String, String> customCookies = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : this.sessConfMap.entrySet()) {
            String key = entry.getKey();
            if (key.startsWith("http.header.")) {
                additionalHttpHeaders.put(key.substring("http.header.".length()), entry.getValue());
            }
            if (!key.startsWith("http.cookie.")) continue;
            customCookies.put(key.substring("http.cookie.".length()), entry.getValue());
        }
        if (!this.isSaslAuthMode()) {
            requestInterceptor = null;
        } else if (this.isPlainSaslAuthMode()) {
            requestInterceptor = new HttpBasicAuthInterceptor(this.getUserName(), this.getPassword(), (CookieStore)cookieStore, cookieName, useSsl, additionalHttpHeaders, customCookies);
        } else {
            Subject subject = this.createSubject();
            requestInterceptor = new HttpKerberosRequestInterceptor(this.sessConfMap.get("principal"), this.host, subject, (CookieStore)cookieStore, cookieName, useSsl, additionalHttpHeaders, customCookies);
        }
        HttpClientBuilder httpClientBuilder = HttpClientBuilder.create();
        RequestConfig config = RequestConfig.custom().setConnectTimeout(this.connectTimeout).setSocketTimeout(this.socketTimeout).build();
        httpClientBuilder.setDefaultRequestConfig(config);
        if (isCookieEnabled) {
            httpClientBuilder.setServiceUnavailableRetryStrategy(new ServiceUnavailableRetryStrategy(){

                public boolean retryRequest(HttpResponse response, int executionCount, HttpContext context) {
                    boolean ret;
                    int statusCode = response.getStatusLine().getStatusCode();
                    boolean bl = ret = statusCode == 401 && executionCount <= 1;
                    if (ret) {
                        context.setAttribute("hive.server2.retryserver", (Object)"true");
                    }
                    return ret;
                }

                public long getRetryInterval() {
                    return 0L;
                }
            });
        }
        httpClientBuilder.setRetryHandler((exception, executionCount, context) -> {
            if (executionCount > 1) {
                LOG.info("Retry attempts to connect to server exceeded.");
                return false;
            }
            if (exception instanceof NoHttpResponseException) {
                LOG.info("Could not connect to the server. Retrying one more time.");
                return true;
            }
            return false;
        });
        httpClientBuilder.addInterceptorFirst((HttpRequestInterceptor)requestInterceptor);
        httpClientBuilder.addInterceptorLast((HttpRequestInterceptor)new HttpXsrfRequestInterceptor());
        if (useSsl.booleanValue()) {
            String useTwoWaySSL = this.sessConfMap.get("twoWay");
            String sslTrustStorePath = this.sessConfMap.get("sslTrustStore");
            String sslTrustStorePassword = this.sessConfMap.get("trustStorePassword");
            try {
                SSLConnectionSocketFactory socketFactory;
                if (useTwoWaySSL != null && useTwoWaySSL.equalsIgnoreCase("true")) {
                    socketFactory = this.getTwoWaySSLSocketFactory();
                } else if (sslTrustStorePath == null || sslTrustStorePath.isEmpty()) {
                    socketFactory = SSLConnectionSocketFactory.getSocketFactory();
                } else {
                    KeyStore sslTrustStore = KeyStore.getInstance("JKS");
                    try (FileInputStream fis = new FileInputStream(sslTrustStorePath);){
                        sslTrustStore.load(fis, sslTrustStorePassword != null ? sslTrustStorePassword.toCharArray() : null);
                    }
                    SSLContext sslContext = SSLContexts.custom().loadTrustMaterial(sslTrustStore, null).build();
                    socketFactory = new SSLConnectionSocketFactory(sslContext, (HostnameVerifier)new DefaultHostnameVerifier(null));
                }
                Registry registry = RegistryBuilder.create().register("https", (Object)socketFactory).build();
                httpClientBuilder.setConnectionManager((HttpClientConnectionManager)new BasicHttpClientConnectionManager((Lookup)registry));
            }
            catch (Exception e) {
                String msg = "Could not create an https connection to " + this.jdbcUriString + ". " + e.getMessage();
                throw new KyuubiSQLException(msg, "08S01", e);
            }
        }
        return httpClientBuilder.build();
    }

    private TTransport createUnderlyingTransport() throws TTransportException {
        TTransport transport = null;
        if (this.isSslConnection()) {
            String sslTrustStore = this.sessConfMap.get("sslTrustStore");
            String sslTrustStorePassword = this.sessConfMap.get("trustStorePassword");
            transport = sslTrustStore == null || sslTrustStore.isEmpty() ? ThriftUtils.getSSLSocket(this.host, this.port, this.connectTimeout, this.socketTimeout) : ThriftUtils.getSSLSocket(this.host, this.port, this.connectTimeout, this.socketTimeout, sslTrustStore, sslTrustStorePassword);
        } else {
            transport = ThriftUtils.getSocketTransport(this.host, this.port, this.connectTimeout, this.socketTimeout);
        }
        return transport;
    }

    private TTransport createBinaryTransport() throws SQLException, TTransportException {
        try {
            TTransport socketTransport = this.createUnderlyingTransport();
            if (!this.isSaslAuthMode()) {
                return socketTransport;
            }
            if (this.isPlainSaslAuthMode()) {
                String userName = this.getUserName();
                String passwd = this.getPassword();
                return PlainSaslHelper.getPlainTransport(userName, passwd, socketTransport);
            }
            HashMap<String, String> saslProps = new HashMap<String, String>();
            saslProps.put("javax.security.sasl.server.authentication", "true");
            saslProps.put("javax.security.sasl.qop", "auth-conf,auth-int,auth");
            if (this.sessConfMap.containsKey("saslQop")) {
                try {
                    SaslQOP saslQOP = SaslQOP.fromString(this.sessConfMap.get("saslQop"));
                    saslProps.put("javax.security.sasl.qop", saslQOP.toString());
                }
                catch (IllegalArgumentException e) {
                    throw new KyuubiSQLException("Invalid saslQop parameter. " + e.getMessage(), "42000", e);
                }
            }
            Subject subject = this.createSubject();
            String serverPrincipal = this.sessConfMap.get("principal");
            return KerberosSaslHelper.createSubjectAssumedTransport(subject, serverPrincipal, this.host, socketTransport, saslProps);
        }
        catch (Exception e) {
            throw new KyuubiSQLException("Could not create secure connection to " + this.jdbcUriString + ": " + e.getMessage(), "08S01", e);
        }
    }

    SSLConnectionSocketFactory getTwoWaySSLSocketFactory() throws SQLException {
        try {
            KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance("SunX509", "SunJSSE");
            String keyStorePath = this.sessConfMap.get("sslKeyStore");
            String keyStorePassword = this.sessConfMap.get("keyStorePassword");
            KeyStore sslKeyStore = KeyStore.getInstance("JKS");
            if (keyStorePath == null || keyStorePath.isEmpty()) {
                throw new IllegalArgumentException("sslKeyStore Not configured for 2 way SSL connection, keyStorePath param is empty");
            }
            try (FileInputStream fis = new FileInputStream(keyStorePath);){
                sslKeyStore.load(fis, keyStorePassword.toCharArray());
            }
            keyManagerFactory.init(sslKeyStore, keyStorePassword.toCharArray());
            TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance("SunX509");
            String trustStorePath = this.sessConfMap.get("sslTrustStore");
            String trustStorePassword = this.sessConfMap.get("trustStorePassword");
            KeyStore sslTrustStore = KeyStore.getInstance("JKS");
            if (trustStorePath == null || trustStorePath.isEmpty()) {
                throw new IllegalArgumentException("sslTrustStore Not configured for 2 way SSL connection");
            }
            try (FileInputStream fis = new FileInputStream(trustStorePath);){
                sslTrustStore.load(fis, trustStorePassword != null ? trustStorePassword.toCharArray() : null);
            }
            trustManagerFactory.init(sslTrustStore);
            SSLContext context = SSLContext.getInstance("TLS");
            context.init(keyManagerFactory.getKeyManagers(), trustManagerFactory.getTrustManagers(), new SecureRandom());
            return new SSLConnectionSocketFactory(context);
        }
        catch (Exception e) {
            throw new KyuubiSQLException("Error while initializing 2 way ssl socket factory ", e);
        }
    }

    private void openSession() throws SQLException {
        Map<String, String> sessVars;
        TOpenSessionReq openReq = new TOpenSessionReq();
        HashMap<String, String> openConf = new HashMap<String, String>();
        for (Map.Entry<String, String> hiveConf : this.connParams.getHiveConfs().entrySet()) {
            openConf.put("set:hiveconf:" + hiveConf.getKey(), hiveConf.getValue());
        }
        for (Map.Entry<String, String> hiveVar : this.connParams.getHiveVars().entrySet()) {
            openConf.put("set:hivevar:" + hiveVar.getKey(), hiveVar.getValue());
        }
        if (this.connParams.getCatalogName() != null) {
            openConf.put("use:catalog", this.connParams.getCatalogName());
        }
        openConf.put("use:database", this.connParams.getDbName());
        openConf.put("set:hiveconf:hive.server2.thrift.resultset.default.fetch.size", Integer.toString(this.fetchSize));
        if (this.wmPool != null) {
            openConf.put("set:hivevar:wmpool", this.wmPool);
        }
        if (this.wmApp != null) {
            openConf.put("set:hivevar:wmapp", this.wmApp);
        }
        if ((sessVars = this.connParams.getSessionVars()).containsKey(HS2_PROXY_USER)) {
            openConf.put(HS2_PROXY_USER, sessVars.get(HS2_PROXY_USER));
        }
        try {
            openConf.put("kyuubi.client.ipAddress", InetAddress.getLocalHost().getHostAddress());
        }
        catch (UnknownHostException e) {
            LOG.debug("Error getting Kyuubi session local client ip address", (Throwable)e);
        }
        openConf.put("kyuubi.client.version", Utils.getVersion());
        openReq.setConfiguration(openConf);
        if ("noSasl".equals(this.sessConfMap.get("auth"))) {
            openReq.setUsername(this.sessConfMap.get("user"));
            openReq.setPassword(this.sessConfMap.get("password"));
        }
        try {
            TOpenSessionResp openResp = this.client.OpenSession(openReq);
            Utils.verifySuccess(openResp.getStatus());
            if (!this.supportedProtocols.contains(openResp.getServerProtocolVersion())) {
                throw new TException("Unsupported Hive2 protocol");
            }
            this.protocol = openResp.getServerProtocolVersion();
            this.sessHandle = openResp.getSessionHandle();
            Map openRespConf = openResp.getConfiguration();
            String serverFetchSize = (String)openRespConf.get("hive.server2.thrift.resultset.default.fetch.size");
            if (serverFetchSize != null) {
                this.fetchSize = Integer.parseInt(serverFetchSize);
            }
            String launchEngineOpHandleGuid = (String)openRespConf.get("kyuubi.session.engine.launch.handle.guid");
            String launchEngineOpHandleSecret = (String)openRespConf.get("kyuubi.session.engine.launch.handle.secret");
            this.launchEngineOpSupportResult = Boolean.parseBoolean(openRespConf.getOrDefault("kyuubi.session.engine.launch.support.result", "false"));
            if (launchEngineOpHandleGuid != null && launchEngineOpHandleSecret != null) {
                try {
                    byte[] guidBytes = Base64.getMimeDecoder().decode(launchEngineOpHandleGuid);
                    byte[] secretBytes = Base64.getMimeDecoder().decode(launchEngineOpHandleSecret);
                    THandleIdentifier handleIdentifier = new THandleIdentifier(ByteBuffer.wrap(guidBytes), ByteBuffer.wrap(secretBytes));
                    this.launchEngineOpHandle = new TOperationHandle(handleIdentifier, TOperationType.UNKNOWN, false);
                }
                catch (Exception e) {
                    LOG.error("Failed to decode launch engine operation handle from open session resp", (Throwable)e);
                }
            }
        }
        catch (TException e) {
            LOG.error("Error opening session", (Throwable)e);
            throw new KyuubiSQLException("Could not establish connection to " + this.jdbcUriString + ": " + e.getMessage(), "08S01", e);
        }
        this.isClosed = false;
    }

    private String getUserName() {
        return this.getSessionValue("user", "anonymous");
    }

    private String getPassword() {
        return this.getSessionValue("password", "anonymous");
    }

    private boolean isCookieEnabled() {
        return !"false".equalsIgnoreCase(this.sessConfMap.get("cookieAuth"));
    }

    private boolean isSslConnection() {
        return "true".equalsIgnoreCase(this.sessConfMap.get("ssl"));
    }

    private boolean isSaslAuthMode() {
        return !"noSasl".equalsIgnoreCase(this.sessConfMap.get("auth"));
    }

    private boolean isHadoopUserGroupInformationDoAs() {
        try {
            Class HadoopUserClz = ClassUtils.getClass((String)"org.apache.hadoop.security.User");
            Subject subject = Subject.getSubject(AccessController.getContext());
            return subject != null && !subject.getPrincipals(HadoopUserClz).isEmpty();
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    private boolean isKeytabAuthMode() {
        return this.isSaslAuthMode() && this.hasSessionValue("principal") && this.hasSessionValue("kyuubiClientPrincipal") && this.hasSessionValue("kyuubiClientKeytab");
    }

    private boolean isFromSubjectAuthMode() {
        return this.isSaslAuthMode() && this.hasSessionValue("principal") && !this.hasSessionValue("kyuubiClientPrincipal") && !this.hasSessionValue("kyuubiClientKeytab") && ("fromSubject".equalsIgnoreCase(this.sessConfMap.get("kerberosAuthType")) || this.isHadoopUserGroupInformationDoAs());
    }

    private boolean isTgtCacheAuthMode() {
        return this.isSaslAuthMode() && this.hasSessionValue("principal") && !this.hasSessionValue("kyuubiClientPrincipal") && !this.hasSessionValue("kyuubiClientKeytab");
    }

    private boolean isPlainSaslAuthMode() {
        return this.isSaslAuthMode() && !this.hasSessionValue("principal");
    }

    private boolean isKerberosAuthMode() {
        return this.isSaslAuthMode() && this.hasSessionValue("principal");
    }

    private Subject createSubject() {
        if (this.isKeytabAuthMode()) {
            String principal = this.sessConfMap.get("kyuubiClientPrincipal");
            String keytab = this.sessConfMap.get("kyuubiClientKeytab");
            return KerberosAuthenticationManager.getKeytabAuthentication(principal, keytab).getSubject();
        }
        if (this.isFromSubjectAuthMode()) {
            AccessControlContext context = AccessController.getContext();
            return Subject.getSubject(context);
        }
        if (this.isTgtCacheAuthMode()) {
            return KerberosAuthenticationManager.getTgtCacheAuthentication().getSubject();
        }
        throw new IllegalArgumentException("Unsupported auth mode");
    }

    private boolean isHttpTransportMode() {
        return "http".equalsIgnoreCase(this.sessConfMap.get("transportMode"));
    }

    private void logZkDiscoveryMessage(String message) {
        if (ZooKeeperHiveClientHelper.isZkDynamicDiscoveryMode(this.sessConfMap)) {
            LOG.info(message);
        }
    }

    private boolean hasSessionValue(String varName) {
        String varValue = this.sessConfMap.get(varName);
        return varValue != null && !varValue.isEmpty();
    }

    private String getSessionValue(String varName, String varDefault) {
        String varValue = this.sessConfMap.get(varName);
        if (varValue == null || varValue.isEmpty()) {
            varValue = varDefault;
        }
        return varValue;
    }

    private void setupTimeout() {
        if (this.sessConfMap.containsKey("connectTimeout")) {
            String connectTimeoutStr = this.sessConfMap.get("connectTimeout");
            try {
                long connectTimeoutMs = Long.parseLong(connectTimeoutStr);
                this.connectTimeout = (int)Math.max(0L, Math.min(connectTimeoutMs, Integer.MAX_VALUE));
            }
            catch (NumberFormatException e) {
                LOG.info("Failed to parse connectTimeout of value " + connectTimeoutStr);
            }
        }
        if (this.sessConfMap.containsKey("socketTimeout")) {
            String socketTimeoutStr = this.sessConfMap.get("socketTimeout");
            try {
                long socketTimeoutMs = Long.parseLong(socketTimeoutStr);
                this.socketTimeout = (int)Math.max(0L, Math.min(socketTimeoutMs, Integer.MAX_VALUE));
            }
            catch (NumberFormatException e) {
                LOG.info("Failed to parse socketTimeout of value " + socketTimeoutStr);
            }
        }
    }

    public String getDelegationToken(String owner, String renewer) throws SQLException {
        if (this.isClosed) {
            throw new KyuubiSQLException("Connection is closed");
        }
        TGetDelegationTokenReq req = new TGetDelegationTokenReq(this.sessHandle, owner, renewer);
        try {
            TGetDelegationTokenResp tokenResp = this.client.GetDelegationToken(req);
            Utils.verifySuccess(tokenResp.getStatus());
            return tokenResp.getDelegationToken();
        }
        catch (TException e) {
            throw new KyuubiSQLException("Could not retrieve token: " + e.getMessage(), "08S01", e);
        }
    }

    public void cancelDelegationToken(String tokenStr) throws SQLException {
        if (this.isClosed) {
            throw new KyuubiSQLException("Connection is closed");
        }
        TCancelDelegationTokenReq cancelReq = new TCancelDelegationTokenReq(this.sessHandle, tokenStr);
        try {
            TCancelDelegationTokenResp cancelResp = this.client.CancelDelegationToken(cancelReq);
            Utils.verifySuccess(cancelResp.getStatus());
        }
        catch (TException e) {
            throw new KyuubiSQLException("Could not cancel token: " + e.getMessage(), "08S01", e);
        }
    }

    public void renewDelegationToken(String tokenStr) throws SQLException {
        if (this.isClosed) {
            throw new KyuubiSQLException("Connection is closed");
        }
        TRenewDelegationTokenReq cancelReq = new TRenewDelegationTokenReq(this.sessHandle, tokenStr);
        try {
            TRenewDelegationTokenResp renewResp = this.client.RenewDelegationToken(cancelReq);
            Utils.verifySuccess(renewResp.getStatus());
        }
        catch (TException e) {
            throw new KyuubiSQLException("Could not renew token: " + e.getMessage(), "08S01", e);
        }
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.warningChain = null;
    }

    @Override
    public void close() throws SQLException {
        try {
            if (!this.isClosed) {
                TCloseSessionReq closeReq = new TCloseSessionReq(this.sessHandle);
                this.client.CloseSession(closeReq);
            }
        }
        catch (TException e) {
            throw new KyuubiSQLException("Error while cleaning up the server resources", e);
        }
        finally {
            this.isClosed = true;
            this.client = null;
            if (this.transport != null && this.transport.isOpen()) {
                this.transport.close();
                this.transport = null;
            }
        }
    }

    private void closeOnLaunchEngineFailure() throws SQLException {
        if (this.engineLogThread != null && this.engineLogThread.isAlive()) {
            this.engineLogThread.interrupt();
            try {
                this.engineLogThread.join(DEFAULT_ENGINE_LOG_THREAD_TIMEOUT);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.engineLogThread = null;
        this.close();
    }

    @Override
    public Statement createStatement() throws SQLException {
        if (this.isClosed) {
            throw new KyuubiSQLException("Can't create Statement, connection is closed");
        }
        return new KyuubiStatement(this, this.client, this.sessHandle, this.fetchSize);
    }

    private KyuubiStatement createKyuubiStatement() throws SQLException {
        return (KyuubiStatement)this.createStatement();
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        if (resultSetConcurrency != 1007) {
            throw new KyuubiSQLException("Statement with resultset concurrency " + resultSetConcurrency + " is not supported", "HYC00");
        }
        if (resultSetType == 1005) {
            throw new KyuubiSQLException("Statement with resultset type " + resultSetType + " is not supported", "HYC00");
        }
        if (this.isClosed) {
            throw new KyuubiSQLException("Connection is closed");
        }
        return new KyuubiStatement(this, this.client, this.sessHandle, resultSetType == 1004, this.fetchSize);
    }

    @Override
    public boolean getAutoCommit() throws SQLException {
        return true;
    }

    /*
     * Exception decompiling
     */
    @Override
    public String getCatalog() throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public Properties getClientInfo() throws SQLException {
        return this.clientInfo == null ? new Properties() : this.clientInfo;
    }

    @Override
    public String getClientInfo(String name) throws SQLException {
        if (this.clientInfo == null) {
            return null;
        }
        return this.clientInfo.getProperty(name);
    }

    @Override
    public DatabaseMetaData getMetaData() throws SQLException {
        if (this.isClosed) {
            throw new KyuubiSQLException("Connection is closed");
        }
        return new KyuubiDatabaseMetaData(this, this.client, this.sessHandle);
    }

    /*
     * Exception decompiling
     */
    @Override
    public String getSchema() throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public int getTransactionIsolation() throws SQLException {
        return 0;
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        return this.warningChain;
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.isClosed;
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        return false;
    }

    @Override
    public boolean isValid(int timeout) throws SQLException {
        if (timeout < 0) {
            throw new KyuubiSQLException("timeout value was negative");
        }
        if (this.isClosed) {
            return false;
        }
        boolean rc = false;
        try {
            new KyuubiDatabaseMetaData(this, this.client, this.sessHandle).getDatabaseProductName();
            rc = true;
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return rc;
    }

    @Override
    public PreparedStatement prepareStatement(String sql) throws SQLException {
        if (this.isClosed) {
            throw new KyuubiSQLException("Connection is closed");
        }
        return new KyuubiPreparedStatement(this, this.client, this.sessHandle, sql);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        if (this.isClosed) {
            throw new KyuubiSQLException("Connection is closed");
        }
        return new KyuubiPreparedStatement(this, this.client, this.sessHandle, sql);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        if (this.isClosed) {
            throw new KyuubiSQLException("Connection is closed");
        }
        return new KyuubiPreparedStatement(this, this.client, this.sessHandle, sql);
    }

    @Override
    public void setAutoCommit(boolean autoCommit) throws SQLException {
        if (this.isClosed) {
            throw new KyuubiSQLException("Connection is closed");
        }
        if (!autoCommit) {
            LOG.warn("Request to set autoCommit to false; Hive does not support autoCommit=false.");
            SQLWarning warning = new SQLWarning("Hive does not support autoCommit=false");
            if (this.warningChain == null) {
                this.warningChain = warning;
            } else {
                this.warningChain.setNextWarning(warning);
            }
        }
    }

    @Override
    public void setCatalog(String catalog) throws SQLException {
        if (this.isClosed) {
            throw new KyuubiSQLException("Connection is closed");
        }
        try (KyuubiStatement stmt = this.createKyuubiStatement();){
            stmt.executeSetCurrentCatalog("_SET_CATALOG", catalog);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    @Override
    public void setClientInfo(Properties properties) throws SQLClientInfoException {
        this.clientInfo = properties;
        this.setClientInfo();
    }

    @Override
    public void setClientInfo(String name, String value) throws SQLClientInfoException {
        if (this.clientInfo == null) {
            this.clientInfo = new Properties();
        }
        this.clientInfo.put(name, value);
        this.setClientInfo();
    }

    private void setClientInfo() throws SQLClientInfoException {
        if (this.isClosed) {
            throw new SQLClientInfoException("Connection is closed", null);
        }
        TSetClientInfoReq req = new TSetClientInfoReq(this.sessHandle);
        HashMap<String, String> map = new HashMap<String, String>();
        if (this.clientInfo != null) {
            for (Map.Entry<Object, Object> e : this.clientInfo.entrySet()) {
                if (e.getKey() == null || e.getValue() == null) continue;
                map.put(e.getKey().toString(), e.getValue().toString());
            }
        }
        req.setConfiguration(map);
        try {
            TSetClientInfoResp openResp = this.client.SetClientInfo(req);
            Utils.verifySuccess(openResp.getStatus());
        }
        catch (SQLException | TException e) {
            LOG.error("Error setting client info", e);
            throw new SQLClientInfoException("Error setting client info", null, e);
        }
    }

    @Override
    public void setReadOnly(boolean readOnly) throws SQLException {
        if (this.isClosed) {
            throw new KyuubiSQLException("Connection is closed");
        }
        if (readOnly) {
            throw new KyuubiSQLException("Enabling read-only mode not supported");
        }
    }

    @Override
    public void setSchema(String schema) throws SQLException {
        if (this.isClosed) {
            throw new KyuubiSQLException("Connection is closed");
        }
        if (schema == null || schema.isEmpty()) {
            throw new KyuubiSQLException("Schema name is null or empty");
        }
        try (KyuubiStatement stmt = this.createKyuubiStatement();){
            stmt.executeSetCurrentDatabase("use " + schema, schema);
        }
    }

    @Override
    public void setTransactionIsolation(int level) throws SQLException {
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return iface.isInstance(this);
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        if (!this.isWrapperFor(iface)) {
            throw new KyuubiSQLException(this.getClass().getName() + " not unwrappable from " + iface.getName());
        }
        return iface.cast(this);
    }

    public TProtocolVersion getProtocol() {
        return this.protocol;
    }

    public static TCLIService.Iface newSynchronizedClient(TCLIService.Iface client) {
        return (TCLIService.Iface)Proxy.newProxyInstance(KyuubiConnection.class.getClassLoader(), new Class[]{TCLIService.Iface.class}, (InvocationHandler)new SynchronizedHandler(client));
    }

    public void waitLaunchEngineToComplete() throws SQLException {
        if (this.launchEngineOpHandle == null) {
            return;
        }
        TGetOperationStatusReq statusReq = new TGetOperationStatusReq(this.launchEngineOpHandle);
        while (!this.launchEngineOpCompleted) {
            try {
                TGetOperationStatusResp statusResp = this.client.GetOperationStatus(statusReq);
                Utils.verifySuccessWithInfo(statusResp.getStatus());
                if (!statusResp.isSetOperationState()) continue;
                switch (statusResp.getOperationState()) {
                    case FINISHED_STATE: {
                        this.fetchLaunchEngineResult();
                    }
                    case CLOSED_STATE: {
                        this.launchEngineOpCompleted = true;
                        this.engineLogInflight = false;
                        break;
                    }
                    case CANCELED_STATE: {
                        throw new KyuubiSQLException("Launch engine was cancelled", "01000");
                    }
                    case TIMEDOUT_STATE: {
                        throw new SQLTimeoutException("Launch engine timeout");
                    }
                    case ERROR_STATE: {
                        throw new KyuubiSQLException(statusResp.getErrorMessage(), statusResp.getSqlState(), statusResp.getErrorCode());
                    }
                    case UKNOWN_STATE: {
                        throw new KyuubiSQLException("Unknown state", "HY000");
                    }
                }
            }
            catch (Exception e) {
                this.engineLogInflight = false;
                this.closeOnLaunchEngineFailure();
                if (e instanceof SQLException) {
                    throw (SQLException)e;
                }
                throw new KyuubiSQLException(e.getMessage(), "08S01", e);
            }
        }
    }

    private void fetchLaunchEngineResult() {
        if (this.launchEngineOpHandle == null || !this.launchEngineOpSupportResult) {
            return;
        }
        TFetchResultsReq tFetchResultsReq = new TFetchResultsReq(this.launchEngineOpHandle, TFetchOrientation.FETCH_NEXT, 1000L);
        try {
            TFetchResultsResp tFetchResultsResp = this.client.FetchResults(tFetchResultsReq);
            RowSet rowSet = RowSetFactory.create(tFetchResultsResp.getResults(), this.getProtocol());
            for (Object[] row : rowSet) {
                String key = String.valueOf(row[0]);
                String value = String.valueOf(row[1]);
                if ("id".equals(key)) {
                    this.engineId = value;
                    continue;
                }
                if ("name".equals(key)) {
                    this.engineName = value;
                    continue;
                }
                if (!"url".equals(key)) continue;
                this.engineUrl = value;
            }
        }
        catch (Exception e) {
            LOG.error("Error fetching launch engine result", (Throwable)e);
        }
    }

    public String getEngineId() {
        return this.engineId;
    }

    public String getEngineName() {
        return this.engineName;
    }

    public String getEngineUrl() {
        return this.engineUrl;
    }

    private static class SynchronizedHandler
    implements InvocationHandler {
        private final TCLIService.Iface client;
        private final ReentrantLock lock = new ReentrantLock(true);

        SynchronizedHandler(TCLIService.Iface client) {
            this.client = client;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            try {
                this.lock.lock();
                Object object = method.invoke((Object)this.client, args);
                return object;
            }
            catch (InvocationTargetException e) {
                if (e.getTargetException() instanceof TException) {
                    throw e.getTargetException();
                }
                throw new TException("Error in calling method " + method.getName(), e.getTargetException());
            }
            catch (Exception e) {
                throw new TException("Error in calling method " + method.getName(), (Throwable)e);
            }
            finally {
                this.lock.unlock();
            }
        }
    }
}

