/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kyuubi.engine.flink;

import java.io.File;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.net.URL;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.flink.core.fs.Path;
import org.apache.flink.runtime.util.EnvironmentInformation;
import org.apache.flink.table.client.SqlClientException;
import org.apache.flink.table.client.cli.CliOptions;
import org.apache.flink.table.client.cli.CliOptionsParser;
import org.apache.flink.table.client.gateway.context.SessionContext;
import org.apache.flink.table.client.gateway.local.LocalExecutor;
import org.apache.kyuubi.Logging;
import org.apache.kyuubi.engine.SemanticVersion;
import org.apache.kyuubi.engine.SemanticVersion$;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.immutable.List;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;

public final class FlinkEngineUtils$
implements Logging {
    public static FlinkEngineUtils$ MODULE$;
    private final String MODE_EMBEDDED;
    private final Options EMBEDDED_MODE_CLIENT_OPTIONS;
    private final SemanticVersion[] SUPPORTED_FLINK_VERSIONS;
    private transient Logger org$apache$kyuubi$Logging$$log_;

    static {
        new FlinkEngineUtils$();
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public Logger logger() {
        return Logging.logger$(this);
    }

    @Override
    public void debug(Function0<Object> message) {
        Logging.debug$(this, message);
    }

    @Override
    public void info(Function0<Object> message) {
        Logging.info$(this, message);
    }

    @Override
    public void warn(Function0<Object> message) {
        Logging.warn$(this, message);
    }

    @Override
    public void warn(Function0<Object> message, Throwable t) {
        Logging.warn$(this, message, t);
    }

    @Override
    public void error(Function0<Object> message, Throwable t) {
        Logging.error$(this, message, t);
    }

    @Override
    public void error(Function0<Object> message) {
        Logging.error$(this, message);
    }

    @Override
    public void initializeLoggerIfNecessary(boolean isInterpreter) {
        Logging.initializeLoggerIfNecessary$(this, isInterpreter);
    }

    @Override
    public Logger org$apache$kyuubi$Logging$$log_() {
        return this.org$apache$kyuubi$Logging$$log_;
    }

    @Override
    public void org$apache$kyuubi$Logging$$log__$eq(Logger x$1) {
        this.org$apache$kyuubi$Logging$$log_ = x$1;
    }

    public String MODE_EMBEDDED() {
        return this.MODE_EMBEDDED;
    }

    public Options EMBEDDED_MODE_CLIENT_OPTIONS() {
        return this.EMBEDDED_MODE_CLIENT_OPTIONS;
    }

    public SemanticVersion[] SUPPORTED_FLINK_VERSIONS() {
        return this.SUPPORTED_FLINK_VERSIONS;
    }

    public void checkFlinkVersion() {
        String flinkVersion = EnvironmentInformation.getVersion();
        if (!new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.SUPPORTED_FLINK_VERSIONS())).contains((Object)SemanticVersion$.MODULE$.apply(flinkVersion))) {
            throw new UnsupportedOperationException(new StringBuilder(72).append("You are using unsupported Flink version ").append(flinkVersion).append(", ").append("only Flink ").append(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.SUPPORTED_FLINK_VERSIONS())).mkString(", ")).append(" are supported now.").toString());
        }
        this.info((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(29).append("The current Flink version is ").append(flinkVersion).toString());
    }

    public boolean isFlinkVersionAtMost(String targetVersionString) {
        return SemanticVersion$.MODULE$.apply(EnvironmentInformation.getVersion()).isVersionAtMost(targetVersionString);
    }

    public boolean isFlinkVersionAtLeast(String targetVersionString) {
        return SemanticVersion$.MODULE$.apply(EnvironmentInformation.getVersion()).isVersionAtLeast(targetVersionString);
    }

    public boolean isFlinkVersionEqualTo(String targetVersionString) {
        return SemanticVersion$.MODULE$.apply(EnvironmentInformation.getVersion()).isVersionEqualTo(targetVersionString);
    }

    public CliOptions parseCliOptions(String[] args) {
        Tuple2 tuple2;
        Tuple2 tuple22 = tuple2 = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])args)).isEmpty() || args[0].startsWith("-") ? new Tuple2((Object)this.MODE_EMBEDDED(), (Object)args) : new Tuple2((Object)args[0], new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])args)).drop(1));
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String mode = (String)tuple2._1();
        String[] modeArgs = (String[])tuple2._2();
        Tuple2 tuple23 = new Tuple2((Object)mode, (Object)modeArgs);
        Tuple2 tuple24 = tuple23;
        String mode2 = (String)tuple24._1();
        String[] modeArgs2 = (String[])tuple24._2();
        CliOptions options = this.parseEmbeddedModeClient(modeArgs2);
        String string = mode2;
        String string2 = this.MODE_EMBEDDED();
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            if (options.isPrintHelp()) {
                CliOptionsParser.printHelpEmbeddedModeClient();
            }
        } else {
            throw new SqlClientException("Other mode is not supported yet.");
        }
        return options;
    }

    public SessionContext getSessionContext(LocalExecutor localExecutor, String sessionId) {
        Method method = LocalExecutor.class.getDeclaredMethod("getSessionContext", String.class);
        method.setAccessible(true);
        return (SessionContext)method.invoke((Object)localExecutor, sessionId);
    }

    public CliOptions parseEmbeddedModeClient(String[] args) {
        CliOptions cliOptions;
        try {
            DefaultParser parser = new DefaultParser();
            CommandLine line = parser.parse(this.EMBEDDED_MODE_CLIENT_OPTIONS(), args, true);
            List<URL> jarUrls = this.checkUrls(line, CliOptionsParser.OPTION_JAR);
            List<URL> libraryUrls = this.checkUrls(line, CliOptionsParser.OPTION_LIBRARY);
            cliOptions = new CliOptions(line.hasOption(CliOptionsParser.OPTION_HELP.getOpt()), this.checkSessionId(line), this.checkUrl(line, CliOptionsParser.OPTION_INIT_FILE), this.checkUrl(line, CliOptionsParser.OPTION_FILE), jarUrls != null && jarUrls.nonEmpty() ? (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(jarUrls).asJava() : null, libraryUrls != null && libraryUrls.nonEmpty() ? (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(libraryUrls).asJava() : null, line.getOptionValue(CliOptionsParser.OPTION_UPDATE.getOpt()), line.getOptionValue(CliOptionsParser.OPTION_HISTORY.getOpt()), null);
        }
        catch (ParseException e) {
            throw new SqlClientException(e.getMessage());
        }
        return cliOptions;
    }

    /*
     * WARNING - void declaration
     */
    public String checkSessionId(CommandLine line) {
        void var2_2;
        String sessionId = line.getOptionValue(CliOptionsParser.OPTION_SESSION.getOpt());
        if (sessionId != null && !sessionId.matches("[a-zA-Z0-9_\\-.]+")) {
            throw new SqlClientException("Session identifier must only consists of 'a-zA-Z0-9_-.'.");
        }
        return var2_2;
    }

    public URL checkUrl(CommandLine line, Option option) {
        List<URL> urls = this.checkUrls(line, option);
        return urls != null && urls.nonEmpty() ? (URL)urls.head() : null;
    }

    public List<URL> checkUrls(CommandLine line, Option option) {
        return line.hasOption(option.getOpt()) ? new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])line.getOptionValues(option.getOpt()))).distinct())).map((Function1 & Serializable & scala.Serializable)url -> {
            URL uRL;
            CliOptionsParser.checkFilePath((String)url);
            try {
                uRL = Path.fromLocalFile((File)new File((String)url).getAbsoluteFile()).toUri().toURL();
            }
            catch (Exception e) {
                throw new SqlClientException(new StringBuilder(28).append("Invalid path for option '").append(option.getLongOpt()).append("': ").append((String)url).toString(), (Throwable)e);
            }
            return uRL;
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(URL.class))))).toList() : null;
    }

    private FlinkEngineUtils$() {
        MODULE$ = this;
        Logging.$init$(this);
        this.MODE_EMBEDDED = "embedded";
        this.EMBEDDED_MODE_CLIENT_OPTIONS = CliOptionsParser.getEmbeddedModeClientOptions((Options)new Options());
        this.SUPPORTED_FLINK_VERSIONS = (SemanticVersion[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new String[]{"1.14", "1.15"})).map((Function1 & Serializable & scala.Serializable)versionString -> SemanticVersion$.MODULE$.apply((String)versionString), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(SemanticVersion.class)));
    }
}

