/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kyuubi.schema;

import java.io.Serializable;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.chrono.IsoChronology;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.temporal.ChronoField;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import org.apache.hive.service.rpc.thrift.TBinaryColumn;
import org.apache.hive.service.rpc.thrift.TBoolColumn;
import org.apache.hive.service.rpc.thrift.TBoolValue;
import org.apache.hive.service.rpc.thrift.TByteColumn;
import org.apache.hive.service.rpc.thrift.TByteValue;
import org.apache.hive.service.rpc.thrift.TColumn;
import org.apache.hive.service.rpc.thrift.TColumnValue;
import org.apache.hive.service.rpc.thrift.TDoubleColumn;
import org.apache.hive.service.rpc.thrift.TDoubleValue;
import org.apache.hive.service.rpc.thrift.TI16Column;
import org.apache.hive.service.rpc.thrift.TI16Value;
import org.apache.hive.service.rpc.thrift.TI32Column;
import org.apache.hive.service.rpc.thrift.TI32Value;
import org.apache.hive.service.rpc.thrift.TI64Column;
import org.apache.hive.service.rpc.thrift.TI64Value;
import org.apache.hive.service.rpc.thrift.TProtocolVersion;
import org.apache.hive.service.rpc.thrift.TRow;
import org.apache.hive.service.rpc.thrift.TRowSet;
import org.apache.hive.service.rpc.thrift.TStringColumn;
import org.apache.hive.service.rpc.thrift.TStringValue;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.DecimalType$;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.TimestampType$;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.Iterable$;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;

public final class RowSet$ {
    public static RowSet$ MODULE$;
    private DateTimeFormatter dateFormatter;
    private SimpleDateFormat simpleDateFormatter;
    private DateTimeFormatter timestampFormatter;
    private SimpleDateFormat simpleTimestampFormatter;
    private volatile byte bitmap$0;

    static {
        new RowSet$();
    }

    public TRowSet toTRowSet(Seq<Row> rows, StructType schema, TProtocolVersion protocolVersion, ZoneId timeZone) {
        return protocolVersion.getValue() < TProtocolVersion.HIVE_CLI_SERVICE_PROTOCOL_V6.getValue() ? this.toRowBasedSet(rows, schema, timeZone) : this.toColumnBasedSet(rows, schema, timeZone);
    }

    public TRowSet toRowBasedSet(Seq<Row> rows, StructType schema, ZoneId timeZone) {
        List tRows = (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)rows.map((Function1 & Serializable & scala.Serializable)row -> {
            void var3_3;
            TRow tRow = new TRow();
            ((IterableLike)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), row.length()).map((Function1 & Serializable & scala.Serializable)i -> RowSet$.MODULE$.toTColumnValue(BoxesRunTime.unboxToInt((Object)i), row, schema, timeZone), IndexedSeq$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
                tRow.addToColVals(x$1);
                return BoxedUnit.UNIT;
            });
            return var3_3;
        }, Seq$.MODULE$.canBuildFrom())).asJava();
        return new TRowSet(0L, tRows);
    }

    public TRowSet toColumnBasedSet(Seq<Row> rows, StructType schema, ZoneId timeZone) {
        int size = rows.length();
        TRowSet tRowSet = new TRowSet(0L, new ArrayList(size));
        ((IterableLike)schema.zipWithIndex(Seq$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            RowSet$.$anonfun$toColumnBasedSet$1(rows, timeZone, tRowSet, x0$1);
            return BoxedUnit.UNIT;
        });
        return tRowSet;
    }

    private TColumn toTColumn(Seq<Row> rows, int ordinal, DataType typ, ZoneId timeZone) {
        TColumn tColumn;
        BitSet nulls = new BitSet();
        DataType dataType = typ;
        if (BooleanType$.MODULE$.equals(dataType)) {
            List<Boolean> values = this.getOrSetAsNull(rows, ordinal, nulls, Predef$.MODULE$.boolean2Boolean(true));
            tColumn = TColumn.boolVal((TBoolColumn)new TBoolColumn(values, this.bitSetToBuffer(nulls)));
        } else if (ByteType$.MODULE$.equals(dataType)) {
            List<Byte> values = this.getOrSetAsNull(rows, ordinal, nulls, Predef$.MODULE$.byte2Byte((byte)0));
            tColumn = TColumn.byteVal((TByteColumn)new TByteColumn(values, this.bitSetToBuffer(nulls)));
        } else if (ShortType$.MODULE$.equals(dataType)) {
            List<Short> values = this.getOrSetAsNull(rows, ordinal, nulls, Predef$.MODULE$.short2Short((short)0));
            tColumn = TColumn.i16Val((TI16Column)new TI16Column(values, this.bitSetToBuffer(nulls)));
        } else if (IntegerType$.MODULE$.equals(dataType)) {
            List<Integer> values = this.getOrSetAsNull(rows, ordinal, nulls, Predef$.MODULE$.int2Integer(0));
            tColumn = TColumn.i32Val((TI32Column)new TI32Column(values, this.bitSetToBuffer(nulls)));
        } else if (LongType$.MODULE$.equals(dataType)) {
            List<Long> values = this.getOrSetAsNull(rows, ordinal, nulls, Predef$.MODULE$.long2Long(0L));
            tColumn = TColumn.i64Val((TI64Column)new TI64Column(values, this.bitSetToBuffer(nulls)));
        } else if (FloatType$.MODULE$.equals(dataType)) {
            List values = (List)JavaConverters$.MODULE$.bufferAsJavaListConverter((Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(this.getOrSetAsNull(rows, ordinal, nulls, Predef$.MODULE$.float2Float(0.0f))).asScala()).map((Function1 & Serializable & scala.Serializable)n -> Double.valueOf(n.toString()), Buffer$.MODULE$.canBuildFrom())).asJava();
            tColumn = TColumn.doubleVal((TDoubleColumn)new TDoubleColumn(values, this.bitSetToBuffer(nulls)));
        } else if (DoubleType$.MODULE$.equals(dataType)) {
            List<Double> values = this.getOrSetAsNull(rows, ordinal, nulls, Predef$.MODULE$.double2Double(0.0));
            tColumn = TColumn.doubleVal((TDoubleColumn)new TDoubleColumn(values, this.bitSetToBuffer(nulls)));
        } else if (StringType$.MODULE$.equals(dataType)) {
            List<String> values = this.getOrSetAsNull(rows, ordinal, nulls, "");
            tColumn = TColumn.stringVal((TStringColumn)new TStringColumn(values, this.bitSetToBuffer(nulls)));
        } else if (BinaryType$.MODULE$.equals(dataType)) {
            List values = (List)JavaConverters$.MODULE$.bufferAsJavaListConverter((Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(this.getOrSetAsNull(rows, ordinal, nulls, Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.Byte()))).asScala()).map((Function1 & Serializable & scala.Serializable)x$1 -> ByteBuffer.wrap(x$1), Buffer$.MODULE$.canBuildFrom())).asJava();
            tColumn = TColumn.binaryVal((TBinaryColumn)new TBinaryColumn(values, this.bitSetToBuffer(nulls)));
        } else {
            List values = (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)((TraversableOnce)rows.zipWithIndex(Seq$.MODULE$.canBuildFrom())).toList().map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                Row row = (Row)tuple2._1();
                int i = tuple2._2$mcI$sp();
                nulls.set(i, row.isNullAt(ordinal));
                String string = row.isNullAt(ordinal) ? "" : MODULE$.toHiveString((Tuple2<Object, DataType>)new Tuple2(row.get(ordinal), (Object)typ), timeZone);
                return string;
            }, List$.MODULE$.canBuildFrom())).asJava();
            tColumn = TColumn.stringVal((TStringColumn)new TStringColumn(values, this.bitSetToBuffer(nulls)));
        }
        return tColumn;
    }

    private <T> List<T> getOrSetAsNull(Seq<Row> rows, int ordinal, BitSet nulls, T defaultVal) {
        int size = rows.length();
        ArrayList<Object> ret = new ArrayList<Object>(size);
        for (int idx = 0; idx < size; ++idx) {
            Row row = (Row)rows.apply(idx);
            boolean isNull = row.isNullAt(ordinal);
            if (isNull) {
                nulls.set(idx, true);
                ret.add(idx, defaultVal);
                continue;
            }
            ret.add(idx, row.getAs(ordinal));
        }
        return ret;
    }

    private ByteBuffer bitSetToBuffer(BitSet bitSet) {
        return ByteBuffer.wrap(bitSet.toByteArray());
    }

    private TColumnValue toTColumnValue(int ordinal, Row row, StructType types, ZoneId timeZone) {
        TColumnValue tColumnValue;
        DataType dataType = types.apply(ordinal).dataType();
        if (BooleanType$.MODULE$.equals(dataType)) {
            TBoolValue boolValue = new TBoolValue();
            if (!row.isNullAt(ordinal)) {
                boolValue.setValue(row.getBoolean(ordinal));
            }
            tColumnValue = TColumnValue.boolVal((TBoolValue)boolValue);
        } else if (ByteType$.MODULE$.equals(dataType)) {
            TByteValue byteValue = new TByteValue();
            if (!row.isNullAt(ordinal)) {
                byteValue.setValue(row.getByte(ordinal));
            }
            tColumnValue = TColumnValue.byteVal((TByteValue)byteValue);
        } else if (ShortType$.MODULE$.equals(dataType)) {
            TI16Value tI16Value = new TI16Value();
            if (!row.isNullAt(ordinal)) {
                tI16Value.setValue(row.getShort(ordinal));
            }
            tColumnValue = TColumnValue.i16Val((TI16Value)tI16Value);
        } else if (IntegerType$.MODULE$.equals(dataType)) {
            TI32Value tI32Value = new TI32Value();
            if (!row.isNullAt(ordinal)) {
                tI32Value.setValue(row.getInt(ordinal));
            }
            tColumnValue = TColumnValue.i32Val((TI32Value)tI32Value);
        } else if (LongType$.MODULE$.equals(dataType)) {
            TI64Value tI64Value = new TI64Value();
            if (!row.isNullAt(ordinal)) {
                tI64Value.setValue(row.getLong(ordinal));
            }
            tColumnValue = TColumnValue.i64Val((TI64Value)tI64Value);
        } else if (FloatType$.MODULE$.equals(dataType)) {
            TDoubleValue tDoubleValue = new TDoubleValue();
            if (!row.isNullAt(ordinal)) {
                Double doubleValue = Double.valueOf(Float.toString(row.getFloat(ordinal)));
                tDoubleValue.setValue(Predef$.MODULE$.Double2double(doubleValue));
            }
            tColumnValue = TColumnValue.doubleVal((TDoubleValue)tDoubleValue);
        } else if (DoubleType$.MODULE$.equals(dataType)) {
            TDoubleValue tDoubleValue = new TDoubleValue();
            if (!row.isNullAt(ordinal)) {
                tDoubleValue.setValue(row.getDouble(ordinal));
            }
            tColumnValue = TColumnValue.doubleVal((TDoubleValue)tDoubleValue);
        } else if (StringType$.MODULE$.equals(dataType)) {
            TStringValue tStringValue = new TStringValue();
            if (!row.isNullAt(ordinal)) {
                tStringValue.setValue(row.getString(ordinal));
            }
            tColumnValue = TColumnValue.stringVal((TStringValue)tStringValue);
        } else {
            TStringValue tStrValue = new TStringValue();
            if (!row.isNullAt(ordinal)) {
                tStrValue.setValue(this.toHiveString((Tuple2<Object, DataType>)new Tuple2(row.get(ordinal), (Object)types.apply(ordinal).dataType()), timeZone));
            }
            tColumnValue = TColumnValue.stringVal((TStringValue)tStrValue);
        }
        return tColumnValue;
    }

    private DateTimeFormatterBuilder createBuilder() {
        return new DateTimeFormatterBuilder().parseCaseInsensitive();
    }

    private DateTimeFormatter dateFormatter$lzycompute() {
        RowSet$ rowSet$ = this;
        synchronized (rowSet$) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.dateFormatter = this.createBuilder().appendPattern("yyyy-MM-dd").toFormatter(Locale.US).withChronology(IsoChronology.INSTANCE);
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.dateFormatter;
    }

    private DateTimeFormatter dateFormatter() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.dateFormatter$lzycompute() : this.dateFormatter;
    }

    private SimpleDateFormat simpleDateFormatter$lzycompute() {
        RowSet$ rowSet$ = this;
        synchronized (rowSet$) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.simpleDateFormatter = new SimpleDateFormat("yyyy-MM-dd", Locale.US);
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.simpleDateFormatter;
    }

    private SimpleDateFormat simpleDateFormatter() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.simpleDateFormatter$lzycompute() : this.simpleDateFormatter;
    }

    private DateTimeFormatter timestampFormatter$lzycompute() {
        RowSet$ rowSet$ = this;
        synchronized (rowSet$) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                this.timestampFormatter = this.createBuilder().appendPattern("yyyy-MM-dd HH:mm:ss").appendFraction(ChronoField.NANO_OF_SECOND, 0, 9, true).toFormatter(Locale.US).withChronology(IsoChronology.INSTANCE);
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
        }
        return this.timestampFormatter;
    }

    private DateTimeFormatter timestampFormatter() {
        return (byte)(this.bitmap$0 & 4) == 0 ? this.timestampFormatter$lzycompute() : this.timestampFormatter;
    }

    private SimpleDateFormat simpleTimestampFormatter$lzycompute() {
        RowSet$ rowSet$ = this;
        synchronized (rowSet$) {
            if ((byte)(this.bitmap$0 & 8) == 0) {
                this.simpleTimestampFormatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS", Locale.US);
                this.bitmap$0 = (byte)(this.bitmap$0 | 8);
            }
        }
        return this.simpleTimestampFormatter;
    }

    private SimpleDateFormat simpleTimestampFormatter() {
        return (byte)(this.bitmap$0 & 8) == 0 ? this.simpleTimestampFormatter$lzycompute() : this.simpleTimestampFormatter;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String toHiveString(Tuple2<Object, DataType> dataWithType, ZoneId timeZone) {
        Object object;
        Tuple2<Object, DataType> tuple2 = dataWithType;
        if (tuple2 != null && (object = tuple2._1()) == null) {
            return "null";
        }
        if (tuple2 != null) {
            Object d = tuple2._1();
            DataType dataType = (DataType)tuple2._2();
            if (d instanceof Date) {
                Date date = (Date)d;
                if (DateType$.MODULE$.equals(dataType)) {
                    return this.simpleDateFormatter().format(date);
                }
            }
        }
        if (tuple2 != null) {
            Object ld = tuple2._1();
            DataType dataType = (DataType)tuple2._2();
            if (ld instanceof LocalDate) {
                LocalDate localDate = (LocalDate)ld;
                if (DateType$.MODULE$.equals(dataType)) {
                    return this.dateFormatter().format(localDate);
                }
            }
        }
        if (tuple2 != null) {
            Object t = tuple2._1();
            DataType dataType = (DataType)tuple2._2();
            if (t instanceof Timestamp) {
                Timestamp timestamp = (Timestamp)t;
                if (TimestampType$.MODULE$.equals(dataType)) {
                    return this.simpleTimestampFormatter().format(timestamp);
                }
            }
        }
        if (tuple2 != null) {
            Object i = tuple2._1();
            DataType dataType = (DataType)tuple2._2();
            if (i instanceof Instant) {
                Instant instant = (Instant)i;
                if (TimestampType$.MODULE$.equals(dataType)) {
                    return this.timestampFormatter().withZone(timeZone).format(instant);
                }
            }
        }
        if (tuple2 != null) {
            Object bin = tuple2._1();
            DataType dataType = (DataType)tuple2._2();
            if (bin instanceof byte[]) {
                byte[] byArray = (byte[])bin;
                if (BinaryType$.MODULE$.equals(dataType)) {
                    return new String(byArray, StandardCharsets.UTF_8);
                }
            }
        }
        if (tuple2 != null) {
            Object decimal = tuple2._1();
            DataType dataType = (DataType)tuple2._2();
            if (decimal instanceof BigDecimal) {
                BigDecimal bigDecimal = (BigDecimal)decimal;
                if (DecimalType$.MODULE$.unapply(dataType)) {
                    return bigDecimal.toPlainString();
                }
            }
        }
        if (tuple2 != null) {
            Object s = tuple2._1();
            DataType dataType = (DataType)tuple2._2();
            if (s instanceof String) {
                String string = (String)s;
                if (StringType$.MODULE$.equals(dataType)) {
                    return new StringBuilder(2).append("\"").append(string).append("\"").toString();
                }
            }
        }
        if (tuple2 != null) {
            Object seq = tuple2._1();
            DataType dataType = (DataType)tuple2._2();
            if (seq instanceof Seq) {
                Seq seq2 = (Seq)seq;
                if (dataType instanceof ArrayType) {
                    ArrayType arrayType = (ArrayType)dataType;
                    DataType typ = arrayType.elementType();
                    return ((TraversableOnce)((TraversableLike)seq2.map((Function1 & Serializable & scala.Serializable)v -> new Tuple2(v, (Object)typ), Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)e -> MODULE$.toHiveString((Tuple2<Object, DataType>)e, timeZone), Seq$.MODULE$.canBuildFrom())).mkString("[", ",", "]");
                }
            }
        }
        if (tuple2 != null) {
            Object m = tuple2._1();
            DataType dataType = (DataType)tuple2._2();
            if (m instanceof Map) {
                Map map = (Map)m;
                if (dataType instanceof MapType) {
                    MapType mapType = (MapType)dataType;
                    DataType kType = mapType.keyType();
                    DataType vType = mapType.valueType();
                    return ((TraversableOnce)((TraversableOnce)map.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                        Tuple2 tuple2 = x0$1;
                        if (tuple2 == null) {
                            throw new MatchError((Object)tuple2);
                        }
                        Object key = tuple2._1();
                        Object value = tuple2._2();
                        String string = new StringBuilder(1).append(MODULE$.toHiveString((Tuple2<Object, DataType>)new Tuple2(key, (Object)kType), timeZone)).append(":").append(MODULE$.toHiveString((Tuple2<Object, DataType>)new Tuple2(value, (Object)vType), timeZone)).toString();
                        return string;
                    }, Iterable$.MODULE$.canBuildFrom())).toSeq().sorted((Ordering)Ordering.String$.MODULE$)).mkString("{", ",", "}");
                }
            }
        }
        if (tuple2 != null) {
            Object struct = tuple2._1();
            DataType dataType = (DataType)tuple2._2();
            if (struct instanceof Row) {
                Row row = (Row)struct;
                if (dataType instanceof StructType) {
                    StructType structType = (StructType)dataType;
                    StructField[] fields = structType.fields();
                    return ((TraversableOnce)((TraversableLike)row.toSeq().zip((GenIterable)Predef$.MODULE$.wrapRefArray((Object[])fields), Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x0$2 -> {
                        Tuple2 tuple2 = x0$2;
                        if (tuple2 == null) {
                            throw new MatchError((Object)tuple2);
                        }
                        Object v = tuple2._1();
                        StructField t = (StructField)tuple2._2();
                        String string = new StringBuilder(3).append("\"").append(t.name()).append("\":").append(MODULE$.toHiveString((Tuple2<Object, DataType>)new Tuple2(v, (Object)t.dataType()), timeZone)).toString();
                        return string;
                    }, Seq$.MODULE$.canBuildFrom())).mkString("{", ",", "}");
                }
            }
        }
        if (tuple2 == null) throw new MatchError(tuple2);
        Object other = tuple2._1();
        return other.toString();
    }

    public static final /* synthetic */ void $anonfun$toColumnBasedSet$1(Seq rows$1, ZoneId timeZone$2, TRowSet tRowSet$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        StructField filed = (StructField)tuple2._1();
        int i = tuple2._2$mcI$sp();
        TColumn tColumn = MODULE$.toTColumn((Seq<Row>)rows$1, i, filed.dataType(), timeZone$2);
        tRowSet$1.addToColumns(tColumn);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    private RowSet$() {
        MODULE$ = this;
    }
}

