/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.service.cli.operation;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.security.PrivilegedExceptionAction;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.codec.binary.Base64;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.common.metrics.common.Metrics;
import org.apache.hadoop.hive.common.metrics.common.MetricsFactory;
import org.apache.hadoop.hive.common.metrics.common.MetricsScope;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.Schema;
import org.apache.hadoop.hive.ql.CommandNeedRetryException;
import org.apache.hadoop.hive.ql.Driver;
import org.apache.hadoop.hive.ql.QueryState;
import org.apache.hadoop.hive.ql.exec.ExplainTask;
import org.apache.hadoop.hive.ql.exec.FetchTask;
import org.apache.hadoop.hive.ql.exec.Task;
import org.apache.hadoop.hive.ql.log.PerfLogger;
import org.apache.hadoop.hive.ql.metadata.Hive;
import org.apache.hadoop.hive.ql.plan.FetchWork;
import org.apache.hadoop.hive.ql.processors.CommandProcessorResponse;
import org.apache.hadoop.hive.ql.session.OperationLog;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.hadoop.hive.serde2.AbstractSerDe;
import org.apache.hadoop.hive.serde2.Deserializer;
import org.apache.hadoop.hive.serde2.SerDeException;
import org.apache.hadoop.hive.serde2.SerDeUtils;
import org.apache.hadoop.hive.serde2.lazy.LazySimpleSerDe;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructField;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.hive.shims.Utils;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hive.service.cli.FetchOrientation;
import org.apache.hive.service.cli.HiveSQLException;
import org.apache.hive.service.cli.OperationState;
import org.apache.hive.service.cli.RowSet;
import org.apache.hive.service.cli.RowSetFactory;
import org.apache.hive.service.cli.TableSchema;
import org.apache.hive.service.cli.operation.ExecuteStatementOperation;
import org.apache.hive.service.cli.operation.Operation;
import org.apache.hive.service.cli.operation.SQLOperationDisplay;
import org.apache.hive.service.cli.session.HiveSession;
import org.apache.hive.service.server.ThreadWithGarbageCleanup;
import org.codehaus.jackson.JsonGenerationException;
import org.codehaus.jackson.map.JsonMappingException;
import org.codehaus.jackson.map.ObjectMapper;

public class SQLOperation
extends ExecuteStatementOperation {
    private Driver driver = null;
    private CommandProcessorResponse response;
    private TableSchema resultSchema = null;
    private Schema mResultSchema = null;
    private AbstractSerDe serde = null;
    private boolean fetchStarted = false;
    private volatile MetricsScope currentSQLStateScope;
    private SQLOperationDisplay sqlOpDisplay;
    private long queryTimeout;
    private ScheduledExecutorService timeoutExecutor;
    private final boolean runAsync;
    private static Map<String, AtomicInteger> userQueries = new HashMap<String, AtomicInteger>();
    private static final String ACTIVE_SQL_USER = "hs2_sql_operation_active_user";
    private MetricsScope submittedQryScp;
    private final transient List<Object> convey = new ArrayList<Object>();

    public SQLOperation(HiveSession parentSession, String statement, Map<String, String> confOverlay, boolean runInBackground, long queryTimeout) {
        super(parentSession, statement, confOverlay, runInBackground);
        this.runAsync = runInBackground;
        this.queryTimeout = queryTimeout;
        long timeout = HiveConf.getTimeVar((Configuration)this.queryState.getConf(), (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_QUERY_TIMEOUT_SECONDS, (TimeUnit)TimeUnit.SECONDS);
        if (timeout > 0L && (queryTimeout <= 0L || timeout < queryTimeout)) {
            this.queryTimeout = timeout;
        }
        this.setupSessionIO(parentSession.getSessionState());
        try {
            this.sqlOpDisplay = new SQLOperationDisplay(this);
        }
        catch (HiveSQLException e) {
            LOG.warn("Error calcluating SQL Operation Display for webui", (Throwable)e);
        }
        Metrics metrics = MetricsFactory.getInstance();
        if (metrics != null) {
            this.submittedQryScp = metrics.createScope("hs2_submitted_queries");
        }
    }

    @Override
    public boolean shouldRunAsync() {
        return this.runAsync;
    }

    private void setupSessionIO(SessionState sessionState) {
        try {
            sessionState.in = null;
            sessionState.out = new PrintStream((OutputStream)System.out, true, "UTF-8");
            sessionState.info = new PrintStream((OutputStream)System.err, true, "UTF-8");
            sessionState.err = new PrintStream((OutputStream)System.err, true, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            LOG.error("Error creating PrintStream", (Throwable)e);
            e.printStackTrace();
            sessionState.out = null;
            sessionState.info = null;
            sessionState.err = null;
        }
    }

    public void prepare(QueryState queryState) throws HiveSQLException {
        this.setState(OperationState.RUNNING);
        try {
            this.driver = new Driver(queryState, this.getParentSession().getUserName());
            if (this.queryTimeout > 0L) {
                this.timeoutExecutor = new ScheduledThreadPoolExecutor(1);
                Runnable timeoutTask = new Runnable(){

                    @Override
                    public void run() {
                        try {
                            String queryId = (String)SQLOperation.this.confOverlay.get(HiveConf.ConfVars.HIVEQUERYID.varname);
                            Operation.LOG.info("Query timed out after: " + SQLOperation.this.queryTimeout + " seconds. Cancelling the execution now: " + queryId);
                            SQLOperation.this.cancel(OperationState.TIMEDOUT);
                        }
                        catch (HiveSQLException e) {
                            Operation.LOG.error("Error cancelling the query after timeout: " + SQLOperation.this.queryTimeout + " seconds", (Throwable)e);
                        }
                        finally {
                            SQLOperation.this.timeoutExecutor.shutdown();
                        }
                    }
                };
                this.timeoutExecutor.schedule(timeoutTask, this.queryTimeout, TimeUnit.SECONDS);
            }
            this.sqlOpDisplay.setQueryDisplay(this.driver.getQueryDisplay());
            String guid64 = Base64.encodeBase64URLSafeString((byte[])this.getHandle().getHandleIdentifier().toTHandleIdentifier().getGuid()).trim();
            this.driver.setOperationId(guid64);
            this.driver.setTryCount(Integer.MAX_VALUE);
            this.response = this.driver.compileAndRespond(this.statement);
            if (0 != this.response.getResponseCode()) {
                throw this.toSQLException("Error while compiling statement", this.response);
            }
            this.mResultSchema = this.driver.getSchema();
            if (this.driver.getPlan().getFetchTask() != null) {
                if (this.mResultSchema == null || !this.mResultSchema.isSetFieldSchemas()) {
                    throw new HiveSQLException("Error compiling query: Schema and FieldSchema should be set when query plan has a FetchTask");
                }
                this.resultSchema = new TableSchema(this.mResultSchema);
                this.setHasResultSet(true);
            } else {
                this.setHasResultSet(false);
            }
            for (Task task : this.driver.getPlan().getRootTasks()) {
                if (task.getClass() != ExplainTask.class) continue;
                this.resultSchema = new TableSchema(this.mResultSchema);
                this.setHasResultSet(true);
                break;
            }
        }
        catch (HiveSQLException e) {
            this.setState(OperationState.ERROR);
            throw e;
        }
        catch (Throwable e) {
            this.setState(OperationState.ERROR);
            throw new HiveSQLException("Error running query: " + e.toString(), e);
        }
    }

    private void runQuery() throws HiveSQLException {
        try {
            OperationState opState = this.getStatus().getState();
            if (opState.isTerminal()) {
                LOG.info("Not running the query. Operation is already in terminal state: " + (Object)((Object)opState) + ", perhaps cancelled due to query timeout or by another thread.");
                return;
            }
            this.driver.setTryCount(Integer.MAX_VALUE);
            this.response = this.driver.run();
            if (0 != this.response.getResponseCode()) {
                throw this.toSQLException("Error while processing statement", this.response);
            }
        }
        catch (Throwable e) {
            if (this.getStatus().getState() == OperationState.CANCELED || this.getStatus().getState() == OperationState.TIMEDOUT || this.getStatus().getState() == OperationState.CLOSED) {
                LOG.warn("Ignore exception in terminal state", e);
                return;
            }
            this.setState(OperationState.ERROR);
            if (e instanceof HiveSQLException) {
                throw (HiveSQLException)e;
            }
            throw new HiveSQLException("Error running query: " + e.toString(), e);
        }
        this.setState(OperationState.FINISHED);
    }

    @Override
    public void runInternal() throws HiveSQLException {
        boolean asyncPrepare;
        this.setState(OperationState.PENDING);
        boolean runAsync = this.shouldRunAsync();
        boolean bl = asyncPrepare = runAsync && HiveConf.getBoolVar((Configuration)this.queryState.getConf(), (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_SERVER2_ASYNC_EXEC_ASYNC_COMPILE);
        if (!asyncPrepare) {
            this.prepare(this.queryState);
        }
        if (!runAsync) {
            this.runQuery();
        } else {
            BackgroundWork work = new BackgroundWork(this.getCurrentUGI(), this.parentSession.getSessionHive(), SessionState.getPerfLogger(), SessionState.get(), asyncPrepare);
            try {
                Future<?> backgroundHandle = this.getParentSession().submitBackgroundOperation(work);
                this.setBackgroundHandle(backgroundHandle);
            }
            catch (RejectedExecutionException rejected) {
                this.setState(OperationState.ERROR);
                throw new HiveSQLException("The background threadpool cannot accept new task for execution, please retry the operation", rejected);
            }
        }
    }

    private UserGroupInformation getCurrentUGI() throws HiveSQLException {
        try {
            return Utils.getUGI();
        }
        catch (Exception e) {
            throw new HiveSQLException("Unable to get current user", e);
        }
    }

    private void registerCurrentOperationLog() {
        if (this.isOperationLogEnabled) {
            if (this.operationLog == null) {
                LOG.warn("Failed to get current OperationLog object of Operation: " + this.getHandle().getHandleIdentifier());
                this.isOperationLogEnabled = false;
                return;
            }
            OperationLog.setCurrentOperationLog((OperationLog)this.operationLog);
        }
    }

    private synchronized void cleanup(OperationState state) throws HiveSQLException {
        boolean success;
        Future<?> backgroundHandle;
        this.setState(state);
        if (this.shouldRunAsync() && (backgroundHandle = this.getBackgroundHandle()) != null && (success = backgroundHandle.cancel(true))) {
            String queryId = (String)this.confOverlay.get(HiveConf.ConfVars.HIVEQUERYID.varname);
            LOG.info("The running operation has been successfully interrupted: " + queryId);
        }
        if (this.driver != null) {
            this.driver.close();
            this.driver.destroy();
        }
        this.driver = null;
        SessionState ss = SessionState.get();
        if (ss == null) {
            LOG.warn("Operation seems to be in invalid state, SessionState is null");
        } else {
            ss.deleteTmpOutputFile();
            ss.deleteTmpErrOutputFile();
        }
        if (this.timeoutExecutor != null && state != OperationState.TIMEDOUT && state.isTerminal()) {
            this.timeoutExecutor.shutdownNow();
        }
    }

    @Override
    public void cancel(OperationState stateAfterCancel) throws HiveSQLException {
        this.cleanup(stateAfterCancel);
        this.cleanupOperationLog();
    }

    @Override
    public void close() throws HiveSQLException {
        this.cleanup(OperationState.CLOSED);
        this.cleanupOperationLog();
    }

    @Override
    public TableSchema getResultSetSchema() throws HiveSQLException {
        this.assertState(new ArrayList<OperationState>(Arrays.asList(OperationState.RUNNING, OperationState.FINISHED)));
        if (this.resultSchema == null) {
            this.resultSchema = new TableSchema(this.driver.getSchema());
        }
        return this.resultSchema;
    }

    @Override
    public RowSet getNextRowSet(FetchOrientation orientation, long maxRows) throws HiveSQLException {
        this.validateDefaultFetchOrientation(orientation);
        this.assertState(new ArrayList<OperationState>(Arrays.asList(OperationState.FINISHED)));
        FetchTask fetchTask = this.driver.getFetchTask();
        boolean isBlobBased = false;
        if (fetchTask != null && ((FetchWork)fetchTask.getWork()).isUsingThriftJDBCBinarySerDe()) {
            maxRows = 1L;
            isBlobBased = true;
        }
        this.driver.setMaxRows((int)maxRows);
        RowSet rowSet = RowSetFactory.create(this.resultSchema, this.getProtocolVersion(), isBlobBased);
        try {
            if (orientation.equals((Object)FetchOrientation.FETCH_FIRST) && this.fetchStarted) {
                this.driver.resetFetch();
            }
            this.fetchStarted = true;
            this.driver.setMaxRows((int)maxRows);
            if (this.driver.getResults(this.convey)) {
                RowSet rowSet2 = this.decode(this.convey, rowSet);
                return rowSet2;
            }
            RowSet rowSet3 = rowSet;
            return rowSet3;
        }
        catch (IOException e) {
            throw new HiveSQLException(e);
        }
        catch (CommandNeedRetryException e) {
            throw new HiveSQLException(e);
        }
        catch (Exception e) {
            throw new HiveSQLException(e);
        }
        finally {
            this.convey.clear();
        }
    }

    @Override
    public String getTaskStatus() throws HiveSQLException {
        List statuses;
        if (this.driver != null && (statuses = this.driver.getQueryDisplay().getTaskDisplays()) != null) {
            ByteArrayOutputStream out = null;
            try {
                ObjectMapper mapper = new ObjectMapper();
                out = new ByteArrayOutputStream();
                mapper.writeValue((OutputStream)out, (Object)statuses);
                String string = out.toString("UTF-8");
                return string;
            }
            catch (JsonGenerationException e) {
                throw new HiveSQLException(e);
            }
            catch (JsonMappingException e) {
                throw new HiveSQLException(e);
            }
            catch (IOException e) {
                throw new HiveSQLException(e);
            }
            finally {
                if (out != null) {
                    try {
                        out.close();
                    }
                    catch (IOException e) {
                        throw new HiveSQLException(e);
                    }
                }
            }
        }
        return null;
    }

    private RowSet decode(List<Object> rows, RowSet rowSet) throws Exception {
        if (this.driver.isFetchingTable()) {
            return this.prepareFromRow(rows, rowSet);
        }
        return this.decodeFromString(rows, rowSet);
    }

    private RowSet prepareFromRow(List<Object> rows, RowSet rowSet) throws Exception {
        for (Object row : rows) {
            rowSet.addRow((Object[])row);
        }
        return rowSet;
    }

    private RowSet decodeFromString(List<Object> rows, RowSet rowSet) throws SQLException, SerDeException {
        this.getSerDe();
        StructObjectInspector soi = (StructObjectInspector)this.serde.getObjectInspector();
        List fieldRefs = soi.getAllStructFieldRefs();
        Object[] deserializedFields = new Object[fieldRefs.size()];
        int protocol = this.getProtocolVersion().getValue();
        for (Object rowString : rows) {
            Object rowObj;
            try {
                rowObj = this.serde.deserialize((Writable)new BytesWritable(((String)rowString).getBytes("UTF-8")));
            }
            catch (UnsupportedEncodingException e) {
                throw new SerDeException((Throwable)e);
            }
            for (int i = 0; i < fieldRefs.size(); ++i) {
                StructField fieldRef = (StructField)fieldRefs.get(i);
                ObjectInspector fieldOI = fieldRef.getFieldObjectInspector();
                Object fieldData = soi.getStructFieldData(rowObj, fieldRef);
                deserializedFields[i] = SerDeUtils.toThriftPayload((Object)fieldData, (ObjectInspector)fieldOI, (int)protocol);
            }
            rowSet.addRow(deserializedFields);
        }
        return rowSet;
    }

    private AbstractSerDe getSerDe() throws SQLException {
        if (this.serde != null) {
            return this.serde;
        }
        try {
            List fieldSchemas = this.mResultSchema.getFieldSchemas();
            StringBuilder namesSb = new StringBuilder();
            StringBuilder typesSb = new StringBuilder();
            if (fieldSchemas != null && !fieldSchemas.isEmpty()) {
                for (int pos = 0; pos < fieldSchemas.size(); ++pos) {
                    if (pos != 0) {
                        namesSb.append(",");
                        typesSb.append(",");
                    }
                    namesSb.append(((FieldSchema)fieldSchemas.get(pos)).getName());
                    typesSb.append(((FieldSchema)fieldSchemas.get(pos)).getType());
                }
            }
            String names = namesSb.toString();
            String types = typesSb.toString();
            this.serde = new LazySimpleSerDe();
            Properties props = new Properties();
            if (names.length() > 0) {
                LOG.debug("Column names: " + names);
                props.setProperty("columns", names);
            }
            if (types.length() > 0) {
                LOG.debug("Column types: " + types);
                props.setProperty("columns.types", types);
            }
            SerDeUtils.initializeSerDe((Deserializer)this.serde, (Configuration)this.queryState.getConf(), (Properties)props, null);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new SQLException("Could not create ResultSet: " + ex.getMessage(), ex);
        }
        return this.serde;
    }

    public SQLOperationDisplay getSQLOperationDisplay() {
        return this.sqlOpDisplay;
    }

    @Override
    protected void onNewState(OperationState state, OperationState prevState) {
        super.onNewState(state, prevState);
        this.currentSQLStateScope = this.updateOperationStateMetrics(this.currentSQLStateScope, "hs2_sql_operation_", "hs2_completed_sql_operation_", state);
        Metrics metrics = MetricsFactory.getInstance();
        if (metrics != null) {
            if (state == OperationState.RUNNING && prevState != state) {
                this.incrementUserQueries(metrics);
            }
            if (prevState == OperationState.RUNNING && prevState != state) {
                this.decrementUserQueries(metrics);
            }
        }
        if (state == OperationState.FINISHED || state == OperationState.CANCELED || state == OperationState.ERROR) {
            this.sqlOpDisplay.setRuntime(this.getOperationComplete() - this.getOperationStart());
            if (metrics != null && this.submittedQryScp != null) {
                metrics.endScope(this.submittedQryScp);
            }
        }
        if (state == OperationState.CLOSED) {
            this.sqlOpDisplay.closed();
        } else {
            this.sqlOpDisplay.updateState(state);
        }
        if (state == OperationState.ERROR) {
            this.markQueryMetric(MetricsFactory.getInstance(), "hs2_failed_queries");
        }
        if (state == OperationState.FINISHED) {
            this.markQueryMetric(MetricsFactory.getInstance(), "hs2_succeeded_queries");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void incrementUserQueries(Metrics metrics) {
        String username = this.parentSession.getUserName();
        if (username != null) {
            Map<String, AtomicInteger> map = userQueries;
            synchronized (map) {
                AtomicInteger count = userQueries.get(username);
                if (count == null) {
                    count = new AtomicInteger(0);
                    AtomicInteger prev = userQueries.put(username, count);
                    if (prev == null) {
                        metrics.incrementCounter(ACTIVE_SQL_USER);
                    } else {
                        count = prev;
                    }
                }
                count.incrementAndGet();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void decrementUserQueries(Metrics metrics) {
        String username = this.parentSession.getUserName();
        if (username != null) {
            Map<String, AtomicInteger> map = userQueries;
            synchronized (map) {
                AtomicInteger count = userQueries.get(username);
                if (count != null && count.decrementAndGet() <= 0) {
                    metrics.decrementCounter(ACTIVE_SQL_USER);
                    userQueries.remove(username);
                }
            }
        }
    }

    private void markQueryMetric(Metrics metric, String name) {
        if (metric != null) {
            metric.markMeter(name);
        }
    }

    public String getExecutionEngine() {
        return this.queryState.getConf().getVar(HiveConf.ConfVars.HIVE_EXECUTION_ENGINE);
    }

    private final class BackgroundWork
    implements Runnable {
        private final UserGroupInformation currentUGI;
        private final Hive parentHive;
        private final PerfLogger parentPerfLogger;
        private final SessionState parentSessionState;
        private final boolean asyncPrepare;

        private BackgroundWork(UserGroupInformation currentUGI, Hive parentHive, PerfLogger parentPerfLogger, SessionState parentSessionState, boolean asyncPrepare) {
            this.currentUGI = currentUGI;
            this.parentHive = parentHive;
            this.parentPerfLogger = parentPerfLogger;
            this.parentSessionState = parentSessionState;
            this.asyncPrepare = asyncPrepare;
        }

        @Override
        public void run() {
            PrivilegedExceptionAction<Object> doAsAction = new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws HiveSQLException {
                    Hive.set((Hive)BackgroundWork.this.parentHive);
                    SessionState.setCurrentSessionState((SessionState)BackgroundWork.this.parentSessionState);
                    PerfLogger.setPerfLogger((PerfLogger)BackgroundWork.this.parentPerfLogger);
                    SQLOperation.this.registerCurrentOperationLog();
                    SQLOperation.this.registerLoggingContext();
                    try {
                        if (BackgroundWork.this.asyncPrepare) {
                            SQLOperation.this.prepare(SQLOperation.this.queryState);
                        }
                        SQLOperation.this.runQuery();
                    }
                    catch (HiveSQLException e) {
                        SQLOperation.this.setOperationException(e);
                        Operation.LOG.error("Error running hive query: ", (Throwable)e);
                    }
                    finally {
                        SQLOperation.this.unregisterLoggingContext();
                        SQLOperation.this.unregisterOperationLog();
                    }
                    return null;
                }
            };
            try {
                this.currentUGI.doAs((PrivilegedExceptionAction)doAsAction);
            }
            catch (Exception e) {
                SQLOperation.this.setOperationException(new HiveSQLException(e));
                Operation.LOG.error("Error running hive query as user : " + this.currentUGI.getShortUserName(), (Throwable)e);
            }
            finally {
                if (ThreadWithGarbageCleanup.currentThread() instanceof ThreadWithGarbageCleanup) {
                    ThreadWithGarbageCleanup currentThread = (ThreadWithGarbageCleanup)ThreadWithGarbageCleanup.currentThread();
                    currentThread.cacheThreadLocalRawStore();
                }
            }
        }
    }
}

