/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.tool;

import java.util.Locale;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.rest.service.AclTableMigrationTool;

public class AclTableMigrationCLI {
    private static final String MIGRATE = "MIGRATE";
    private static final String CHECK = "CHECK";

    public static void main(String[] args) throws Exception {
        if (args == null || args.length != 1) {
            throw new IllegalArgumentException("Args num error");
        }
        String cmd = args[0].toUpperCase(Locale.ROOT);
        AclTableMigrationTool tool = new AclTableMigrationTool();
        switch (cmd) {
            case "MIGRATE": {
                tool.migrate(KylinConfig.getInstanceFromEnv());
                break;
            }
            case "CHECK": {
                boolean needMigrate = tool.checkIfNeedMigrate(KylinConfig.getInstanceFromEnv());
                if (!needMigrate) break;
                System.out.println("Found ACL metadata in legacy format. Please execute command : ${KYLIN_HOME}/bin/kylin.sh org.apache.kylin.tool.AclTableMigrationCLI MIGRATE");
                System.exit(2);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unrecognized cmd");
            }
        }
    }
}

