/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.signature;

import java.util.HashSet;
import java.util.Set;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.cube.CubeManager;
import org.apache.kylin.metadata.model.DataModelDesc;
import org.apache.kylin.metadata.model.TableRef;
import org.apache.kylin.metadata.project.ProjectInstance;
import org.apache.kylin.metadata.project.RealizationEntry;
import org.apache.kylin.metadata.realization.IRealization;
import org.apache.kylin.metadata.realization.RealizationType;
import org.apache.kylin.rest.signature.RealizationSetCalculator;
import org.apache.kylin.shaded.com.google.common.collect.Sets;
import org.apache.kylin.storage.hybrid.HybridInstance;
import org.apache.kylin.storage.hybrid.HybridManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FactTableRealizationSetCalculator
extends RealizationSetCalculator {
    public static final Logger logger = LoggerFactory.getLogger(FactTableRealizationSetCalculator.class);

    @Override
    protected Set<String> getRealizations(KylinConfig config, String cubes, ProjectInstance project) {
        Set<String> realizations = super.getRealizations(config, cubes, project);
        if (realizations == null) {
            return null;
        }
        HashSet<String> factTables = Sets.newHashSet();
        for (String realName : realizations) {
            IRealization realInstance = this.getRealization(config, realName);
            String factTable = this.getRootFactTableForRealization(realInstance);
            if (factTable == null) continue;
            factTables.add(factTable);
        }
        HashSet<String> ret = Sets.newHashSet(realizations);
        for (RealizationEntry entry : project.getRealizationEntries()) {
            String realName = entry.getRealization();
            IRealization realInstance = this.getRealization(config, realName, entry.getType());
            String factTableForEntry = this.getRootFactTableForRealization(realInstance);
            if (factTableForEntry == null || !factTables.contains(factTableForEntry)) continue;
            ret.add(realName);
        }
        return ret;
    }

    private String getRootFactTableForRealization(IRealization realization) {
        if (realization == null) {
            logger.warn("Cannot find realization {}", (Object)realization);
            return null;
        }
        DataModelDesc model = realization.getModel();
        if (model == null) {
            logger.warn("The model for realization {} is null", (Object)realization.getName());
            return null;
        }
        TableRef rootFactTable = model.getRootFactTable();
        if (rootFactTable == null) {
            logger.warn("The root table for model {} is null", (Object)model.getName());
            return null;
        }
        return rootFactTable.getTableIdentity();
    }

    private IRealization getRealization(KylinConfig config, String name, RealizationType type) {
        switch (type) {
            case CUBE: {
                return CubeManager.getInstance(config).getCube(name);
            }
            case HYBRID: {
                return HybridManager.getInstance(config).getHybridInstance(name);
            }
        }
        return this.getRealization(config, name);
    }

    private IRealization getRealization(KylinConfig config, String name) {
        HybridInstance hybridInstance = HybridManager.getInstance(config).getHybridInstance(name);
        if (hybridInstance != null) {
            return hybridInstance;
        }
        return CubeManager.getInstance(config).getCube(name);
    }
}

