/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.security;

import java.util.List;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.util.ClassUtil;
import org.apache.kylin.common.util.Pair;
import org.apache.kylin.rest.security.AclPermission;
import org.apache.kylin.tool.shaded.org.apache.commons.lang.StringUtils;
import org.springframework.security.acls.model.Permission;

public abstract class ExternalAclProvider {
    private static volatile ExternalAclProvider singleton = null;
    public static final String ADMINISTRATION = "ADMIN";
    public static final String MANAGEMENT = "MANAGEMENT";
    public static final String OPERATION = "OPERATION";
    public static final String READ = "QUERY";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ExternalAclProvider getInstance() {
        if (singleton != null) return singleton;
        Class<ExternalAclProvider> clazz = ExternalAclProvider.class;
        synchronized (ExternalAclProvider.class) {
            String cls;
            if (singleton != null || StringUtils.isBlank(cls = KylinConfig.getInstanceFromEnv().getExternalAclProvider())) return singleton;
            singleton = (ExternalAclProvider)ClassUtil.newInstance(cls);
            singleton.init();
            // ** MonitorExit[var0] (shouldn't be in output)
            return singleton;
        }
    }

    public static String transformPermission(Permission p) {
        String permString = null;
        permString = AclPermission.ADMINISTRATION.equals(p) ? ADMINISTRATION : (AclPermission.MANAGEMENT.equals(p) ? MANAGEMENT : (AclPermission.OPERATION.equals(p) ? OPERATION : (AclPermission.READ.equals(p) ? READ : p.getPattern())));
        return permString;
    }

    public abstract void init();

    public abstract boolean checkPermission(String var1, List<String> var2, String var3, String var4, Permission var5);

    public abstract List<Pair<String, AclPermission>> getAcl(String var1, String var2);
}

