/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.controller;

import java.io.IOException;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.metadata.cachesync.Broadcaster;
import org.apache.kylin.rest.controller.BasicController;
import org.apache.kylin.rest.request.CubeMigrationRequest;
import org.apache.kylin.rest.service.CacheService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/cache"})
public class CacheController
extends BasicController {
    private static final Logger logger = LoggerFactory.getLogger(CacheController.class);
    @Autowired
    @Qualifier(value="cacheService")
    private CacheService cacheService;

    @RequestMapping(value={"/announce/{entity}/{cacheKey}/{event}"}, method={RequestMethod.PUT}, produces={"application/json"})
    @ResponseBody
    public void announceWipeCache(@PathVariable String entity, @PathVariable String event, @PathVariable String cacheKey) throws IOException {
        this.cacheService.annouceWipeCache(entity, event, cacheKey);
    }

    @RequestMapping(value={"/{entity}/{cacheKey}/{event}"}, method={RequestMethod.PUT}, produces={"application/json"})
    @ResponseBody
    public void wipeCache(@PathVariable String entity, @PathVariable String event, @PathVariable String cacheKey) throws IOException {
        this.cacheService.notifyMetadataChange(entity, Broadcaster.Event.getEvent(event), cacheKey);
    }

    @RequestMapping(value={"/{entity}/{event}"}, method={RequestMethod.PUT}, produces={"application/json"})
    @ResponseBody
    public void wipeCacheWithRequestBody(@PathVariable String entity, @PathVariable String event, @RequestBody String cacheKey) throws IOException {
        this.cacheService.notifyMetadataChange(entity, Broadcaster.Event.getEvent(event), cacheKey);
    }

    @RequestMapping(value={"/announce/config"}, method={RequestMethod.POST}, produces={"application/json"})
    public void hotLoadKylinConfig() throws IOException {
        KylinConfig.getInstanceFromEnv().reloadFromSiteProperties();
        this.cacheService.notifyMetadataChange("all", Broadcaster.Event.UPDATE, "all");
    }

    @RequestMapping(value={"/migration"}, method={RequestMethod.POST})
    @ResponseBody
    public void clearCacheForCubeMigration(@RequestBody CubeMigrationRequest request) throws IOException {
        this.cacheService.clearCacheForCubeMigration(request.getCube(), request.getProject(), request.getModel(), request.getTableToProjects());
        this.cacheService.cleanDataCache(request.getProject());
    }

    public void setCacheService(CacheService cacheService) {
        this.cacheService = cacheService;
    }
}

