/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.engine.spark.job;

import java.io.IOException;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletionService;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.engine.spark.builder.NBuildSourceInfo;
import org.apache.kylin.engine.spark.metadata.SegmentInfo;
import org.apache.kylin.engine.spark.metadata.cube.model.LayoutEntity;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.storage.StorageLevel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BuildLayoutWithUpdate {
    protected static final Logger logger = LoggerFactory.getLogger(BuildLayoutWithUpdate.class);
    private ExecutorService pool = Executors.newCachedThreadPool();
    private CompletionService<JobResult> completionService = new ExecutorCompletionService<JobResult>(this.pool);
    private int currentLayoutsNum = 0;
    private Map<Long, AtomicLong> toBuildCuboidSize = new ConcurrentHashMap<Long, AtomicLong>();
    private Semaphore semaphore;
    private Map<Long, Dataset<Row>> layout2DataSet = new ConcurrentHashMap<Long, Dataset<Row>>();
    private StorageLevel storageLevel;
    private boolean persistParentDataset;

    public BuildLayoutWithUpdate(KylinConfig kylinConfig) {
        this.storageLevel = StorageLevel.fromString((String)kylinConfig.getParentDatasetStorageLevel());
        boolean bl = this.persistParentDataset = !this.storageLevel.equals((Object)StorageLevel.NONE());
        if (this.persistParentDataset) {
            if (kylinConfig.getMaxParentDatasetPersistCount() < 1) {
                throw new IllegalArgumentException("max parent dataset persist count should be larger than 1");
            }
            this.semaphore = new Semaphore(kylinConfig.getMaxParentDatasetPersistCount());
        }
    }

    public void cacheAndRegister(long layoutId, Dataset<Row> dataset) throws InterruptedException {
        if (!this.persistParentDataset) {
            return;
        }
        logger.info("persist dataset of layout: {}", (Object)layoutId);
        this.semaphore.acquire();
        this.layout2DataSet.put(layoutId, dataset);
        dataset.persist(this.storageLevel);
    }

    public void submit(final JobEntity job, final KylinConfig config) {
        if (this.persistParentDataset && job.getBuildSourceInfo() != null) {
            if (!this.layout2DataSet.containsKey(job.getBuildSourceInfo().getLayoutId())) {
                logger.error("persist parent dataset is enabled, but parent dataset not registered");
                throw new RuntimeException("parent dataset not registered");
            }
            if (!this.toBuildCuboidSize.containsKey(job.getBuildSourceInfo().getLayoutId())) {
                this.toBuildCuboidSize.put(job.getBuildSourceInfo().getLayoutId(), new AtomicLong(job.getBuildSourceInfo().getToBuildCuboids().size()));
            }
        }
        this.completionService.submit(new Callable<JobResult>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public JobResult call() throws Exception {
                KylinConfig.setAndUnsetThreadLocalConfig(config);
                Thread.currentThread().setName("thread-" + job.getName());
                LayoutEntity dataLayouts = null;
                Throwable throwable = null;
                try {
                    dataLayouts = job.build();
                }
                catch (Throwable t) {
                    logger.error("Error occurred when run " + job.getName(), t);
                    throwable = t;
                }
                finally {
                    long remain;
                    if (BuildLayoutWithUpdate.this.persistParentDataset && job.getBuildSourceInfo() != null && (remain = ((AtomicLong)BuildLayoutWithUpdate.this.toBuildCuboidSize.get(job.getBuildSourceInfo().getLayoutId())).decrementAndGet()) == 0L) {
                        BuildLayoutWithUpdate.this.toBuildCuboidSize.remove(job.getBuildSourceInfo().getLayoutId());
                        ((Dataset)BuildLayoutWithUpdate.this.layout2DataSet.get(job.getBuildSourceInfo().getLayoutId())).unpersist();
                        logger.info("dataset of layout: {} released", (Object)job.getBuildSourceInfo().getLayoutId());
                        BuildLayoutWithUpdate.this.semaphore.release();
                    }
                }
                return new JobResult(dataLayouts, throwable);
            }
        });
        ++this.currentLayoutsNum;
    }

    public void updateLayout(SegmentInfo seg, KylinConfig config) {
        for (int i = 0; i < this.currentLayoutsNum; ++i) {
            try {
                logger.info("Wait to take job result.");
                JobResult result = this.completionService.take().get();
                logger.info("Take job result successful.");
                if (result.isFailed()) {
                    this.shutDownPool();
                    throw new RuntimeException(result.getThrowable());
                }
                seg.updateLayout(result.layout);
                continue;
            }
            catch (InterruptedException | ExecutionException e) {
                this.shutDownPool();
                throw new RuntimeException(e);
            }
        }
        this.currentLayoutsNum = 0;
    }

    private void shutDownPool() {
        this.pool.shutdown();
        try {
            this.pool.awaitTermination(10L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            logger.warn("Error occurred when shutdown thread pool.", e);
            this.pool.shutdownNow();
        }
    }

    static abstract class JobEntity {
        JobEntity() {
        }

        public abstract String getName();

        public abstract LayoutEntity build() throws IOException;

        public abstract NBuildSourceInfo getBuildSourceInfo();
    }

    private static class JobResult {
        private LayoutEntity layout;
        private Throwable throwable;

        JobResult(LayoutEntity layout, Throwable throwable) {
            this.layout = layout;
            this.throwable = throwable;
        }

        boolean isFailed() {
            return this.throwable != null;
        }

        Throwable getThrowable() {
            return this.throwable;
        }

        LayoutEntity getLayout() {
            return this.layout;
        }
    }
}

