/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.cube;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.apache.kylin.metadata.datatype.DataTypeOrder;
import org.apache.kylin.metadata.model.DataModelDesc;
import org.apache.kylin.shaded.com.google.common.collect.Maps;
import org.apache.kylin.tool.shaded.com.fasterxml.jackson.annotation.JsonAutoDetect;
import org.apache.kylin.tool.shaded.com.fasterxml.jackson.annotation.JsonProperty;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE, getterVisibility=JsonAutoDetect.Visibility.NONE, isGetterVisibility=JsonAutoDetect.Visibility.NONE, setterVisibility=JsonAutoDetect.Visibility.NONE)
public class DimensionRangeInfo
implements Serializable {
    private static final Logger logger = LoggerFactory.getLogger(DimensionRangeInfo.class);
    @JsonProperty(value="min")
    private String min;
    @JsonProperty(value="max")
    private String max;

    public static Map<String, DimensionRangeInfo> mergeRangeMap(DataModelDesc model, Map<String, DimensionRangeInfo> m1, Map<String, DimensionRangeInfo> m2) {
        if (!m1.keySet().equals(m2.keySet())) {
            logger.warn("Merging incompatible maps of DimensionRangeInfo, keys in m1 " + m1.keySet() + ", keys in m2 " + m2.keySet());
        }
        HashMap<String, DimensionRangeInfo> result = Maps.newHashMap();
        for (String colId : m1.keySet()) {
            DimensionRangeInfo newR;
            if (!m2.containsKey(colId)) continue;
            DimensionRangeInfo r1 = m1.get(colId);
            DimensionRangeInfo r2 = m2.get(colId);
            if (r1.getMin() == null && r1.getMax() == null) {
                newR = r2;
            } else if (r2.getMin() == null && r2.getMax() == null) {
                newR = r1;
            } else {
                DataTypeOrder order = model.findColumn(colId).getType().getOrder();
                String newMin = order.min(r1.getMin(), r2.getMin());
                String newMax = order.max(r1.getMax(), r2.getMax());
                newR = new DimensionRangeInfo(newMin, newMax);
            }
            result.put(colId, newR);
        }
        return result;
    }

    public DimensionRangeInfo() {
    }

    public DimensionRangeInfo(String min, String max) {
        if (min == null && max != null || min != null && max == null) {
            throw new IllegalStateException();
        }
        this.min = min;
        this.max = max;
    }

    public String getMin() {
        return this.min;
    }

    public void setMin(String min) {
        this.min = min;
    }

    public String getMax() {
        return this.max;
    }

    public void setMax(String max) {
        this.max = max;
    }

    public String toString() {
        return "[" + this.min + ", " + this.max + "]";
    }
}

