/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.cube;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.persistence.JsonSerializer;
import org.apache.kylin.common.persistence.ResourceStore;
import org.apache.kylin.common.persistence.Serializer;
import org.apache.kylin.common.util.AutoReadWriteLock;
import org.apache.kylin.cube.CubeInstance;
import org.apache.kylin.cube.cuboid.CuboidManager;
import org.apache.kylin.cube.model.CubeDesc;
import org.apache.kylin.cube.model.validation.CubeMetadataValidator;
import org.apache.kylin.cube.model.validation.ValidateContext;
import org.apache.kylin.dimension.DimensionEncoding;
import org.apache.kylin.dimension.DimensionEncodingFactory;
import org.apache.kylin.metadata.cachesync.Broadcaster;
import org.apache.kylin.metadata.cachesync.CachedCrudAssist;
import org.apache.kylin.metadata.cachesync.CaseInsensitiveStringCache;
import org.apache.kylin.metadata.datatype.DataType;
import org.apache.kylin.metadata.model.MeasureDesc;
import org.apache.kylin.metadata.model.ParameterDesc;
import org.apache.kylin.metadata.project.ProjectInstance;
import org.apache.kylin.metadata.project.ProjectManager;
import org.apache.kylin.metadata.realization.IRealization;
import org.apache.kylin.tool.shaded.org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CubeDescManager {
    private static final Logger logger = LoggerFactory.getLogger(CubeDescManager.class);
    public static final Serializer<CubeDesc> CUBE_DESC_SERIALIZER = new JsonSerializer<CubeDesc>(CubeDesc.class);
    static final String BROKEN_CUBE_MSG = "Broken cube desc %s";
    static final String CUBE_SHOULD_NOT_BE_DRAFT_MSG = "CubeDesc '%s' must not be a draft";
    private KylinConfig config;
    private CaseInsensitiveStringCache<CubeDesc> cubeDescMap;
    private CachedCrudAssist<CubeDesc> crud;
    private AutoReadWriteLock descMapLock = new AutoReadWriteLock();

    public static CubeDescManager getInstance(KylinConfig config) {
        return config.getManager(CubeDescManager.class);
    }

    static CubeDescManager newInstance(KylinConfig config) throws IOException {
        return new CubeDescManager(config);
    }

    private CubeDescManager(KylinConfig cfg) throws IOException {
        logger.info("Initializing CubeDescManager with config {}", (Object)cfg);
        this.config = cfg;
        this.cubeDescMap = new CaseInsensitiveStringCache(this.config, "cube_desc");
        this.crud = new CachedCrudAssist<CubeDesc>(this.getStore(), "/cube_desc", CubeDesc.class, this.cubeDescMap){

            @Override
            protected CubeDesc initEntityAfterReload(CubeDesc cubeDesc, String resourceName) {
                if (cubeDesc.isDraft()) {
                    throw new IllegalArgumentException(String.format(Locale.ROOT, CubeDescManager.CUBE_SHOULD_NOT_BE_DRAFT_MSG, cubeDesc.getName()));
                }
                try {
                    cubeDesc.init(CubeDescManager.this.config);
                }
                catch (Exception e) {
                    logger.warn(String.format(Locale.ROOT, CubeDescManager.BROKEN_CUBE_MSG, cubeDesc.resourceName()), e);
                    cubeDesc.addError(e.toString());
                }
                return cubeDesc;
            }
        };
        this.crud.reloadAll();
        Broadcaster.getInstance(this.config).registerListener(new CubeDescSyncListener(), "cube_desc");
    }

    public CubeDesc getCubeDesc(String name) {
        try (AutoReadWriteLock.AutoLock lock = this.descMapLock.lockForRead();){
            CubeDesc cubeDesc = (CubeDesc)this.cubeDescMap.get(name);
            return cubeDesc;
        }
    }

    public List<CubeDesc> listAllDesc() {
        try (AutoReadWriteLock.AutoLock lock = this.descMapLock.lockForRead();){
            ArrayList<CubeDesc> arrayList = new ArrayList<CubeDesc>(this.cubeDescMap.values());
            return arrayList;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public CubeDesc reloadCubeDescQuietly(String name) {
        try (AutoReadWriteLock.AutoLock lock = this.descMapLock.lockForWrite();){
            CubeDesc cubeDesc = this.reloadCubeDescLocal(name);
            return cubeDesc;
        }
        catch (Exception e) {
            logger.error("Failed to reload CubeDesc " + name, e);
            return null;
        }
    }

    public CubeDesc reloadCubeDescLocal(String name) throws IOException {
        try (AutoReadWriteLock.AutoLock lock = this.descMapLock.lockForWrite();){
            CubeDesc ndesc = this.crud.reload(name);
            this.clearCuboidCache(name);
            if (ndesc.isBroken()) {
                throw new IllegalStateException("CubeDesc " + name + " is broken");
            }
            CubeDesc cubeDesc = ndesc;
            return cubeDesc;
        }
    }

    public CubeDesc createCubeDesc(CubeDesc cubeDesc) throws IOException {
        try (AutoReadWriteLock.AutoLock lock = this.descMapLock.lockForWrite();){
            if (cubeDesc.getUuid() == null || cubeDesc.getName() == null) {
                throw new IllegalArgumentException();
            }
            if (this.cubeDescMap.containsKey(cubeDesc.getName())) {
                throw new IllegalArgumentException("CubeDesc '" + cubeDesc.getName() + "' already exists");
            }
            if (cubeDesc.isDraft()) {
                throw new IllegalArgumentException(String.format(Locale.ROOT, CUBE_SHOULD_NOT_BE_DRAFT_MSG, cubeDesc.getName()));
            }
            try {
                cubeDesc.init(this.config);
            }
            catch (Exception e) {
                logger.warn("Broken cube desc " + cubeDesc, e);
                cubeDesc.addError(e.toString());
            }
            this.postProcessCubeDesc(cubeDesc);
            if (cubeDesc.isBroken()) {
                CubeDesc e = cubeDesc;
                return e;
            }
            CubeMetadataValidator validator = new CubeMetadataValidator(this.config);
            ValidateContext context = validator.validate(cubeDesc);
            if (!context.ifPass()) {
                CubeDesc cubeDesc2 = cubeDesc;
                return cubeDesc2;
            }
            cubeDesc.setSignature(cubeDesc.calculateSignature());
            this.crud.save(cubeDesc);
            CubeDesc cubeDesc3 = cubeDesc;
            return cubeDesc3;
        }
    }

    public CubeDesc updateCubeDesc(CubeDesc desc) throws IOException {
        try (AutoReadWriteLock.AutoLock lock = this.descMapLock.lockForWrite();){
            if (desc.getUuid() == null || desc.getName() == null) {
                throw new IllegalArgumentException();
            }
            String name = desc.getName();
            if (!this.cubeDescMap.containsKey(name)) {
                throw new IllegalArgumentException("CubeDesc '" + name + "' does not exist.");
            }
            if (desc.isDraft()) {
                throw new IllegalArgumentException(String.format(Locale.ROOT, CUBE_SHOULD_NOT_BE_DRAFT_MSG, desc.getName()));
            }
            try {
                desc.init(this.config);
            }
            catch (Exception e) {
                logger.warn("Broken cube desc " + desc, e);
                desc.addError(e.toString());
                CubeDesc cubeDesc = desc;
                if (lock != null) {
                    if (var3_3 != null) {
                        try {
                            lock.close();
                        }
                        catch (Throwable throwable) {
                            var3_3.addSuppressed(throwable);
                        }
                    } else {
                        lock.close();
                    }
                }
                return cubeDesc;
            }
            this.postProcessCubeDesc(desc);
            CubeMetadataValidator validator = new CubeMetadataValidator(this.config);
            ValidateContext context = validator.validate(desc);
            if (!context.ifPass()) {
                CubeDesc cubeDesc = desc;
                return cubeDesc;
            }
            desc.setSignature(desc.calculateSignature());
            this.crud.save(desc);
            CubeDesc cubeDesc = desc;
            return cubeDesc;
        }
    }

    private void postProcessCubeDesc(CubeDesc cubeDesc) {
        for (MeasureDesc measureDesc : cubeDesc.getMeasures()) {
            if (!"TOP_N".equalsIgnoreCase(measureDesc.getFunction().getExpression())) continue;
            Map<String, String> configuration = measureDesc.getFunction().getConfiguration();
            ParameterDesc parameter = measureDesc.getFunction().getParameter();
            int keyLength = 0;
            for (parameter = parameter.getNextParameter(); parameter != null; parameter = parameter.getNextParameter()) {
                String encoding = configuration.get("topn.encoding." + parameter.getValue());
                String encodingVersionStr = configuration.get("topn.encoding_version." + parameter.getValue());
                if (StringUtils.isEmpty(encoding) || "dict".equals(encoding)) {
                    keyLength += 4;
                    continue;
                }
                if (encoding.startsWith("dict")) {
                    throw new IllegalArgumentException("TOP_N's Encoding is " + encoding + ", please choose the correct one");
                }
                int encodingVersion = 1;
                if (!StringUtils.isEmpty(encodingVersionStr)) {
                    try {
                        encodingVersion = Integer.parseInt(encodingVersionStr);
                    }
                    catch (NumberFormatException e) {
                        throw new RuntimeException("invalid encoding version: " + encodingVersionStr);
                    }
                }
                Object[] encodingConf = DimensionEncoding.parseEncodingConf(encoding);
                DimensionEncoding dimensionEncoding = DimensionEncodingFactory.create((String)encodingConf[0], (String[])encodingConf[1], encodingVersion);
                keyLength += dimensionEncoding.getLengthOfEncoding();
            }
            DataType returnType = DataType.getType(measureDesc.getFunction().getReturnType());
            DataType newReturnType = new DataType(returnType.getName(), returnType.getPrecision(), keyLength);
            measureDesc.getFunction().setReturnType(newReturnType.toString());
        }
    }

    public void removeCubeDesc(CubeDesc cubeDesc) throws IOException {
        try (AutoReadWriteLock.AutoLock lock = this.descMapLock.lockForWrite();){
            this.crud.delete(cubeDesc);
            this.clearCuboidCache(cubeDesc.getName());
        }
    }

    public void removeLocalCubeDesc(String name) throws IOException {
        try (AutoReadWriteLock.AutoLock lock = this.descMapLock.lockForWrite();){
            this.cubeDescMap.removeLocal(name);
            this.clearCuboidCache(name);
        }
    }

    private void clearCuboidCache(String descName) {
        CuboidManager.getInstance(this.config).clearCache(descName);
    }

    private ResourceStore getStore() {
        return ResourceStore.getStore(this.config);
    }

    private class CubeDescSyncListener
    extends Broadcaster.Listener {
        private CubeDescSyncListener() {
        }

        @Override
        public void onProjectSchemaChange(Broadcaster broadcaster, String project) throws IOException {
            for (IRealization real : ProjectManager.getInstance(CubeDescManager.this.config).listAllRealizations(project)) {
                if (!(real instanceof CubeInstance)) continue;
                String descName = ((CubeInstance)real).getDescName();
                CubeDescManager.this.reloadCubeDescQuietly(descName);
            }
        }

        @Override
        public void onEntityChange(Broadcaster broadcaster, String entity, Broadcaster.Event event, String cacheKey) throws IOException {
            String modelName;
            String cubeDescName = cacheKey;
            CubeDesc cubeDesc = CubeDescManager.this.getCubeDesc(cubeDescName);
            String string = modelName = cubeDesc == null ? null : cubeDesc.getModelName();
            if (event == Broadcaster.Event.DROP) {
                CubeDescManager.this.removeLocalCubeDesc(cubeDescName);
            } else {
                CubeDescManager.this.reloadCubeDescQuietly(cubeDescName);
            }
            for (ProjectInstance prj : ProjectManager.getInstance(CubeDescManager.this.config).findProjectsByModel(modelName)) {
                broadcaster.notifyProjectSchemaUpdate(prj.getName());
            }
        }
    }
}

