/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.common.util;

import java.io.File;
import java.io.IOException;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Enumeration;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.persistence.ResourceStore;
import org.apache.kylin.tool.shaded.org.apache.commons.lang.StringUtils;

public class ToolUtil {
    private ToolUtil() {
        throw new IllegalStateException("Class ToolUtil is an utility class !");
    }

    public static String getConfFolder() {
        String CONF = "conf";
        String path = System.getProperty("KYLIN_CONF");
        if (StringUtils.isNotEmpty(path)) {
            return path;
        }
        path = KylinConfig.getKylinHome();
        if (StringUtils.isNotEmpty(path)) {
            return path + File.separator + "conf";
        }
        throw new RuntimeException("Cannot find conf folder.");
    }

    public static String getMetaStoreId() throws IOException {
        KylinConfig kylinConfig = KylinConfig.getInstanceFromEnv();
        ResourceStore store = ResourceStore.getStore(kylinConfig);
        return store.getMetaStoreUUID();
    }

    public static String getHostName() {
        String hostname = System.getenv("COMPUTERNAME");
        if (StringUtils.isEmpty(hostname)) {
            InetAddress address = null;
            try {
                address = InetAddress.getLocalHost();
                hostname = address.getHostName();
                if (StringUtils.isEmpty(hostname)) {
                    hostname = address.getHostAddress();
                }
            }
            catch (UnknownHostException uhe) {
                int colon;
                String host = uhe.getMessage();
                if (host != null && (colon = host.indexOf(58)) > 0) {
                    return host.substring(0, colon);
                }
                hostname = "Unknown";
            }
        }
        return hostname;
    }

    public static InetAddress getFirstNonLoopbackAddress(boolean preferIpv4, boolean preferIPv6) throws SocketException {
        Enumeration<NetworkInterface> en = NetworkInterface.getNetworkInterfaces();
        while (en.hasMoreElements()) {
            NetworkInterface element = en.nextElement();
            Enumeration<InetAddress> en2 = element.getInetAddresses();
            while (en2.hasMoreElements()) {
                InetAddress addr = en2.nextElement();
                if (addr.isLoopbackAddress()) continue;
                if (addr instanceof Inet4Address) {
                    if (preferIPv6) continue;
                    return addr;
                }
                if (!(addr instanceof Inet6Address) || preferIpv4) continue;
                return addr;
            }
        }
        return null;
    }

    public static InetAddress getFirstIPV4NonLoopBackAddress() throws SocketException {
        return ToolUtil.getFirstNonLoopbackAddress(true, false);
    }
}

