/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.topology.discovery.cm;

import com.cloudera.api.swagger.RolesResourceApi;
import java.util.Collection;
import org.apache.knox.gateway.config.GatewayConfig;
import org.apache.knox.gateway.i18n.messages.MessagesFactory;
import org.apache.knox.gateway.topology.discovery.cm.ClouderaManagerServiceDiscoveryMessages;
import org.apache.knox.gateway.topology.discovery.cm.ServiceRoleCollector;
import org.apache.knox.gateway.topology.discovery.cm.ServiceRoleCollectorByRole;
import org.apache.knox.gateway.topology.discovery.cm.ServiceRoleCollectorByService;
import org.apache.knox.gateway.topology.discovery.cm.TypeNameFilter;

public class ServiceRoleCollectorBuilder {
    private ServiceRoleCollectorBuilder() {
    }

    public static GatewayConfigStep newBuilder() {
        return new Steps();
    }

    private static class Steps
    implements GatewayConfigStep,
    RolesResourceApiStep,
    BuildStep {
        private GatewayConfig gatewayConfig;
        private RolesResourceApi rolesResourceApi;
        private static final ClouderaManagerServiceDiscoveryMessages log = (ClouderaManagerServiceDiscoveryMessages)MessagesFactory.get(ClouderaManagerServiceDiscoveryMessages.class);

        private Steps() {
        }

        @Override
        public RolesResourceApiStep gatewayConfig(GatewayConfig gatewayConfig) {
            this.gatewayConfig = gatewayConfig;
            return this;
        }

        @Override
        public BuildStep rolesResourceApi(RolesResourceApi rolesResourceApi) {
            this.rolesResourceApi = rolesResourceApi;
            return this;
        }

        @Override
        public ServiceRoleCollector build() {
            if (this.gatewayConfig == null) {
                throw new IllegalArgumentException("gateway config must be set");
            }
            if (this.rolesResourceApi == null) {
                throw new IllegalArgumentException("roles resource API must be set");
            }
            String fetchStrategy = this.gatewayConfig.getClouderaManagerServiceDiscoveryRoleFetchStrategy();
            long pageSize = this.gatewayConfig.getClouderaManagerServiceDiscoveryRoleConfigPageSize();
            Collection excludedRoleTypes = this.gatewayConfig.getClouderaManagerServiceDiscoveryExcludedRoleTypes();
            TypeNameFilter roleTypeNameFilter = new TypeNameFilter(excludedRoleTypes);
            String clientBasePath = this.rolesResourceApi.getApiClient().getBasePath();
            if ("byRole".equals(fetchStrategy)) {
                log.usingSimpleRoleStrategy(fetchStrategy, clientBasePath);
                return new ServiceRoleCollectorByRole(this.rolesResourceApi, roleTypeNameFilter);
            }
            if ("byService".equals(fetchStrategy)) {
                log.usingRoleStrategyWithPageSize(fetchStrategy, pageSize, clientBasePath);
                return new ServiceRoleCollectorByService(this.rolesResourceApi, pageSize, roleTypeNameFilter);
            }
            log.usingSimpleRoleStrategyFallback(fetchStrategy, clientBasePath);
            return new ServiceRoleCollectorByRole(this.rolesResourceApi, roleTypeNameFilter);
        }
    }

    public static interface BuildStep {
        public ServiceRoleCollector build();
    }

    public static interface RolesResourceApiStep {
        public BuildStep rolesResourceApi(RolesResourceApi var1);
    }

    public static interface GatewayConfigStep {
        public RolesResourceApiStep gatewayConfig(GatewayConfig var1);
    }
}

