/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.topology.simple;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.knox.gateway.topology.simple.ProviderConfiguration;
import org.apache.knox.gateway.topology.simple.ProviderOrder;

@XmlRootElement(name="gateway")
@XmlAccessorType(value=XmlAccessType.FIELD)
class XMLProviderConfiguration
implements ProviderConfiguration {
    @XmlElement(name="provider", type=XMLProvider.class)
    private Set<ProviderConfiguration.Provider> providers;
    @XmlElement(name="readOnly")
    private boolean readOnly;

    XMLProviderConfiguration() {
    }

    @Override
    public Set<ProviderConfiguration.Provider> getProviders() {
        return Collections.unmodifiableSet(this.providers);
    }

    @Override
    public void saveOrUpdateProviders(Set<ProviderConfiguration.Provider> providersToReplace) {
        if (this.providers == null) {
            this.providers = new TreeSet<ProviderConfiguration.Provider>();
            this.providers.addAll(providersToReplace);
        } else {
            providersToReplace.forEach(providerToAdd -> {
                Optional<ProviderConfiguration.Provider> toBeRemoved = this.providers.stream().filter(provider -> provider.getRole().equals(providerToAdd.getRole())).findFirst();
                if (toBeRemoved.isPresent()) {
                    this.providers.remove(toBeRemoved.get());
                }
                this.providers.add((ProviderConfiguration.Provider)providerToAdd);
            });
        }
    }

    @Override
    public boolean isReadOnly() {
        return this.readOnly;
    }

    @Override
    public void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
    }

    public int hashCode() {
        return HashCodeBuilder.reflectionHashCode((Object)this, (String[])new String[0]);
    }

    public boolean equals(Object obj) {
        return EqualsBuilder.reflectionEquals((Object)this, (Object)obj, (String[])new String[0]);
    }

    @XmlAccessorType(value=XmlAccessType.NONE)
    @XmlType(propOrder={"role", "name", "enabled", "params"})
    private static class XMLProvider
    implements ProviderConfiguration.Provider,
    Comparable<XMLProvider> {
        @XmlElement
        private String role;
        @XmlElement
        private String name;
        @XmlElement
        private boolean enabled;
        @XmlElement(name="param")
        private List<XMLParam> params;

        private XMLProvider() {
        }

        @Override
        public String getRole() {
            return this.role;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public boolean isEnabled() {
            return this.enabled;
        }

        @Override
        public Map<String, String> getParams() {
            TreeMap<String, String> result = new TreeMap<String, String>();
            if (this.params != null) {
                for (XMLParam p : this.params) {
                    result.put(p.name, p.value);
                }
            }
            return result;
        }

        public int hashCode() {
            return HashCodeBuilder.reflectionHashCode((Object)this, (String[])new String[0]);
        }

        public boolean equals(Object obj) {
            return EqualsBuilder.reflectionEquals((Object)this, (Object)obj, (String[])new String[0]);
        }

        @Override
        public int compareTo(XMLProvider other) {
            return Integer.compare(ProviderOrder.getOrdinalForRole(this.role), ProviderOrder.getOrdinalForRole(other.role));
        }

        @XmlAccessorType(value=XmlAccessType.NONE)
        private static class XMLParam {
            @XmlElement
            private String name;
            @XmlElement
            private String value;

            private XMLParam() {
            }
        }
    }
}

