/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.api.schema.registries.synchronizers;

import java.util.List;
import org.apache.directory.api.ldap.model.entry.Entry;
import org.apache.directory.api.ldap.model.exception.LdapException;
import org.apache.directory.api.ldap.model.exception.LdapInvalidDnException;
import org.apache.directory.api.ldap.model.exception.LdapUnwillingToPerformException;
import org.apache.directory.api.ldap.model.message.ResultCodeEnum;
import org.apache.directory.api.ldap.model.name.Dn;
import org.apache.directory.api.ldap.model.name.Rdn;
import org.apache.directory.api.ldap.model.schema.ObjectClass;
import org.apache.directory.api.ldap.model.schema.SchemaManager;
import org.apache.directory.api.ldap.model.schema.SchemaObject;
import org.apache.directory.api.ldap.model.schema.registries.Schema;
import org.apache.directory.api.util.Strings;
import org.apache.directory.server.core.api.interceptor.context.ModifyOperationContext;
import org.apache.directory.server.core.api.schema.registries.synchronizers.AbstractRegistrySynchronizer;
import org.apache.directory.server.i18n.I18n;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ObjectClassSynchronizer
extends AbstractRegistrySynchronizer {
    private static final Logger LOG = LoggerFactory.getLogger(ObjectClassSynchronizer.class);

    public ObjectClassSynchronizer(SchemaManager schemaManager) throws Exception {
        super(schemaManager);
    }

    @Override
    public boolean modify(ModifyOperationContext modifyContext, Entry targetEntry, boolean cascade) throws LdapException {
        Dn name = modifyContext.getDn();
        Entry entry = modifyContext.getEntry();
        String oid = this.getOid(entry);
        ObjectClass oc = this.factory.getObjectClass(this.schemaManager, targetEntry, this.schemaManager.getRegistries(), this.getSchemaName(name));
        String schemaName = this.getSchemaName(entry.getDn());
        if (this.isSchemaEnabled(schemaName)) {
            this.schemaManager.unregisterObjectClass(oid);
            this.schemaManager.add((SchemaObject)oc);
            return true;
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void add(Entry entry) throws LdapException {
        Dn dn = entry.getDn();
        Dn parentDn = dn.getParent();
        this.checkParent(parentDn, this.schemaManager, "ObjectCLass");
        this.checkOidIsUnique(entry);
        String schemaName = this.getSchemaName(dn);
        ObjectClass objectClass = this.factory.getObjectClass(this.schemaManager, entry, this.schemaManager.getRegistries(), schemaName);
        Schema schema = this.schemaManager.getLoadedSchema(schemaName);
        if (schema.isEnabled() && objectClass.isEnabled()) {
            if (this.schemaManager.add((SchemaObject)objectClass)) {
                LOG.debug("Added {} into the enabled schema {}", (Object)dn.getName(), (Object)schemaName);
                return;
            }
            String msg = I18n.err((I18n)I18n.ERR_373, (Object[])new Object[]{entry.getDn().getName(), Strings.listToString((List)this.schemaManager.getErrors())});
            LOG.info(msg);
            throw new LdapUnwillingToPerformException(ResultCodeEnum.UNWILLING_TO_PERFORM, msg);
        }
        LOG.debug("The ObjectClass {} cannot be added in the disabled schema {}.", (Object)objectClass, (Object)schemaName);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void delete(Entry entry, boolean cascade) throws LdapException {
        Dn dn = entry.getDn();
        Dn parentDn = dn.getParent();
        this.checkParent(parentDn, this.schemaManager, "ObjectCLass");
        String schemaName = this.getSchemaName(entry.getDn());
        Schema schema = this.schemaManager.getLoadedSchema(schemaName);
        if (schema.isDisabled()) {
            LOG.debug("The ObjectClass {} cannot be removed from the disabled schema {}.", (Object)dn.getName(), (Object)schemaName);
            return;
        }
        ObjectClass objectClass = (ObjectClass)this.checkOidExists(entry);
        if (schema.isEnabled() && objectClass.isEnabled()) {
            if (this.schemaManager.delete((SchemaObject)objectClass)) {
                LOG.debug("Removed {} from the schema {}", (Object)objectClass, (Object)schemaName);
                return;
            }
            String msg = I18n.err((I18n)I18n.ERR_374, (Object[])new Object[]{entry.getDn().getName(), Strings.listToString((List)this.schemaManager.getErrors())});
            LOG.info(msg);
            throw new LdapUnwillingToPerformException(ResultCodeEnum.UNWILLING_TO_PERFORM, msg);
        }
        LOG.debug("Removed {} from the disabled schema {}", (Object)objectClass, (Object)schemaName);
    }

    @Override
    public void rename(Entry entry, Rdn newRdn, boolean cascade) throws LdapException {
        String schemaName = this.getSchemaName(entry.getDn());
        ObjectClass oldOc = this.factory.getObjectClass(this.schemaManager, entry, this.schemaManager.getRegistries(), schemaName);
        Entry targetEntry = entry.clone();
        String newOid = newRdn.getValue();
        targetEntry.put("m-oid", new String[]{newOid});
        Dn newDn = targetEntry.getDn().getParent();
        newDn = newDn.add(newRdn);
        this.checkOidIsUnique(newOid);
        ObjectClass oc = this.factory.getObjectClass(this.schemaManager, targetEntry, this.schemaManager.getRegistries(), schemaName);
        if (this.isSchemaEnabled(schemaName)) {
            if (this.schemaManager.getObjectClassRegistry().hasDescendants(oldOc.getOid())) {
                String msg = I18n.err((I18n)I18n.ERR_375, (Object[])new Object[]{entry.getDn().getName(), newDn});
                throw new LdapUnwillingToPerformException(ResultCodeEnum.UNWILLING_TO_PERFORM, msg);
            }
            this.schemaManager.unregisterObjectClass(oldOc.getOid());
            this.schemaManager.add((SchemaObject)oc);
        } else {
            this.unregisterOids((SchemaObject)oldOc);
            this.registerOids((SchemaObject)oc);
        }
    }

    @Override
    public void moveAndRename(Dn oriChildName, Dn newParentName, Rdn newRdn, boolean deleteOldRn, Entry entry, boolean cascade) throws LdapException {
        this.checkNewParent(newParentName);
        String oldSchemaName = this.getSchemaName(oriChildName);
        ObjectClass oldOc = this.factory.getObjectClass(this.schemaManager, entry, this.schemaManager.getRegistries(), oldSchemaName);
        String newSchemaName = this.getSchemaName(newParentName);
        Entry targetEntry = entry.clone();
        String newOid = newRdn.getValue();
        this.checkOidIsUnique(newOid);
        targetEntry.put("m-oid", new String[]{newOid});
        ObjectClass oc = this.factory.getObjectClass(this.schemaManager, targetEntry, this.schemaManager.getRegistries(), newSchemaName);
        if (this.isSchemaEnabled(oldSchemaName)) {
            this.schemaManager.unregisterObjectClass(oldOc.getOid());
        } else {
            this.unregisterOids((SchemaObject)oldOc);
        }
        if (this.isSchemaEnabled(newSchemaName)) {
            this.schemaManager.add((SchemaObject)oc);
        } else {
            this.registerOids((SchemaObject)oc);
        }
    }

    @Override
    public void move(Dn oriChildName, Dn newParentName, Entry entry, boolean cascade) throws LdapException {
        this.checkNewParent(newParentName);
        String oldSchemaName = this.getSchemaName(oriChildName);
        String newSchemaName = this.getSchemaName(newParentName);
        ObjectClass oldAt = this.factory.getObjectClass(this.schemaManager, entry, this.schemaManager.getRegistries(), oldSchemaName);
        ObjectClass oc = this.factory.getObjectClass(this.schemaManager, entry, this.schemaManager.getRegistries(), newSchemaName);
        if (this.isSchemaEnabled(oldSchemaName)) {
            this.schemaManager.unregisterObjectClass(oldAt.getOid());
        } else {
            this.unregisterOids((SchemaObject)oldAt);
        }
        if (this.isSchemaEnabled(newSchemaName)) {
            this.schemaManager.add((SchemaObject)oc);
        } else {
            this.registerOids((SchemaObject)oc);
        }
    }

    private void checkNewParent(Dn newParent) throws LdapException {
        if (newParent.size() != 3) {
            throw new LdapInvalidDnException(ResultCodeEnum.NAMING_VIOLATION, "The parent dn of a objectClass should be at most 3 name components in length.");
        }
        Rdn rdn = newParent.getRdn();
        if (!this.schemaManager.getAttributeTypeRegistry().getOidByName(rdn.getNormType()).equals("2.5.4.11")) {
            throw new LdapInvalidDnException(ResultCodeEnum.NAMING_VIOLATION, I18n.err((I18n)I18n.ERR_376, (Object[])new Object[0]));
        }
        if (!rdn.getValue().equalsIgnoreCase("objectClasses")) {
            throw new LdapInvalidDnException(ResultCodeEnum.NAMING_VIOLATION, I18n.err((I18n)I18n.ERR_377, (Object[])new Object[0]));
        }
    }
}

