/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.filter;

import java.io.IOException;
import java.util.UUID;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.knox.gateway.audit.api.CorrelationContext;
import org.apache.knox.gateway.audit.api.CorrelationService;
import org.apache.knox.gateway.audit.api.CorrelationServiceFactory;
import org.apache.knox.gateway.audit.log4j.correlation.Log4jCorrelationContext;
import org.apache.logging.log4j.CloseableThreadContext;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.handler.HandlerWrapper;

public class CorrelationHandler
extends HandlerWrapper {
    public static final String REQUEST_ID_HEADER_NAME = "X-Request-Id";
    public static final String TRACE_ID = "trace_id";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        CorrelationService correlationService = CorrelationServiceFactory.getCorrelationService();
        String reqID = StringUtils.isBlank((CharSequence)request.getHeader(REQUEST_ID_HEADER_NAME)) ? UUID.randomUUID().toString() : request.getHeader(REQUEST_ID_HEADER_NAME);
        correlationService.attachContext((CorrelationContext)new Log4jCorrelationContext(reqID, null, null));
        try (CloseableThreadContext.Instance ctc = CloseableThreadContext.put((String)TRACE_ID, (String)reqID);){
            super.handle(target, baseRequest, request, response);
        }
        finally {
            correlationService.detachContext();
        }
    }
}

