/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.api.swagger.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@ApiModel(description="Metadata for a time series.")
public class ApiTimeSeriesMetadata {
    @SerializedName(value="metricName")
    private String metricName = null;
    @SerializedName(value="entityName")
    private String entityName = null;
    @SerializedName(value="startTime")
    private String startTime = null;
    @SerializedName(value="endTime")
    private String endTime = null;
    @SerializedName(value="attributes")
    private Map<String, String> attributes = null;
    @SerializedName(value="unitNumerators")
    private List<String> unitNumerators = null;
    @SerializedName(value="unitDenominators")
    private List<String> unitDenominators = null;
    @SerializedName(value="expression")
    private String expression = null;
    @SerializedName(value="alias")
    private String alias = null;
    @SerializedName(value="metricCollectionFrequencyMs")
    private BigDecimal metricCollectionFrequencyMs = null;
    @SerializedName(value="rollupUsed")
    private String rollupUsed = null;

    public ApiTimeSeriesMetadata metricName(String metricName) {
        this.metricName = metricName;
        return this;
    }

    @ApiModelProperty(value="The metric name for the time series.")
    public String getMetricName() {
        return this.metricName;
    }

    public void setMetricName(String metricName) {
        this.metricName = metricName;
    }

    public ApiTimeSeriesMetadata entityName(String entityName) {
        this.entityName = entityName;
        return this;
    }

    @ApiModelProperty(value="The display name for the entity associated with this time series. For example, if this was a time series for an HDFS service the entity name might be something like \"My HDFS Service\". If it was for a host it might be something like \"myhost.mysite.com\".")
    public String getEntityName() {
        return this.entityName;
    }

    public void setEntityName(String entityName) {
        this.entityName = entityName;
    }

    public ApiTimeSeriesMetadata startTime(String startTime) {
        this.startTime = startTime;
        return this;
    }

    @ApiModelProperty(value="The start time for the time series.")
    public String getStartTime() {
        return this.startTime;
    }

    public void setStartTime(String startTime) {
        this.startTime = startTime;
    }

    public ApiTimeSeriesMetadata endTime(String endTime) {
        this.endTime = endTime;
        return this;
    }

    @ApiModelProperty(value="The end time for the time series.")
    public String getEndTime() {
        return this.endTime;
    }

    public void setEndTime(String endTime) {
        this.endTime = endTime;
    }

    public ApiTimeSeriesMetadata attributes(Map<String, String> attributes) {
        this.attributes = attributes;
        return this;
    }

    public ApiTimeSeriesMetadata putAttributesItem(String key, String attributesItem) {
        if (this.attributes == null) {
            this.attributes = new HashMap<String, String>();
        }
        this.attributes.put(key, attributesItem);
        return this;
    }

    @ApiModelProperty(value="The attributes for the time series. Note that the entityName entry in this map is not the same as the entityName field in this ApiTimeSeriesMetadata. The entityName entry in this map is a unique identifier for the entity and not the name displayed in the UI.  For example, if this was a time series for the YARN Job History Server the entityName entry in this map might be something like \"yarn-JOBHISTORY-6bd17ceb1489aae93fef4c867350d0dd\"")
    public Map<String, String> getAttributes() {
        return this.attributes;
    }

    public void setAttributes(Map<String, String> attributes) {
        this.attributes = attributes;
    }

    public ApiTimeSeriesMetadata unitNumerators(List<String> unitNumerators) {
        this.unitNumerators = unitNumerators;
        return this;
    }

    public ApiTimeSeriesMetadata addUnitNumeratorsItem(String unitNumeratorsItem) {
        if (this.unitNumerators == null) {
            this.unitNumerators = new ArrayList<String>();
        }
        this.unitNumerators.add(unitNumeratorsItem);
        return this;
    }

    @ApiModelProperty(value="The numerators of the units for the time series.")
    public List<String> getUnitNumerators() {
        return this.unitNumerators;
    }

    public void setUnitNumerators(List<String> unitNumerators) {
        this.unitNumerators = unitNumerators;
    }

    public ApiTimeSeriesMetadata unitDenominators(List<String> unitDenominators) {
        this.unitDenominators = unitDenominators;
        return this;
    }

    public ApiTimeSeriesMetadata addUnitDenominatorsItem(String unitDenominatorsItem) {
        if (this.unitDenominators == null) {
            this.unitDenominators = new ArrayList<String>();
        }
        this.unitDenominators.add(unitDenominatorsItem);
        return this;
    }

    @ApiModelProperty(value="The denominators of the units for the time series.")
    public List<String> getUnitDenominators() {
        return this.unitDenominators;
    }

    public void setUnitDenominators(List<String> unitDenominators) {
        this.unitDenominators = unitDenominators;
    }

    public ApiTimeSeriesMetadata expression(String expression) {
        this.expression = expression;
        return this;
    }

    @ApiModelProperty(value="The tsquery expression that could be used to extract just this stream.")
    public String getExpression() {
        return this.expression;
    }

    public void setExpression(String expression) {
        this.expression = expression;
    }

    public ApiTimeSeriesMetadata alias(String alias) {
        this.alias = alias;
        return this;
    }

    @ApiModelProperty(value="The alias for this stream's metric. Aliases correspond to use of the 'as' keyword in the tsquery.")
    public String getAlias() {
        return this.alias;
    }

    public void setAlias(String alias) {
        this.alias = alias;
    }

    public ApiTimeSeriesMetadata metricCollectionFrequencyMs(BigDecimal metricCollectionFrequencyMs) {
        this.metricCollectionFrequencyMs = metricCollectionFrequencyMs;
        return this;
    }

    @ApiModelProperty(value="The minimum frequency at which the underlying metric for this stream is collected. Note that this can be null if the stream returns irregularly sampled data.")
    public BigDecimal getMetricCollectionFrequencyMs() {
        return this.metricCollectionFrequencyMs;
    }

    public void setMetricCollectionFrequencyMs(BigDecimal metricCollectionFrequencyMs) {
        this.metricCollectionFrequencyMs = metricCollectionFrequencyMs;
    }

    public ApiTimeSeriesMetadata rollupUsed(String rollupUsed) {
        this.rollupUsed = rollupUsed;
        return this;
    }

    @ApiModelProperty(value="The aggregate rollup for the returned data. This can be TEN_MINUTELY, HOURLY, SIX_HOURLY, DAILY, or WEEKLY.")
    public String getRollupUsed() {
        return this.rollupUsed;
    }

    public void setRollupUsed(String rollupUsed) {
        this.rollupUsed = rollupUsed;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ApiTimeSeriesMetadata apiTimeSeriesMetadata = (ApiTimeSeriesMetadata)o;
        return Objects.equals(this.metricName, apiTimeSeriesMetadata.metricName) && Objects.equals(this.entityName, apiTimeSeriesMetadata.entityName) && Objects.equals(this.startTime, apiTimeSeriesMetadata.startTime) && Objects.equals(this.endTime, apiTimeSeriesMetadata.endTime) && Objects.equals(this.attributes, apiTimeSeriesMetadata.attributes) && Objects.equals(this.unitNumerators, apiTimeSeriesMetadata.unitNumerators) && Objects.equals(this.unitDenominators, apiTimeSeriesMetadata.unitDenominators) && Objects.equals(this.expression, apiTimeSeriesMetadata.expression) && Objects.equals(this.alias, apiTimeSeriesMetadata.alias) && Objects.equals(this.metricCollectionFrequencyMs, apiTimeSeriesMetadata.metricCollectionFrequencyMs) && Objects.equals(this.rollupUsed, apiTimeSeriesMetadata.rollupUsed);
    }

    public int hashCode() {
        return Objects.hash(this.metricName, this.entityName, this.startTime, this.endTime, this.attributes, this.unitNumerators, this.unitDenominators, this.expression, this.alias, this.metricCollectionFrequencyMs, this.rollupUsed);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ApiTimeSeriesMetadata {\n");
        sb.append("    metricName: ").append(this.toIndentedString(this.metricName)).append("\n");
        sb.append("    entityName: ").append(this.toIndentedString(this.entityName)).append("\n");
        sb.append("    startTime: ").append(this.toIndentedString(this.startTime)).append("\n");
        sb.append("    endTime: ").append(this.toIndentedString(this.endTime)).append("\n");
        sb.append("    attributes: ").append(this.toIndentedString(this.attributes)).append("\n");
        sb.append("    unitNumerators: ").append(this.toIndentedString(this.unitNumerators)).append("\n");
        sb.append("    unitDenominators: ").append(this.toIndentedString(this.unitDenominators)).append("\n");
        sb.append("    expression: ").append(this.toIndentedString(this.expression)).append("\n");
        sb.append("    alias: ").append(this.toIndentedString(this.alias)).append("\n");
        sb.append("    metricCollectionFrequencyMs: ").append(this.toIndentedString(this.metricCollectionFrequencyMs)).append("\n");
        sb.append("    rollupUsed: ").append(this.toIndentedString(this.rollupUsed)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

