/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.ha.provider.impl;

import java.util.Collections;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.knox.gateway.ha.provider.HaDescriptor;
import org.apache.knox.gateway.ha.provider.HaProvider;
import org.apache.knox.gateway.ha.provider.HaServiceConfig;
import org.apache.knox.gateway.ha.provider.URLManager;
import org.apache.knox.gateway.ha.provider.URLManagerLoader;
import org.apache.knox.gateway.ha.provider.impl.i18n.HaMessages;
import org.apache.knox.gateway.i18n.messages.MessagesFactory;

public class DefaultHaProvider
implements HaProvider {
    private static final HaMessages LOG = (HaMessages)MessagesFactory.get(HaMessages.class);
    private HaDescriptor descriptor;
    private ConcurrentHashMap<String, URLManager> haServices;
    private ReentrantReadWriteLock rwl = new ReentrantReadWriteLock(true);

    public DefaultHaProvider(HaDescriptor descriptor) {
        if (descriptor == null) {
            throw new IllegalArgumentException("Descriptor can not be null");
        }
        this.descriptor = descriptor;
        this.haServices = new ConcurrentHashMap();
    }

    @Override
    public HaDescriptor getHaDescriptor() {
        return this.descriptor;
    }

    @Override
    public void addHaService(String serviceName, List<String> urls) {
        HaServiceConfig haServiceConfig = this.descriptor.getServiceConfig(serviceName);
        URLManager manager = URLManagerLoader.loadURLManager(haServiceConfig);
        manager.setURLs(urls);
        this.haServices.put(serviceName, manager);
    }

    @Override
    public boolean isHaEnabled(String serviceName) {
        HaServiceConfig config = this.descriptor.getServiceConfig(serviceName);
        return config != null && config.isEnabled();
    }

    @Override
    public String getActiveURL(String serviceName) {
        this.rwl.readLock().lock();
        try {
            if (this.haServices.containsKey(serviceName)) {
                String string = this.haServices.get(serviceName).getActiveURL();
                return string;
            }
            LOG.noActiveUrlFound(serviceName);
            String string = null;
            return string;
        }
        finally {
            this.rwl.readLock().unlock();
        }
    }

    @Override
    public void setActiveURL(String serviceName, String url) {
        this.rwl.writeLock().lock();
        try {
            if (this.haServices.containsKey(serviceName)) {
                this.haServices.get(serviceName).setActiveURL(url);
            } else {
                LOG.noServiceFound(serviceName);
            }
        }
        finally {
            this.rwl.writeLock().unlock();
        }
    }

    @Override
    public void markFailedURL(String serviceName, String url) {
        this.rwl.writeLock().lock();
        try {
            if (this.haServices.containsKey(serviceName)) {
                this.haServices.get(serviceName).markFailed(url);
            } else {
                LOG.noServiceFound(serviceName);
            }
        }
        finally {
            this.rwl.writeLock().unlock();
        }
    }

    @Override
    public void makeNextActiveURLAvailable(String serviceName) {
        this.rwl.writeLock().lock();
        try {
            if (this.haServices.containsKey(serviceName)) {
                this.haServices.get(serviceName).makeNextActiveURLAvailable();
            } else {
                LOG.noServiceFound(serviceName);
            }
        }
        finally {
            this.rwl.writeLock().unlock();
        }
    }

    @Override
    public List<String> getURLs(String serviceName) {
        if (this.haServices.containsKey(serviceName)) {
            return this.haServices.get(serviceName).getURLs();
        }
        LOG.noServiceFound(serviceName);
        return Collections.emptyList();
    }
}

