/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.identityasserter.common.filter;

import java.io.IOException;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.stream.Collectors;
import javax.security.auth.Subject;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.knox.gateway.IdentityAsserterMessages;
import org.apache.knox.gateway.i18n.messages.MessagesFactory;
import org.apache.knox.gateway.identityasserter.common.filter.AbstractIdentityAssertionFilter;
import org.apache.knox.gateway.identityasserter.common.filter.IdentityAsserterHttpServletRequestWrapper;
import org.apache.knox.gateway.identityasserter.common.filter.VirtualGroupMapper;
import org.apache.knox.gateway.plang.AbstractSyntaxTree;
import org.apache.knox.gateway.plang.Parser;
import org.apache.knox.gateway.plang.SyntaxException;
import org.apache.knox.gateway.security.GroupPrincipal;
import org.apache.knox.gateway.security.SubjectUtils;
import org.apache.knox.gateway.security.principal.PrincipalMappingException;
import org.apache.knox.gateway.security.principal.SimplePrincipalMapper;
import org.apache.knox.gateway.util.AuthFilterUtils;
import org.apache.knox.gateway.util.AuthorizationException;
import org.apache.knox.gateway.util.HttpExceptionUtils;

public class CommonIdentityAssertionFilter
extends AbstractIdentityAssertionFilter {
    private static final IdentityAsserterMessages LOG = (IdentityAsserterMessages)MessagesFactory.get(IdentityAsserterMessages.class);
    public static final String VIRTUAL_GROUP_MAPPING_PREFIX = "group.mapping.";
    public static final String GROUP_PRINCIPAL_MAPPING = "group.principal.mapping";
    public static final String PRINCIPAL_MAPPING = "principal.mapping";
    private static final String PRINCIPAL_PARAM = "user.name";
    private static final String DOAS_PRINCIPAL_PARAM = "doAs";
    static final String IMPERSONATION_ENABLED_PARAM = "hadoop.proxyuser.impersonation.enabled";
    private SimplePrincipalMapper mapper = new SimplePrincipalMapper();
    private final Parser parser = new Parser();
    private VirtualGroupMapper virtualGroupMapper;
    protected final List<String> impersonationParamsList = new ArrayList<String>();
    protected boolean impersonationEnabled;
    private String topologyName;

    public void init(FilterConfig filterConfig) throws ServletException {
        String groupPrincipalMapping;
        this.topologyName = (String)filterConfig.getServletContext().getAttribute("org.apache.knox.gateway.gateway.cluster");
        String principalMapping = filterConfig.getInitParameter(PRINCIPAL_MAPPING);
        if (principalMapping == null || principalMapping.isEmpty()) {
            principalMapping = filterConfig.getServletContext().getInitParameter(PRINCIPAL_MAPPING);
        }
        if ((groupPrincipalMapping = filterConfig.getInitParameter(GROUP_PRINCIPAL_MAPPING)) == null || groupPrincipalMapping.isEmpty()) {
            groupPrincipalMapping = filterConfig.getServletContext().getInitParameter(GROUP_PRINCIPAL_MAPPING);
        }
        if (principalMapping != null && !principalMapping.isEmpty() || groupPrincipalMapping != null && !groupPrincipalMapping.isEmpty()) {
            try {
                this.mapper.loadMappingTable(principalMapping, groupPrincipalMapping);
            }
            catch (PrincipalMappingException e) {
                throw new ServletException("Unable to load principal mapping table.", (Throwable)e);
            }
        }
        List initParameterNames = AuthFilterUtils.getInitParameterNamesAsList((FilterConfig)filterConfig);
        this.virtualGroupMapper = new VirtualGroupMapper(this.loadVirtualGroups(filterConfig, initParameterNames));
        this.initImpersonationParamsList(filterConfig);
        this.initProxyUserConfiguration(filterConfig, initParameterNames);
    }

    private void initImpersonationParamsList(FilterConfig filterConfig) {
        String impersonationListFromConfig = filterConfig.getInitParameter("impersonation.params");
        if (impersonationListFromConfig == null || impersonationListFromConfig.isEmpty()) {
            impersonationListFromConfig = filterConfig.getServletContext().getInitParameter("impersonation.params");
        }
        this.impersonationParamsList.add(DOAS_PRINCIPAL_PARAM);
        this.impersonationParamsList.add(PRINCIPAL_PARAM);
        if (impersonationListFromConfig != null && !impersonationListFromConfig.isEmpty()) {
            LOG.impersonationConfig(impersonationListFromConfig);
            StringTokenizer t = new StringTokenizer(impersonationListFromConfig, ",");
            while (t.hasMoreElements()) {
                String token = t.nextToken().trim();
                if (this.impersonationParamsList.contains(token)) continue;
                this.impersonationParamsList.add(token);
            }
        }
    }

    private void initProxyUserConfiguration(FilterConfig filterConfig, List<String> initParameterNames) {
        String impersonationEnabledValue = filterConfig.getInitParameter(IMPERSONATION_ENABLED_PARAM);
        boolean bl = this.impersonationEnabled = impersonationEnabledValue == null ? Boolean.FALSE : Boolean.parseBoolean(impersonationEnabledValue);
        if (this.impersonationEnabled) {
            if (AuthFilterUtils.hasProxyConfig((String)this.topologyName, (String)"HadoopAuth")) {
                LOG.ignoreProxyuserConfig();
                this.impersonationEnabled = false;
            } else {
                AuthFilterUtils.refreshSuperUserGroupsConfiguration((FilterConfig)filterConfig, initParameterNames, (String)this.topologyName, (String)"identity-assertion");
                filterConfig.getServletContext().setAttribute("org.apache.knox.gateway.gateway.proxyuser.impersonation.enabled", (Object)Boolean.TRUE);
            }
        } else {
            filterConfig.getServletContext().setAttribute("org.apache.knox.gateway.gateway.proxyuser.impersonation.enabled", (Object)Boolean.FALSE);
        }
    }

    boolean isImpersonationEnabled() {
        return this.impersonationEnabled;
    }

    private Map<String, AbstractSyntaxTree> loadVirtualGroups(FilterConfig filterConfig, List<String> initParameterNames) {
        HashMap<String, AbstractSyntaxTree> predicateToGroupMapping = new HashMap<String, AbstractSyntaxTree>();
        this.loadVirtualGroupConfig(filterConfig, initParameterNames, predicateToGroupMapping);
        if (predicateToGroupMapping.isEmpty() && filterConfig.getServletContext() != null) {
            this.loadVirtualGroupConfig(filterConfig.getServletContext(), predicateToGroupMapping);
        }
        return predicateToGroupMapping;
    }

    private void loadVirtualGroupConfig(FilterConfig config, List<String> initParameterNames, Map<String, AbstractSyntaxTree> result) {
        for (String paramName : CommonIdentityAssertionFilter.virtualGroupParameterNames(initParameterNames)) {
            this.addGroup(result, paramName, config.getInitParameter(paramName));
        }
    }

    private void loadVirtualGroupConfig(ServletContext context, Map<String, AbstractSyntaxTree> result) {
        List<String> contextInitParams = context.getInitParameterNames() == null ? Collections.emptyList() : Collections.list(context.getInitParameterNames());
        for (String paramName : CommonIdentityAssertionFilter.virtualGroupParameterNames(contextInitParams)) {
            this.addGroup(result, paramName, context.getInitParameter(paramName));
        }
    }

    private void addGroup(Map<String, AbstractSyntaxTree> result, String paramName, String predicate) {
        try {
            AbstractSyntaxTree ast = this.parser.parse(predicate);
            String groupName = paramName.substring(VIRTUAL_GROUP_MAPPING_PREFIX.length()).trim();
            if (StringUtils.isBlank((CharSequence)groupName)) {
                LOG.missingVirtualGroupName();
            } else {
                result.put(groupName, ast);
            }
        }
        catch (SyntaxException e) {
            LOG.parseError(paramName, predicate, e);
        }
    }

    private static List<String> virtualGroupParameterNames(List<String> initParameterNames) {
        return initParameterNames == null ? new ArrayList<String>() : initParameterNames.stream().filter(name -> name.startsWith(VIRTUAL_GROUP_MAPPING_PREFIX)).collect(Collectors.toList());
    }

    public void destroy() {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        Subject subject = Subject.getSubject(AccessController.getContext());
        if (subject == null) {
            LOG.subjectNotAvailable();
            throw new IllegalStateException("Required Subject Missing");
        }
        String mappedPrincipalName = null;
        try {
            mappedPrincipalName = this.handleProxyUserImpersonation(request, subject);
        }
        catch (AuthorizationException e) {
            LOG.hadoopAuthProxyUserFailed(e);
            HttpExceptionUtils.createServletExceptionResponse((HttpServletResponse)((HttpServletResponse)response), (int)403, (Throwable)e);
            return;
        }
        mappedPrincipalName = this.mapUserPrincipalBase(mappedPrincipalName);
        mappedPrincipalName = this.mapUserPrincipal(mappedPrincipalName);
        String[] mappedGroups = this.mapGroupPrincipalsBase(mappedPrincipalName, subject);
        String[] groups = this.mapGroupPrincipals(mappedPrincipalName, subject);
        String[] virtualGroups = this.virtualGroupMapper.mapGroups(mappedPrincipalName, this.combine(subject, groups), request).toArray(new String[0]);
        groups = this.combineGroupMappings(mappedGroups, groups);
        groups = this.combineGroupMappings(virtualGroups, groups);
        HttpServletRequestWrapper wrapper = this.wrapHttpServletRequest(request, mappedPrincipalName);
        this.continueChainAsPrincipal(wrapper, response, chain, mappedPrincipalName, CommonIdentityAssertionFilter.unique(groups));
    }

    private String handleProxyUserImpersonation(ServletRequest request, Subject subject) throws AuthorizationException {
        String doAsUser;
        String principalName = SubjectUtils.getEffectivePrincipalName((Subject)subject);
        if (this.impersonationEnabled && (doAsUser = request.getParameter(DOAS_PRINCIPAL_PARAM)) != null && !doAsUser.equals(principalName)) {
            LOG.hadoopAuthDoAsUser(doAsUser, principalName, request.getRemoteAddr());
            if (principalName != null) {
                AuthFilterUtils.authorizeImpersonationRequest((HttpServletRequest)((HttpServletRequest)request), (String)principalName, (String)doAsUser, (String)this.topologyName, (String)"identity-assertion");
                LOG.hadoopAuthProxyUserSuccess();
                principalName = doAsUser;
            }
        }
        return principalName;
    }

    private Set<String> combine(Subject subject, String[] groups) {
        Set<String> result = this.groups(subject);
        if (groups != null) {
            result.addAll(Arrays.asList(groups));
        }
        return result;
    }

    private static String[] unique(String[] groups) {
        return new HashSet<String>(Arrays.asList(groups)).toArray(new String[0]);
    }

    protected String[] combineGroupMappings(String[] mappedGroups, String[] groups) {
        if (mappedGroups != null && groups != null) {
            return (String[])ArrayUtils.addAll((Object[])mappedGroups, (Object[])groups);
        }
        return groups != null ? groups : mappedGroups;
    }

    public HttpServletRequestWrapper wrapHttpServletRequest(ServletRequest request, String mappedPrincipalName) {
        return new IdentityAsserterHttpServletRequestWrapper((HttpServletRequest)request, mappedPrincipalName, this.impersonationParamsList);
    }

    protected String[] mapGroupPrincipalsBase(String mappedPrincipalName, Subject subject) {
        return this.mapper.mapGroupPrincipal(mappedPrincipalName);
    }

    protected String mapUserPrincipalBase(String principalName) {
        return this.mapper.mapUserPrincipal(principalName);
    }

    private Set<String> groups(Subject subject) {
        return subject.getPrincipals(GroupPrincipal.class).stream().map(GroupPrincipal::getName).collect(Collectors.toSet());
    }

    @Override
    public String[] mapGroupPrincipals(String mappedPrincipalName, Subject subject) {
        return null;
    }

    @Override
    public String mapUserPrincipal(String principalName) {
        return principalName;
    }
}

