/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.api.swagger.model;

import com.cloudera.api.swagger.model.ApiCluster;
import com.cloudera.api.swagger.model.ApiCmPeer;
import com.cloudera.api.swagger.model.ApiConfigList;
import com.cloudera.api.swagger.model.ApiHost;
import com.cloudera.api.swagger.model.ApiHostTemplateList;
import com.cloudera.api.swagger.model.ApiService;
import com.cloudera.api.swagger.model.ApiUser;
import com.cloudera.api.swagger.model.ApiVersionInfo;
import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="This objects represents a deployment including all clusters, hosts, services, roles, etc in the system.  It can be used to save and restore all settings.")
public class ApiDeployment {
    @SerializedName(value="timestamp")
    private String timestamp = null;
    @SerializedName(value="clusters")
    private List<ApiCluster> clusters = null;
    @SerializedName(value="hosts")
    private List<ApiHost> hosts = null;
    @SerializedName(value="users")
    private List<ApiUser> users = null;
    @SerializedName(value="versionInfo")
    private ApiVersionInfo versionInfo = null;
    @SerializedName(value="managementService")
    private ApiService managementService = null;
    @SerializedName(value="managerSettings")
    private ApiConfigList managerSettings = null;
    @SerializedName(value="allHostsConfig")
    private ApiConfigList allHostsConfig = null;
    @SerializedName(value="peers")
    private List<ApiCmPeer> peers = null;
    @SerializedName(value="hostTemplates")
    private ApiHostTemplateList hostTemplates = null;

    public ApiDeployment timestamp(String timestamp) {
        this.timestamp = timestamp;
        return this;
    }

    @ApiModelProperty(value="Readonly. This timestamp is provided when you request a deployment and is not required (or even read) when creating a deployment. This timestamp is useful if you have multiple deployments saved and want to determine which one to use as a restore point.")
    public String getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(String timestamp) {
        this.timestamp = timestamp;
    }

    public ApiDeployment clusters(List<ApiCluster> clusters) {
        this.clusters = clusters;
        return this;
    }

    public ApiDeployment addClustersItem(ApiCluster clustersItem) {
        if (this.clusters == null) {
            this.clusters = new ArrayList<ApiCluster>();
        }
        this.clusters.add(clustersItem);
        return this;
    }

    @ApiModelProperty(value="List of clusters in the system including their services, roles and complete config values.")
    public List<ApiCluster> getClusters() {
        return this.clusters;
    }

    public void setClusters(List<ApiCluster> clusters) {
        this.clusters = clusters;
    }

    public ApiDeployment hosts(List<ApiHost> hosts) {
        this.hosts = hosts;
        return this;
    }

    public ApiDeployment addHostsItem(ApiHost hostsItem) {
        if (this.hosts == null) {
            this.hosts = new ArrayList<ApiHost>();
        }
        this.hosts.add(hostsItem);
        return this;
    }

    @ApiModelProperty(value="List of hosts in the system")
    public List<ApiHost> getHosts() {
        return this.hosts;
    }

    public void setHosts(List<ApiHost> hosts) {
        this.hosts = hosts;
    }

    public ApiDeployment users(List<ApiUser> users) {
        this.users = users;
        return this;
    }

    public ApiDeployment addUsersItem(ApiUser usersItem) {
        if (this.users == null) {
            this.users = new ArrayList<ApiUser>();
        }
        this.users.add(usersItem);
        return this;
    }

    @ApiModelProperty(value="List of all users in the system")
    public List<ApiUser> getUsers() {
        return this.users;
    }

    public void setUsers(List<ApiUser> users) {
        this.users = users;
    }

    public ApiDeployment versionInfo(ApiVersionInfo versionInfo) {
        this.versionInfo = versionInfo;
        return this;
    }

    @ApiModelProperty(value="Full version information about the running Cloudera Manager instance")
    public ApiVersionInfo getVersionInfo() {
        return this.versionInfo;
    }

    public void setVersionInfo(ApiVersionInfo versionInfo) {
        this.versionInfo = versionInfo;
    }

    public ApiDeployment managementService(ApiService managementService) {
        this.managementService = managementService;
        return this;
    }

    @ApiModelProperty(value="The full configuration of the Cloudera Manager management service including all the management roles and their config values")
    public ApiService getManagementService() {
        return this.managementService;
    }

    public void setManagementService(ApiService managementService) {
        this.managementService = managementService;
    }

    public ApiDeployment managerSettings(ApiConfigList managerSettings) {
        this.managerSettings = managerSettings;
        return this;
    }

    @ApiModelProperty(value="The full configuration of Cloudera Manager itself including licensing info")
    public ApiConfigList getManagerSettings() {
        return this.managerSettings;
    }

    public void setManagerSettings(ApiConfigList managerSettings) {
        this.managerSettings = managerSettings;
    }

    public ApiDeployment allHostsConfig(ApiConfigList allHostsConfig) {
        this.allHostsConfig = allHostsConfig;
        return this;
    }

    @ApiModelProperty(value="Configuration parameters that apply to all hosts, unless overridden at the host level. Available since API v3.")
    public ApiConfigList getAllHostsConfig() {
        return this.allHostsConfig;
    }

    public void setAllHostsConfig(ApiConfigList allHostsConfig) {
        this.allHostsConfig = allHostsConfig;
    }

    public ApiDeployment peers(List<ApiCmPeer> peers) {
        this.peers = peers;
        return this;
    }

    public ApiDeployment addPeersItem(ApiCmPeer peersItem) {
        if (this.peers == null) {
            this.peers = new ArrayList<ApiCmPeer>();
        }
        this.peers.add(peersItem);
        return this;
    }

    @ApiModelProperty(value="The list of peers configured in Cloudera Manager. Available since API v3.")
    public List<ApiCmPeer> getPeers() {
        return this.peers;
    }

    public void setPeers(List<ApiCmPeer> peers) {
        this.peers = peers;
    }

    public ApiDeployment hostTemplates(ApiHostTemplateList hostTemplates) {
        this.hostTemplates = hostTemplates;
        return this;
    }

    @ApiModelProperty(value="The list of all host templates in Cloudera Manager.")
    public ApiHostTemplateList getHostTemplates() {
        return this.hostTemplates;
    }

    public void setHostTemplates(ApiHostTemplateList hostTemplates) {
        this.hostTemplates = hostTemplates;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ApiDeployment apiDeployment = (ApiDeployment)o;
        return Objects.equals(this.timestamp, apiDeployment.timestamp) && Objects.equals(this.clusters, apiDeployment.clusters) && Objects.equals(this.hosts, apiDeployment.hosts) && Objects.equals(this.users, apiDeployment.users) && Objects.equals(this.versionInfo, apiDeployment.versionInfo) && Objects.equals(this.managementService, apiDeployment.managementService) && Objects.equals(this.managerSettings, apiDeployment.managerSettings) && Objects.equals(this.allHostsConfig, apiDeployment.allHostsConfig) && Objects.equals(this.peers, apiDeployment.peers) && Objects.equals(this.hostTemplates, apiDeployment.hostTemplates);
    }

    public int hashCode() {
        return Objects.hash(this.timestamp, this.clusters, this.hosts, this.users, this.versionInfo, this.managementService, this.managerSettings, this.allHostsConfig, this.peers, this.hostTemplates);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ApiDeployment {\n");
        sb.append("    timestamp: ").append(this.toIndentedString(this.timestamp)).append("\n");
        sb.append("    clusters: ").append(this.toIndentedString(this.clusters)).append("\n");
        sb.append("    hosts: ").append(this.toIndentedString(this.hosts)).append("\n");
        sb.append("    users: ").append(this.toIndentedString(this.users)).append("\n");
        sb.append("    versionInfo: ").append(this.toIndentedString(this.versionInfo)).append("\n");
        sb.append("    managementService: ").append(this.toIndentedString(this.managementService)).append("\n");
        sb.append("    managerSettings: ").append(this.toIndentedString(this.managerSettings)).append("\n");
        sb.append("    allHostsConfig: ").append(this.toIndentedString(this.allHostsConfig)).append("\n");
        sb.append("    peers: ").append(this.toIndentedString(this.peers)).append("\n");
        sb.append("    hostTemplates: ").append(this.toIndentedString(this.hostTemplates)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

