/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.codec.actions.request.add;

import org.apache.directory.api.asn1.ber.grammar.GrammarAction;
import org.apache.directory.api.asn1.ber.tlv.TLV;
import org.apache.directory.api.i18n.I18n;
import org.apache.directory.api.ldap.codec.api.LdapMessageContainer;
import org.apache.directory.api.ldap.model.entry.Attribute;
import org.apache.directory.api.ldap.model.exception.LdapException;
import org.apache.directory.api.ldap.model.message.AddRequest;
import org.apache.directory.api.util.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AddAttributeValue
extends GrammarAction<LdapMessageContainer<AddRequest>> {
    private static final Logger LOG = LoggerFactory.getLogger(AddAttributeValue.class);

    public AddAttributeValue() {
        super("Store a value");
    }

    public void action(LdapMessageContainer<AddRequest> container) {
        Attribute currentAttribute = container.getCurrentAttribute();
        TLV tlv = container.getCurrentTLV();
        Object value = null;
        try {
            if (tlv.getLength() == 0) {
                currentAttribute.add(new String[]{""});
            } else if (container.isBinary(currentAttribute.getId())) {
                value = tlv.getValue().getData();
                if (LOG.isDebugEnabled()) {
                    LOG.debug(I18n.msg((I18n)I18n.MSG_05112_ADDING_VALUE, (Object[])new Object[]{Strings.dumpBytes((byte[])value)}));
                }
                currentAttribute.add((byte[][])new byte[][]{value});
            } else {
                value = Strings.utf8ToString((byte[])tlv.getValue().getData());
                if (LOG.isDebugEnabled()) {
                    LOG.debug(I18n.msg((I18n)I18n.MSG_05112_ADDING_VALUE, (Object[])new Object[]{value}));
                }
                currentAttribute.add(new String[]{(String)value});
            }
        }
        catch (LdapException ldapException) {
            // empty catch block
        }
        container.setGrammarEndAllowed(true);
    }
}

