/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.api.swagger;

import com.cloudera.api.swagger.client.ApiCallback;
import com.cloudera.api.swagger.client.ApiClient;
import com.cloudera.api.swagger.client.ApiException;
import com.cloudera.api.swagger.client.ApiResponse;
import com.cloudera.api.swagger.client.Configuration;
import com.cloudera.api.swagger.client.Pair;
import com.cloudera.api.swagger.client.ProgressRequestBody;
import com.cloudera.api.swagger.client.ProgressResponseBody;
import com.cloudera.api.swagger.model.ApiConfigList;
import com.google.gson.reflect.TypeToken;
import com.squareup.okhttp.Call;
import com.squareup.okhttp.Interceptor;
import com.squareup.okhttp.Response;
import com.squareup.okhttp.ResponseBody;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;

public class AllHostsResourceApi {
    private ApiClient apiClient;

    public AllHostsResourceApi() {
        this(Configuration.getDefaultApiClient());
    }

    public AllHostsResourceApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public Call readConfigCall(String view, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/cm/allHosts/config";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        if (view != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "view", view));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"basic"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call readConfigValidateBeforeCall(String view, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Call call = this.readConfigCall(view, progressListener, progressRequestListener);
        return call;
    }

    public ApiConfigList readConfig(String view) throws ApiException {
        ApiResponse<ApiConfigList> resp = this.readConfigWithHttpInfo(view);
        return resp.getData();
    }

    public ApiResponse<ApiConfigList> readConfigWithHttpInfo(String view) throws ApiException {
        Call call = this.readConfigValidateBeforeCall(view, null, null);
        Type localVarReturnType = new TypeToken<ApiConfigList>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call readConfigAsync(String view, final ApiCallback<ApiConfigList> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.readConfigValidateBeforeCall(view, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<ApiConfigList>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call updateConfigCall(String message, ApiConfigList body, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        ApiConfigList localVarPostBody = body;
        String localVarPath = "/cm/allHosts/config";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        if (message != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "message", message));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"basic"};
        return this.apiClient.buildCall(localVarPath, "PUT", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call updateConfigValidateBeforeCall(String message, ApiConfigList body, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Call call = this.updateConfigCall(message, body, progressListener, progressRequestListener);
        return call;
    }

    public ApiConfigList updateConfig(String message, ApiConfigList body) throws ApiException {
        ApiResponse<ApiConfigList> resp = this.updateConfigWithHttpInfo(message, body);
        return resp.getData();
    }

    public ApiResponse<ApiConfigList> updateConfigWithHttpInfo(String message, ApiConfigList body) throws ApiException {
        Call call = this.updateConfigValidateBeforeCall(message, body, null, null);
        Type localVarReturnType = new TypeToken<ApiConfigList>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call updateConfigAsync(String message, ApiConfigList body, final ApiCallback<ApiConfigList> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.updateConfigValidateBeforeCall(message, body, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<ApiConfigList>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
}

