/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.cas.config;

import java.nio.charset.StandardCharsets;
import java.security.PrivateKey;
import java.util.HashMap;
import java.util.Map;
import org.jasig.cas.client.proxy.ProxyGrantingTicketStorage;
import org.jasig.cas.client.util.PrivateKeyUtils;
import org.jasig.cas.client.validation.Cas10TicketValidator;
import org.jasig.cas.client.validation.Cas20ProxyTicketValidator;
import org.jasig.cas.client.validation.Cas20ServiceTicketValidator;
import org.jasig.cas.client.validation.Cas30ProxyTicketValidator;
import org.jasig.cas.client.validation.Cas30ServiceTicketValidator;
import org.jasig.cas.client.validation.ProxyList;
import org.jasig.cas.client.validation.Saml11TicketValidator;
import org.jasig.cas.client.validation.TicketValidator;
import org.pac4j.cas.client.CasProxyReceptor;
import org.pac4j.cas.config.CasProtocol;
import org.pac4j.cas.store.ProxyGrantingTicketStore;
import org.pac4j.core.client.config.BaseClientConfiguration;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.exception.TechnicalException;
import org.pac4j.core.http.url.DefaultUrlResolver;
import org.pac4j.core.http.url.UrlResolver;
import org.pac4j.core.logout.handler.DefaultLogoutHandler;
import org.pac4j.core.logout.handler.LogoutHandler;
import org.pac4j.core.util.CommonHelper;

public class CasConfiguration
extends BaseClientConfiguration {
    public static final String TICKET_PARAMETER = "ticket";
    public static final String SERVICE_PARAMETER = "service";
    public static final String LOGOUT_REQUEST_PARAMETER = "logoutRequest";
    public static final String SESSION_INDEX_TAG = "SessionIndex";
    public static final String RELAY_STATE_PARAMETER = "RelayState";
    private String encoding = StandardCharsets.UTF_8.name();
    private String loginUrl;
    private String prefixUrl;
    private String restUrl;
    private long timeTolerance = 1000L;
    private CasProtocol protocol = CasProtocol.CAS30;
    private boolean renew = false;
    private boolean gateway = false;
    private boolean acceptAnyProxy = false;
    private ProxyList allowedProxyChains = new ProxyList();
    private LogoutHandler logoutHandler;
    private TicketValidator defaultTicketValidator;
    private CasProxyReceptor proxyReceptor;
    private UrlResolver urlResolver;
    private String postLogoutUrlParameter = "service";
    private Map<String, String> customParams = new HashMap<String, String>();
    private String method;
    private String privateKeyPath;
    private String privateKeyAlgorithm;
    private PrivateKey privateKey;

    public CasConfiguration() {
    }

    public CasConfiguration(String loginUrl) {
        this.loginUrl = loginUrl;
    }

    public CasConfiguration(String loginUrl, CasProtocol protocol) {
        this.loginUrl = loginUrl;
        this.protocol = protocol;
    }

    public CasConfiguration(String loginUrl, String prefixUrl) {
        this.loginUrl = loginUrl;
        this.prefixUrl = prefixUrl;
    }

    protected void internalInit() {
        if (CommonHelper.isBlank((String)this.loginUrl) && CommonHelper.isBlank((String)this.prefixUrl) && CommonHelper.isBlank((String)this.restUrl)) {
            throw new TechnicalException("loginUrl, prefixUrl and restUrl cannot be all blank");
        }
        if (this.urlResolver == null) {
            this.urlResolver = new DefaultUrlResolver();
        }
        this.initializeClientConfiguration();
        this.initializeLogoutHandler();
        if (this.privateKeyPath != null) {
            String algo = this.privateKeyAlgorithm != null ? this.privateKeyAlgorithm : "RSA";
            this.privateKey = PrivateKeyUtils.createKey((String)this.privateKeyPath, (String)algo);
        }
    }

    protected void initializeClientConfiguration() {
        if (this.prefixUrl != null && !this.prefixUrl.endsWith("/")) {
            this.prefixUrl = this.prefixUrl + "/";
        }
        if (CommonHelper.isBlank((String)this.prefixUrl)) {
            this.prefixUrl = this.loginUrl.replaceFirst("/login$", "/");
        } else if (CommonHelper.isBlank((String)this.loginUrl)) {
            this.loginUrl = this.prefixUrl + "login";
        }
        if (CommonHelper.isBlank((String)this.restUrl)) {
            this.restUrl = this.prefixUrl;
            if (!this.restUrl.endsWith("/")) {
                this.restUrl = this.restUrl + "/";
            }
            this.restUrl = this.restUrl + "v1/tickets";
        }
    }

    protected void initializeLogoutHandler() {
        if (this.logoutHandler == null) {
            this.logoutHandler = new DefaultLogoutHandler();
        }
    }

    public TicketValidator retrieveTicketValidator(WebContext context) {
        if (this.defaultTicketValidator != null) {
            return this.defaultTicketValidator;
        }
        if (this.protocol == CasProtocol.CAS10) {
            return this.buildCas10TicketValidator(context);
        }
        if (this.protocol == CasProtocol.CAS20) {
            return this.buildCas20TicketValidator(context);
        }
        if (this.protocol == CasProtocol.CAS20_PROXY) {
            return this.buildCas20ProxyTicketValidator(context);
        }
        if (this.protocol == CasProtocol.CAS30) {
            return this.buildCas30TicketValidator(context);
        }
        if (this.protocol == CasProtocol.CAS30_PROXY) {
            return this.buildCas30ProxyTicketValidator(context);
        }
        if (this.protocol == CasProtocol.SAML) {
            return this.buildSAMLTicketValidator(context);
        }
        throw new TechnicalException("Unable to initialize the TicketValidator for protocol: " + (Object)((Object)this.protocol));
    }

    protected TicketValidator buildSAMLTicketValidator(WebContext context) {
        Saml11TicketValidator saml11TicketValidator = new Saml11TicketValidator(this.computeFinalPrefixUrl(context));
        saml11TicketValidator.setTolerance(this.getTimeTolerance());
        saml11TicketValidator.setEncoding(this.encoding);
        saml11TicketValidator.setRenew(this.renew);
        return saml11TicketValidator;
    }

    protected void addPrivateKey(Cas20ServiceTicketValidator validator) {
        if (this.privateKey != null) {
            validator.setPrivateKey(this.privateKey);
        }
    }

    protected TicketValidator buildCas30ProxyTicketValidator(WebContext context) {
        Cas30ProxyTicketValidator cas30ProxyTicketValidator = new Cas30ProxyTicketValidator(this.computeFinalPrefixUrl(context));
        cas30ProxyTicketValidator.setEncoding(this.encoding);
        cas30ProxyTicketValidator.setRenew(this.renew);
        cas30ProxyTicketValidator.setAcceptAnyProxy(this.acceptAnyProxy);
        cas30ProxyTicketValidator.setAllowedProxyChains(this.allowedProxyChains);
        if (this.proxyReceptor != null) {
            cas30ProxyTicketValidator.setProxyCallbackUrl(this.proxyReceptor.computeFinalCallbackUrl(context));
            cas30ProxyTicketValidator.setProxyGrantingTicketStorage((ProxyGrantingTicketStorage)new ProxyGrantingTicketStore(this.proxyReceptor.getStore()));
        }
        this.addPrivateKey((Cas20ServiceTicketValidator)cas30ProxyTicketValidator);
        return cas30ProxyTicketValidator;
    }

    protected TicketValidator buildCas30TicketValidator(WebContext context) {
        Cas30ServiceTicketValidator cas30ServiceTicketValidator = new Cas30ServiceTicketValidator(this.computeFinalPrefixUrl(context));
        cas30ServiceTicketValidator.setEncoding(this.encoding);
        cas30ServiceTicketValidator.setRenew(this.renew);
        if (this.proxyReceptor != null) {
            cas30ServiceTicketValidator.setProxyCallbackUrl(this.proxyReceptor.computeFinalCallbackUrl(context));
            cas30ServiceTicketValidator.setProxyGrantingTicketStorage((ProxyGrantingTicketStorage)new ProxyGrantingTicketStore(this.proxyReceptor.getStore()));
        }
        this.addPrivateKey((Cas20ServiceTicketValidator)cas30ServiceTicketValidator);
        return cas30ServiceTicketValidator;
    }

    protected TicketValidator buildCas20ProxyTicketValidator(WebContext context) {
        Cas20ProxyTicketValidator cas20ProxyTicketValidator = new Cas20ProxyTicketValidator(this.computeFinalPrefixUrl(context));
        cas20ProxyTicketValidator.setEncoding(this.encoding);
        cas20ProxyTicketValidator.setRenew(this.renew);
        cas20ProxyTicketValidator.setAcceptAnyProxy(this.acceptAnyProxy);
        cas20ProxyTicketValidator.setAllowedProxyChains(this.allowedProxyChains);
        if (this.proxyReceptor != null) {
            cas20ProxyTicketValidator.setProxyCallbackUrl(this.proxyReceptor.computeFinalCallbackUrl(context));
            cas20ProxyTicketValidator.setProxyGrantingTicketStorage((ProxyGrantingTicketStorage)new ProxyGrantingTicketStore(this.proxyReceptor.getStore()));
        }
        this.addPrivateKey((Cas20ServiceTicketValidator)cas20ProxyTicketValidator);
        return cas20ProxyTicketValidator;
    }

    protected TicketValidator buildCas20TicketValidator(WebContext context) {
        Cas20ServiceTicketValidator cas20ServiceTicketValidator = new Cas20ServiceTicketValidator(this.computeFinalPrefixUrl(context));
        cas20ServiceTicketValidator.setEncoding(this.encoding);
        cas20ServiceTicketValidator.setRenew(this.renew);
        if (this.proxyReceptor != null) {
            cas20ServiceTicketValidator.setProxyCallbackUrl(this.proxyReceptor.computeFinalCallbackUrl(context));
            cas20ServiceTicketValidator.setProxyGrantingTicketStorage((ProxyGrantingTicketStorage)new ProxyGrantingTicketStore(this.proxyReceptor.getStore()));
        }
        this.addPrivateKey(cas20ServiceTicketValidator);
        return cas20ServiceTicketValidator;
    }

    protected TicketValidator buildCas10TicketValidator(WebContext context) {
        Cas10TicketValidator cas10TicketValidator = new Cas10TicketValidator(this.computeFinalPrefixUrl(context));
        cas10TicketValidator.setEncoding(this.encoding);
        cas10TicketValidator.setRenew(this.renew);
        return cas10TicketValidator;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public String computeFinalLoginUrl(WebContext context) {
        this.init();
        return this.urlResolver.compute(this.loginUrl, context);
    }

    public String getLoginUrl() {
        return this.loginUrl;
    }

    public void setLoginUrl(String loginUrl) {
        this.loginUrl = loginUrl;
    }

    public String getPrefixUrl() {
        return this.prefixUrl;
    }

    public String computeFinalPrefixUrl(WebContext context) {
        this.init();
        return this.urlResolver.compute(this.prefixUrl, context);
    }

    public void setPrefixUrl(String prefixUrl) {
        this.prefixUrl = prefixUrl;
    }

    public Map<String, String> getCustomParams() {
        return this.customParams;
    }

    public void setCustomParams(Map<String, String> customParams) {
        this.customParams = customParams;
    }

    public long getTimeTolerance() {
        return this.timeTolerance;
    }

    public void setTimeTolerance(long timeTolerance) {
        this.timeTolerance = timeTolerance;
    }

    public CasProtocol getProtocol() {
        return this.protocol;
    }

    public void setProtocol(CasProtocol protocol) {
        this.protocol = protocol;
    }

    public boolean isRenew() {
        return this.renew;
    }

    public void setRenew(boolean renew) {
        this.renew = renew;
    }

    public boolean isGateway() {
        return this.gateway;
    }

    public void setGateway(boolean gateway) {
        this.gateway = gateway;
    }

    public boolean isAcceptAnyProxy() {
        return this.acceptAnyProxy;
    }

    public void setAcceptAnyProxy(boolean acceptAnyProxy) {
        this.acceptAnyProxy = acceptAnyProxy;
    }

    public ProxyList getAllowedProxyChains() {
        return this.allowedProxyChains;
    }

    public void setAllowedProxyChains(ProxyList allowedProxyChains) {
        this.allowedProxyChains = allowedProxyChains;
    }

    public LogoutHandler getLogoutHandler() {
        return this.logoutHandler;
    }

    public LogoutHandler findLogoutHandler() {
        this.init();
        return this.logoutHandler;
    }

    public void setLogoutHandler(LogoutHandler logoutHandler) {
        this.logoutHandler = logoutHandler;
    }

    public TicketValidator getDefaultTicketValidator() {
        return this.defaultTicketValidator;
    }

    public void setDefaultTicketValidator(TicketValidator defaultTicketValidator) {
        this.defaultTicketValidator = defaultTicketValidator;
    }

    public CasProxyReceptor getProxyReceptor() {
        return this.proxyReceptor;
    }

    public void setProxyReceptor(CasProxyReceptor proxyReceptor) {
        this.proxyReceptor = proxyReceptor;
    }

    public String getPostLogoutUrlParameter() {
        return this.postLogoutUrlParameter;
    }

    public void setPostLogoutUrlParameter(String postLogoutUrlParameter) {
        this.postLogoutUrlParameter = postLogoutUrlParameter;
    }

    public String getRestUrl() {
        return this.restUrl;
    }

    public void setRestUrl(String restUrl) {
        this.restUrl = restUrl;
    }

    public String computeFinalRestUrl(WebContext context) {
        this.init();
        return this.urlResolver.compute(this.restUrl, context);
    }

    public UrlResolver getUrlResolver() {
        return this.urlResolver;
    }

    public void setUrlResolver(UrlResolver urlResolver) {
        this.urlResolver = urlResolver;
    }

    public void addCustomParam(String name, String value) {
        this.customParams.put(name, value);
    }

    public String getMethod() {
        return this.method;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public String getPrivateKeyPath() {
        return this.privateKeyPath;
    }

    public void setPrivateKeyPath(String privateKeyPath) {
        this.privateKeyPath = privateKeyPath;
    }

    public String getPrivateKeyAlgorithm() {
        return this.privateKeyAlgorithm;
    }

    public void setPrivateKeyAlgorithm(String privateKeyAlgorithm) {
        this.privateKeyAlgorithm = privateKeyAlgorithm;
    }

    public String toString() {
        return CommonHelper.toNiceString(((Object)((Object)this)).getClass(), (Object[])new Object[]{"loginUrl", this.loginUrl, "prefixUrl", this.prefixUrl, "restUrl", this.restUrl, "protocol", this.protocol, "renew", this.renew, "gateway", this.gateway, "encoding", this.encoding, "logoutHandler", this.logoutHandler, "acceptAnyProxy", this.acceptAnyProxy, "allowedProxyChains", this.allowedProxyChains, "proxyReceptor", this.proxyReceptor, "timeTolerance", this.timeTolerance, "postLogoutUrlParameter", this.postLogoutUrlParameter, "defaultTicketValidator", this.defaultTicketValidator, "urlResolver", this.urlResolver, "method", this.method, "privateKeyPath", this.privateKeyPath, "privateKeyAlgorithm", this.privateKeyAlgorithm});
    }
}

