/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.identityasserter.common.filter;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import org.apache.commons.io.IOUtils;
import org.apache.knox.gateway.SpiGatewayMessages;
import org.apache.knox.gateway.i18n.messages.MessagesFactory;
import org.apache.knox.gateway.security.PrimaryPrincipal;
import org.apache.knox.gateway.servlet.SynchronousServletInputStreamAdapter;
import org.apache.knox.gateway.util.HttpUtils;

public class IdentityAsserterHttpServletRequestWrapper
extends HttpServletRequestWrapper {
    private static SpiGatewayMessages log = (SpiGatewayMessages)MessagesFactory.get(SpiGatewayMessages.class);
    private static final String PRINCIPAL_PARAM = "user.name";
    private static final String DOAS_PRINCIPAL_PARAM = "doAs";
    private String username;

    public IdentityAsserterHttpServletRequestWrapper(HttpServletRequest request, String principal) {
        super(request);
        this.username = principal;
    }

    public Principal getUserPrincipal() {
        return new PrimaryPrincipal(this.username);
    }

    public String getParameter(String name) {
        if (name.equals(PRINCIPAL_PARAM)) {
            return this.username;
        }
        return super.getParameter(name);
    }

    public Map<String, String[]> getParameterMap() {
        return this.convertValuesToStringArrays();
    }

    private Map<String, String[]> convertValuesToStringArrays() {
        LinkedHashMap<String, String[]> arrayMap = new LinkedHashMap<String, String[]>();
        Enumeration<String> names = this.getParameterNames();
        while (names.hasMoreElements()) {
            String name = names.nextElement();
            arrayMap.put(name, this.getParameterValues(name));
        }
        return arrayMap;
    }

    public Enumeration<String> getParameterNames() {
        Enumeration<String> e = null;
        try {
            Map<String, List<String>> params = this.getParams();
            if (params == null) {
                params = new LinkedHashMap<String, List<String>>();
            }
            e = Collections.enumeration(params.keySet());
        }
        catch (UnsupportedEncodingException e1) {
            log.unableToGetParamsFromQueryString((Exception)e1);
        }
        return e;
    }

    public String[] getParameterValues(String name) {
        String[] p = new String[]{};
        try {
            Map<String, List<String>> params = this.getParams();
            if (params == null) {
                params = new LinkedHashMap<String, List<String>>();
            }
            p = params.get(name).toArray(p);
        }
        catch (UnsupportedEncodingException e) {
            log.unableToGetParamsFromQueryString((Exception)e);
        }
        return p;
    }

    private Map<String, List<String>> getParams(String qString) throws UnsupportedEncodingException {
        Map params;
        if (this.getMethod().equals("GET")) {
            params = qString != null && !qString.isEmpty() ? HttpUtils.splitQuery((String)qString) : new LinkedHashMap();
        } else {
            if (qString == null || qString.isEmpty()) {
                return null;
            }
            params = HttpUtils.splitQuery((String)qString);
        }
        return params;
    }

    private Map<String, List<String>> getParams() throws UnsupportedEncodingException {
        return this.getParams(super.getQueryString());
    }

    public String getQueryString() {
        String q = null;
        try {
            Map<String, List<String>> params = this.getParams();
            if (params == null) {
                params = new LinkedHashMap<String, List<String>>();
            }
            ArrayList<String> al = new ArrayList<String>();
            al.add(this.username);
            List<String> principalParamNames = this.getImpersonationParamNames();
            params = this.scrubOfExistingPrincipalParams(params, principalParamNames);
            if (Boolean.parseBoolean(System.getProperty("gateway.hadoop.kerberos.secured"))) {
                params.put(DOAS_PRINCIPAL_PARAM, al);
            } else {
                params.put(PRINCIPAL_PARAM, al);
            }
            String encoding = this.getCharacterEncoding();
            if (encoding == null) {
                encoding = Charset.defaultCharset().name();
            }
            q = IdentityAsserterHttpServletRequestWrapper.urlEncode(params, encoding);
        }
        catch (UnsupportedEncodingException e) {
            log.unableToGetParamsFromQueryString((Exception)e);
        }
        return q;
    }

    private List<String> getImpersonationParamNames() {
        ArrayList<String> principalParamNames = new ArrayList<String>();
        principalParamNames.add(DOAS_PRINCIPAL_PARAM);
        principalParamNames.add(PRINCIPAL_PARAM);
        return principalParamNames;
    }

    private Map<String, List<String>> scrubOfExistingPrincipalParams(Map<String, List<String>> params, List<String> principalParamNames) {
        HashSet<String> remove = new HashSet<String>();
        for (String paramKey : params.keySet()) {
            for (String p : principalParamNames) {
                if (!p.equalsIgnoreCase(paramKey)) continue;
                remove.add(paramKey);
                log.possibleIdentitySpoofingAttempt(paramKey);
            }
        }
        params.keySet().removeAll(remove);
        return params;
    }

    public int getContentLength() {
        String contentType = this.getContentType();
        int len = contentType != null && contentType.startsWith("application/x-www-form-urlencoded") ? -1 : super.getContentLength();
        return len;
    }

    public ServletInputStream getInputStream() throws IOException {
        String contentType = this.getContentType();
        if (contentType != null && contentType.startsWith("application/x-www-form-urlencoded")) {
            String body;
            Map<String, List<String>> params;
            String encoding = this.getCharacterEncoding();
            if (encoding == null) {
                encoding = Charset.defaultCharset().name();
            }
            if ((params = this.getParams(body = IOUtils.toString((InputStream)super.getInputStream(), (String)encoding))) == null) {
                params = new LinkedHashMap<String, List<String>>();
            }
            body = IdentityAsserterHttpServletRequestWrapper.urlEncode(params, encoding);
            return new ServletInputStreamWrapper(new ByteArrayInputStream(body.getBytes(StandardCharsets.US_ASCII.name())));
        }
        return super.getInputStream();
    }

    static String urlEncode(String string, String encoding) {
        try {
            return URLEncoder.encode(string, encoding);
        }
        catch (UnsupportedEncodingException e) {
            throw new UnsupportedOperationException(e);
        }
    }

    public static String urlEncode(Map<String, List<String>> map, String encoding) {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, List<String>> entry : map.entrySet()) {
            String name = entry.getKey();
            if (name == null || name.isEmpty()) continue;
            List<String> values = entry.getValue();
            if (values == null || values.isEmpty()) {
                sb.append(entry.getKey());
                continue;
            }
            for (String value : values) {
                if (sb.length() > 0) {
                    sb.append('&');
                }
                try {
                    sb.append(IdentityAsserterHttpServletRequestWrapper.urlEncode(name, encoding));
                    if (value == null) continue;
                    sb.append('=');
                    sb.append(IdentityAsserterHttpServletRequestWrapper.urlEncode(value, encoding));
                }
                catch (IllegalArgumentException e) {
                    log.skippingUnencodableParameter(name, value, encoding, (Exception)e);
                }
            }
        }
        return sb.toString();
    }

    private static class ServletInputStreamWrapper
    extends SynchronousServletInputStreamAdapter {
        private InputStream stream;

        ServletInputStreamWrapper(InputStream stream) {
            this.stream = stream;
        }

        public int read() throws IOException {
            return this.stream.read();
        }

        public int read(byte[] b) throws IOException {
            return this.stream.read(b);
        }

        public int read(byte[] b, int off, int len) throws IOException {
            return this.stream.read(b, off, len);
        }

        public long skip(long n) throws IOException {
            return this.stream.skip(n);
        }

        public int available() throws IOException {
            return this.stream.available();
        }

        public void close() throws IOException {
            this.stream.close();
        }

        public synchronized void mark(int readlimit) {
            this.stream.mark(readlimit);
        }

        public synchronized void reset() throws IOException {
            this.stream.reset();
        }

        public boolean markSupported() {
            return this.stream.markSupported();
        }
    }
}

