/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.server.internal.monitoring;

import org.glassfish.jersey.server.internal.monitoring.ExecutionStatisticsImpl;
import org.glassfish.jersey.server.model.ResourceMethod;
import org.glassfish.jersey.server.monitoring.ExecutionStatistics;
import org.glassfish.jersey.server.monitoring.ResourceMethodStatistics;

class ResourceMethodStatisticsImpl
implements ResourceMethodStatistics {
    private final ExecutionStatisticsImpl resourceMethodExecutionStatisticsImpl;
    private final ExecutionStatisticsImpl requestExecutionStatisticsImpl;
    private final ResourceMethod resourceMethod;

    private ResourceMethodStatisticsImpl(ResourceMethod resourceMethod, ExecutionStatisticsImpl resourceMethodExecutionStatisticsImpl, ExecutionStatisticsImpl requestExecutionStatisticsImpl) {
        this.resourceMethodExecutionStatisticsImpl = resourceMethodExecutionStatisticsImpl;
        this.resourceMethod = resourceMethod;
        this.requestExecutionStatisticsImpl = requestExecutionStatisticsImpl;
    }

    @Override
    public ExecutionStatistics getRequestStatistics() {
        return this.requestExecutionStatisticsImpl;
    }

    @Override
    public ExecutionStatistics getMethodStatistics() {
        return this.resourceMethodExecutionStatisticsImpl;
    }

    @Override
    public ResourceMethod getResourceMethod() {
        return this.resourceMethod;
    }

    @Override
    public ResourceMethodStatistics snapshot() {
        return this;
    }

    static class Builder {
        private final ExecutionStatisticsImpl.Builder resourceMethodExecutionStatisticsBuilder;
        private final ExecutionStatisticsImpl.Builder requestExecutionStatisticsBuilder;
        private final ResourceMethod resourceMethod;

        Builder(ResourceMethod resourceMethod) {
            this.resourceMethod = resourceMethod;
            this.resourceMethodExecutionStatisticsBuilder = new ExecutionStatisticsImpl.Builder();
            this.requestExecutionStatisticsBuilder = new ExecutionStatisticsImpl.Builder();
        }

        ResourceMethodStatisticsImpl build() {
            return new ResourceMethodStatisticsImpl(this.resourceMethod, this.resourceMethodExecutionStatisticsBuilder.build(), this.requestExecutionStatisticsBuilder.build());
        }

        void addResourceMethodExecution(long methodStartTime, long methodDuration, long requestStartTime, long requestDuration) {
            this.resourceMethodExecutionStatisticsBuilder.addExecution(methodStartTime, methodDuration);
            this.requestExecutionStatisticsBuilder.addExecution(requestStartTime, requestDuration);
        }
    }
}

