/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.service.knoxtoken;

import java.security.KeyStoreException;
import java.security.Principal;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.PostConstruct;
import javax.inject.Singleton;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.apache.commons.codec.binary.Base64;
import org.apache.knox.gateway.config.GatewayConfig;
import org.apache.knox.gateway.i18n.messages.MessagesFactory;
import org.apache.knox.gateway.security.SubjectUtils;
import org.apache.knox.gateway.service.knoxtoken.TokenServiceMessages;
import org.apache.knox.gateway.services.GatewayServices;
import org.apache.knox.gateway.services.ServiceType;
import org.apache.knox.gateway.services.security.KeystoreService;
import org.apache.knox.gateway.services.security.KeystoreServiceException;
import org.apache.knox.gateway.services.security.token.JWTokenAuthority;
import org.apache.knox.gateway.services.security.token.TokenServiceException;
import org.apache.knox.gateway.services.security.token.TokenStateService;
import org.apache.knox.gateway.services.security.token.TokenUtils;
import org.apache.knox.gateway.services.security.token.UnknownTokenException;
import org.apache.knox.gateway.services.security.token.impl.JWT;
import org.apache.knox.gateway.services.security.token.impl.JWTToken;
import org.apache.knox.gateway.util.JsonUtils;
import org.apache.knox.gateway.util.Tokens;

@Singleton
@Path(value="knoxtoken/api/v1/token")
public class TokenResource {
    private static final String EXPIRES_IN = "expires_in";
    private static final String TOKEN_TYPE = "token_type";
    private static final String ACCESS_TOKEN = "access_token";
    private static final String TARGET_URL = "target_url";
    private static final String ENDPOINT_PUBLIC_CERT = "endpoint_public_cert";
    private static final String BEARER = "Bearer";
    private static final String TOKEN_TTL_PARAM = "knox.token.ttl";
    private static final String TOKEN_AUDIENCES_PARAM = "knox.token.audiences";
    private static final String TOKEN_TARGET_URL = "knox.token.target.url";
    private static final String TOKEN_CLIENT_DATA = "knox.token.client.data";
    private static final String TOKEN_CLIENT_CERT_REQUIRED = "knox.token.client.cert.required";
    private static final String TOKEN_ALLOWED_PRINCIPALS = "knox.token.allowed.principals";
    private static final String TOKEN_SIG_ALG = "knox.token.sigalg";
    private static final String TOKEN_EXP_RENEWAL_INTERVAL = "knox.token.exp.renew-interval";
    private static final String TOKEN_EXP_RENEWAL_MAX_LIFETIME = "knox.token.exp.max-lifetime";
    private static final String TOKEN_RENEWER_WHITELIST = "knox.token.renewer.whitelist";
    private static final long TOKEN_TTL_DEFAULT = 30000L;
    static final String RESOURCE_PATH = "knoxtoken/api/v1/token";
    static final String RENEW_PATH = "/renew";
    static final String REVOKE_PATH = "/revoke";
    private static final String TARGET_ENDPOINT_PULIC_CERT_PEM = "knox.token.target.endpoint.cert.pem";
    private static TokenServiceMessages log = (TokenServiceMessages)MessagesFactory.get(TokenServiceMessages.class);
    private long tokenTTL = 30000L;
    private List<String> targetAudiences = new ArrayList<String>();
    private String tokenTargetUrl;
    private Map<String, Object> tokenClientDataMap;
    private List<String> allowedDNs = new ArrayList<String>();
    private boolean clientCertRequired;
    private String signatureAlgorithm = "RS256";
    private String endpointPublicCert;
    private TokenStateService tokenStateService;
    private Optional<Long> renewInterval = Optional.empty();
    private Optional<Long> maxTokenLifetime = Optional.empty();
    private List<String> allowedRenewers;
    @Context
    HttpServletRequest request;
    @Context
    ServletContext context;

    @PostConstruct
    public void init() {
        String targetEndpointPublicCert;
        String sigAlg;
        String ttl;
        String audiences = this.context.getInitParameter(TOKEN_AUDIENCES_PARAM);
        if (audiences != null) {
            String[] auds;
            for (String aud : auds = audiences.split(",")) {
                this.targetAudiences.add(aud.trim());
            }
        }
        String clientCert = this.context.getInitParameter(TOKEN_CLIENT_CERT_REQUIRED);
        this.clientCertRequired = "true".equals(clientCert);
        String principals = this.context.getInitParameter(TOKEN_ALLOWED_PRINCIPALS);
        if (principals != null) {
            String[] dns;
            for (String dn : dns = principals.split(";")) {
                this.allowedDNs.add(dn.replaceAll("\\s+", ""));
            }
        }
        if ((ttl = this.context.getInitParameter(TOKEN_TTL_PARAM)) != null) {
            try {
                this.tokenTTL = Long.parseLong(ttl);
                if (this.tokenTTL < -1L || this.tokenTTL + System.currentTimeMillis() < 0L) {
                    log.invalidTokenTTLEncountered(ttl);
                    this.tokenTTL = 30000L;
                }
            }
            catch (NumberFormatException nfe) {
                log.invalidTokenTTLEncountered(ttl);
            }
        }
        this.tokenTargetUrl = this.context.getInitParameter(TOKEN_TARGET_URL);
        String clientData = this.context.getInitParameter(TOKEN_CLIENT_DATA);
        if (clientData != null) {
            this.tokenClientDataMap = new HashMap<String, Object>();
            String[] tokenClientData = clientData.split(",");
            this.addClientDataToMap(tokenClientData, this.tokenClientDataMap);
        }
        if ((sigAlg = this.context.getInitParameter(TOKEN_SIG_ALG)) != null) {
            this.signatureAlgorithm = sigAlg;
        }
        if ((targetEndpointPublicCert = this.context.getInitParameter(TARGET_ENDPOINT_PULIC_CERT_PEM)) != null) {
            this.endpointPublicCert = targetEndpointPublicCert;
        }
        if (this.isServerManagedTokenStateEnabled()) {
            String maxLifetimeValue;
            String topologyName = this.getTopologyName();
            log.serverManagedTokenStateEnabled(topologyName);
            GatewayServices services = (GatewayServices)this.context.getAttribute("org.apache.knox.gateway.gateway.services");
            this.tokenStateService = (TokenStateService)services.getService(ServiceType.TOKEN_STATE_SERVICE);
            String renewIntervalValue = this.context.getInitParameter(TOKEN_EXP_RENEWAL_INTERVAL);
            if (renewIntervalValue != null && !renewIntervalValue.isEmpty()) {
                try {
                    this.renewInterval = Optional.of(Long.parseLong(renewIntervalValue));
                }
                catch (NumberFormatException e) {
                    log.invalidConfigValue(topologyName, TOKEN_EXP_RENEWAL_INTERVAL, renewIntervalValue, e);
                }
            }
            if ((maxLifetimeValue = this.context.getInitParameter(TOKEN_EXP_RENEWAL_MAX_LIFETIME)) != null && !maxLifetimeValue.isEmpty()) {
                try {
                    this.maxTokenLifetime = Optional.of(Long.parseLong(maxLifetimeValue));
                }
                catch (NumberFormatException e) {
                    log.invalidConfigValue(topologyName, TOKEN_EXP_RENEWAL_MAX_LIFETIME, maxLifetimeValue, e);
                }
            }
            this.allowedRenewers = new ArrayList<String>();
            String renewerList = this.context.getInitParameter(TOKEN_RENEWER_WHITELIST);
            if (renewerList != null && !renewerList.isEmpty()) {
                for (String renewer : renewerList.split(",")) {
                    this.allowedRenewers.add(renewer.trim());
                }
            } else {
                log.noRenewersConfigured(topologyName);
            }
        }
    }

    private boolean isServerManagedTokenStateEnabled() {
        GatewayConfig config;
        String serviceParamValue = this.context.getInitParameter("knox.token.exp.server-managed");
        boolean isServerManaged = serviceParamValue == null || serviceParamValue.isEmpty() ? (config = (GatewayConfig)this.context.getAttribute("org.apache.knox.gateway.config")) != null && config.isServerManagedTokenStateEnabled() : Boolean.valueOf(serviceParamValue);
        return isServerManaged;
    }

    @GET
    @Produces(value={"application/json", "application/xml"})
    public Response doGet() {
        return this.getAuthenticationToken();
    }

    @POST
    @Produces(value={"application/json", "application/xml"})
    public Response doPost() {
        return this.getAuthenticationToken();
    }

    @POST
    @Path(value="/renew")
    @Produces(value={"application/json"})
    public Response renew(String token) {
        Response resp;
        long expiration = 0L;
        String error = "";
        Response.Status errorStatus = Response.Status.BAD_REQUEST;
        if (this.tokenStateService == null) {
            try {
                JWTToken jwt = new JWTToken(token);
                log.renewalDisabled(this.getTopologyName(), Tokens.getTokenDisplayText((String)token), TokenUtils.getTokenId((JWT)jwt));
                expiration = Long.parseLong(jwt.getExpires());
            }
            catch (ParseException e) {
                log.invalidToken(this.getTopologyName(), Tokens.getTokenDisplayText((String)token), e);
                error = this.safeGetMessage(e);
            }
            catch (Exception e) {
                error = this.safeGetMessage(e);
            }
        } else {
            String renewer = SubjectUtils.getCurrentEffectivePrincipalName();
            if (this.allowedRenewers.contains(renewer)) {
                try {
                    JWTToken jwt = new JWTToken(token);
                    expiration = this.tokenStateService.renewToken(jwt, this.renewInterval.orElse(this.tokenStateService.getDefaultRenewInterval()).longValue());
                    log.renewedToken(this.getTopologyName(), Tokens.getTokenDisplayText((String)token), TokenUtils.getTokenId((JWT)jwt), renewer);
                }
                catch (ParseException e) {
                    log.invalidToken(this.getTopologyName(), Tokens.getTokenDisplayText((String)token), e);
                    error = this.safeGetMessage(e);
                }
                catch (Exception e) {
                    error = this.safeGetMessage(e);
                }
            } else {
                errorStatus = Response.Status.FORBIDDEN;
                error = "Caller (" + renewer + ") not authorized to renew tokens.";
            }
        }
        if (error.isEmpty()) {
            resp = Response.status((Response.Status)Response.Status.OK).entity((Object)("{\n  \"renewed\": \"true\",\n  \"expires\": \"" + expiration + "\"\n}\n")).build();
        } else {
            log.badRenewalRequest(this.getTopologyName(), Tokens.getTokenDisplayText((String)token), error);
            resp = Response.status((Response.Status)errorStatus).entity((Object)("{\n  \"renewed\": \"false\",\n  \"error\": \"" + error + "\"\n}\n")).build();
        }
        return resp;
    }

    @POST
    @Path(value="/revoke")
    @Produces(value={"application/json"})
    public Response revoke(String token) {
        Response resp;
        String error = "";
        Response.Status errorStatus = Response.Status.BAD_REQUEST;
        if (this.tokenStateService == null) {
            error = "Token revocation support is not configured";
        } else {
            String renewer = SubjectUtils.getCurrentEffectivePrincipalName();
            if (this.allowedRenewers.contains(renewer)) {
                try {
                    JWTToken jwt = new JWTToken(token);
                    this.tokenStateService.revokeToken(jwt);
                    log.revokedToken(this.getTopologyName(), Tokens.getTokenDisplayText((String)token), TokenUtils.getTokenId((JWT)jwt), renewer);
                }
                catch (ParseException e) {
                    log.invalidToken(this.getTopologyName(), Tokens.getTokenDisplayText((String)token), e);
                    error = this.safeGetMessage(e);
                }
                catch (UnknownTokenException e) {
                    error = this.safeGetMessage(e);
                }
            } else {
                errorStatus = Response.Status.FORBIDDEN;
                error = "Caller (" + renewer + ") not authorized to revoke tokens.";
            }
        }
        if (error.isEmpty()) {
            resp = Response.status((Response.Status)Response.Status.OK).entity((Object)"{\n  \"revoked\": \"true\"\n}\n").build();
        } else {
            log.badRevocationRequest(this.getTopologyName(), Tokens.getTokenDisplayText((String)token), error);
            resp = Response.status((Response.Status)errorStatus).entity((Object)("{\n  \"revoked\": \"false\",\n  \"error\": \"" + error + "\"\n}\n")).build();
        }
        return resp;
    }

    private X509Certificate extractCertificate(HttpServletRequest req) {
        X509Certificate[] certs = (X509Certificate[])req.getAttribute("javax.servlet.request.X509Certificate");
        if (null != certs && certs.length > 0) {
            return certs[0];
        }
        return null;
    }

    private Response getAuthenticationToken() {
        KeystoreService ks;
        if (this.clientCertRequired) {
            X509Certificate cert = this.extractCertificate(this.request);
            if (cert != null) {
                if (!this.allowedDNs.contains(cert.getSubjectDN().getName().replaceAll("\\s+", ""))) {
                    return Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)"{ \"Unable to get token - untrusted client cert.\" }").build();
                }
            } else {
                return Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)"{ \"Unable to get token - client cert required.\" }").build();
            }
        }
        GatewayServices services = (GatewayServices)this.request.getServletContext().getAttribute("org.apache.knox.gateway.gateway.services");
        JWTokenAuthority ts = (JWTokenAuthority)services.getService(ServiceType.TOKEN_SERVICE);
        Principal p = this.request.getUserPrincipal();
        long expires = this.getExpiry();
        if (this.endpointPublicCert == null && (ks = (KeystoreService)services.getService(ServiceType.KEYSTORE_SERVICE)) != null) {
            try {
                Certificate cert = ks.getCertificateForGateway();
                byte[] bytes = cert.getEncoded();
                this.endpointPublicCert = Base64.encodeBase64String((byte[])bytes);
            }
            catch (KeyStoreException | CertificateEncodingException | KeystoreServiceException e) {
                log.unableToAcquireCertForEndpointClients((Exception)e);
            }
        }
        try {
            JWT token = this.targetAudiences.isEmpty() ? ts.issueToken(p, this.signatureAlgorithm, expires) : ts.issueToken(p, this.targetAudiences, this.signatureAlgorithm, expires);
            if (token != null) {
                String accessToken = token.toString();
                String tokenId = TokenUtils.getTokenId((JWT)token);
                log.issuedToken(this.getTopologyName(), Tokens.getTokenDisplayText((String)accessToken), tokenId);
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put(ACCESS_TOKEN, accessToken);
                map.put(TOKEN_TYPE, BEARER);
                map.put(EXPIRES_IN, expires);
                if (this.tokenTargetUrl != null) {
                    map.put(TARGET_URL, this.tokenTargetUrl);
                }
                if (this.tokenClientDataMap != null) {
                    map.putAll(this.tokenClientDataMap);
                }
                if (this.endpointPublicCert != null) {
                    map.put(ENDPOINT_PUBLIC_CERT, this.endpointPublicCert);
                }
                String jsonResponse = JsonUtils.renderAsJsonString(map);
                if (this.tokenStateService != null) {
                    this.tokenStateService.addToken(tokenId, System.currentTimeMillis(), expires, this.maxTokenLifetime.orElse(this.tokenStateService.getDefaultMaxLifetimeDuration()).longValue());
                    log.storedToken(this.getTopologyName(), Tokens.getTokenDisplayText((String)accessToken), tokenId);
                }
                return Response.ok().entity((Object)jsonResponse).build();
            }
            return Response.serverError().build();
        }
        catch (TokenServiceException e) {
            log.unableToIssueToken((Exception)((Object)e));
            return Response.ok().entity((Object)"{ \"Unable to acquire token.\" }").build();
        }
    }

    void addClientDataToMap(String[] tokenClientData, Map<String, Object> map) {
        for (String tokenClientDatum : tokenClientData) {
            String[] kv = tokenClientDatum.split("=");
            if (kv.length != 2) continue;
            map.put(kv[0], kv[1]);
        }
    }

    private long getExpiry() {
        long expiry = this.tokenTTL == -1L ? -1L : System.currentTimeMillis() + this.tokenTTL;
        return expiry;
    }

    private String getTopologyName() {
        return (String)this.context.getAttribute("org.apache.knox.gateway.gateway.cluster");
    }

    private String safeGetMessage(Throwable t) {
        String message = t.getMessage();
        return message != null ? message : "null";
    }
}

