/*
 * Decompiled with CFR 0.152.
 */
package org.ldaptive.handler;

import java.util.HashSet;
import org.ldaptive.Connection;
import org.ldaptive.LdapAttribute;
import org.ldaptive.LdapException;
import org.ldaptive.SearchEntry;
import org.ldaptive.SearchRequest;
import org.ldaptive.handler.HandlerResult;
import org.ldaptive.handler.SearchEntryHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractSearchEntryHandler
implements SearchEntryHandler {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());

    @Override
    public HandlerResult<SearchEntry> handle(Connection conn, SearchRequest request, SearchEntry entry) throws LdapException {
        if (entry != null) {
            entry.setDn(this.handleDn(conn, request, entry));
            this.handleAttributes(conn, request, entry);
        }
        return new HandlerResult<SearchEntry>(entry);
    }

    protected String handleDn(Connection conn, SearchRequest request, SearchEntry entry) {
        return entry.getDn();
    }

    protected void handleAttributes(Connection conn, SearchRequest request, SearchEntry entry) throws LdapException {
        for (LdapAttribute la : entry.getAttributes()) {
            this.handleAttribute(conn, request, la);
        }
    }

    protected void handleAttribute(Connection conn, SearchRequest request, LdapAttribute attr) throws LdapException {
        if (attr != null) {
            attr.setName(this.handleAttributeName(conn, request, attr.getName()));
            if (attr.isBinary()) {
                HashSet<byte[]> newValues = new HashSet<byte[]>(attr.size());
                for (byte[] b : attr.getBinaryValues()) {
                    newValues.add(this.handleAttributeValue(conn, request, b));
                }
                attr.clear();
                attr.addBinaryValues(newValues);
            } else {
                HashSet<String> newValues = new HashSet<String>(attr.size());
                for (String s : attr.getStringValues()) {
                    newValues.add(this.handleAttributeValue(conn, request, s));
                }
                attr.clear();
                attr.addStringValues(newValues);
            }
        }
    }

    protected String handleAttributeName(Connection conn, SearchRequest request, String name) {
        return name;
    }

    protected String handleAttributeValue(Connection conn, SearchRequest request, String value) {
        return value;
    }

    protected byte[] handleAttributeValue(Connection conn, SearchRequest request, byte[] value) {
        return value;
    }

    @Override
    public void initializeRequest(SearchRequest request) {
    }

    public boolean equals(Object o) {
        return super.equals(o);
    }

    public abstract int hashCode();
}

