/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.services.security.impl;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.knox.gateway.GatewayMessages;
import org.apache.knox.gateway.GatewayResources;
import org.apache.knox.gateway.config.GatewayConfig;
import org.apache.knox.gateway.i18n.messages.MessagesFactory;
import org.apache.knox.gateway.i18n.resources.ResourcesFactory;
import org.apache.knox.gateway.services.Service;
import org.apache.knox.gateway.services.ServiceLifecycleException;
import org.apache.knox.gateway.services.security.KeystoreService;
import org.apache.knox.gateway.services.security.KeystoreServiceException;
import org.apache.knox.gateway.services.security.MasterService;
import org.apache.knox.gateway.util.X509CertificateUtil;

public class DefaultKeystoreService
implements KeystoreService,
Service {
    private static final String DN_TEMPLATE = "CN={0},OU=Test,O=Hadoop,L=Test,ST=Test,C=US";
    private static final String CREDENTIALS_SUFFIX = "-credentials.jceks";
    private static final String CREDENTIALS_STORE_TYPE = "JCEKS";
    private static final String CERT_GEN_MODE = "hadoop.gateway.cert.gen.mode";
    private static final String CERT_GEN_MODE_LOCALHOST = "localhost";
    private static final String CERT_GEN_MODE_HOSTNAME = "hostname";
    private static GatewayMessages LOG = (GatewayMessages)MessagesFactory.get(GatewayMessages.class);
    private static GatewayResources RES = (GatewayResources)ResourcesFactory.get(GatewayResources.class);
    final Cache<CacheKey, String> cache = Caffeine.newBuilder().expireAfterAccess(10L, TimeUnit.MINUTES).maximumSize(1000L).build();
    private GatewayConfig config;
    private MasterService masterService;
    private Path keyStoreDirPath;

    public void setMasterService(MasterService ms) {
        this.masterService = ms;
    }

    public void init(GatewayConfig config, Map<String, String> options) throws ServiceLifecycleException {
        this.config = config;
        this.keyStoreDirPath = Paths.get(config.getGatewayKeystoreDir(), new String[0]);
        if (Files.notExists(this.keyStoreDirPath, new LinkOption[0])) {
            try {
                Files.createDirectories(this.keyStoreDirPath, new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new ServiceLifecycleException(RES.failedToCreateKeyStoreDirectory(this.keyStoreDirPath.toString()));
            }
        }
    }

    public void start() throws ServiceLifecycleException {
    }

    public void stop() throws ServiceLifecycleException {
    }

    public void createKeystoreForGateway() throws KeystoreServiceException {
        this.createKeyStore(Paths.get(this.config.getIdentityKeystorePath(), new String[0]), this.config.getIdentityKeystoreType(), this.getKeyStorePassword(this.config.getIdentityKeystorePasswordAlias()));
    }

    public KeyStore getKeystoreForGateway() throws KeystoreServiceException {
        return this.getKeystore(Paths.get(this.config.getIdentityKeystorePath(), new String[0]), this.config.getIdentityKeystoreType(), this.config.getIdentityKeystorePasswordAlias(), true);
    }

    public KeyStore getTruststoreForHttpClient() throws KeystoreServiceException {
        String trustStorePath = this.config.getHttpClientTruststorePath();
        if (trustStorePath == null) {
            return null;
        }
        return this.getKeystore(Paths.get(trustStorePath, new String[0]), this.config.getHttpClientTruststoreType(), this.config.getHttpClientTruststorePasswordAlias(), true);
    }

    public KeyStore getSigningKeystore() throws KeystoreServiceException {
        return this.getSigningKeystore(null);
    }

    public KeyStore getSigningKeystore(String keystoreName) throws KeystoreServiceException {
        String passwordAlias;
        String keyStoreType;
        Path keyStoreFile;
        if (keystoreName != null) {
            keyStoreFile = this.keyStoreDirPath.resolve(keystoreName + ".jks");
            keyStoreType = "jks";
            passwordAlias = null;
        } else {
            keyStoreFile = Paths.get(this.config.getSigningKeystorePath(), new String[0]);
            keyStoreType = this.config.getSigningKeystoreType();
            passwordAlias = this.config.getSigningKeystorePasswordAlias();
        }
        return this.getKeystore(keyStoreFile, keyStoreType, passwordAlias, true);
    }

    public void addSelfSignedCertForGateway(String alias, char[] passphrase) throws KeystoreServiceException {
        this.addSelfSignedCertForGateway(alias, passphrase, null);
    }

    public void addSelfSignedCertForGateway(String alias, char[] passphrase, String hostname) throws KeystoreServiceException {
        this.addCertForGateway(alias, passphrase, hostname);
    }

    private synchronized void addCertForGateway(String alias, char[] passphrase, String hostname) throws KeystoreServiceException {
        try {
            X509Certificate cert;
            String dn;
            KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("RSA");
            keyPairGenerator.initialize(2048);
            KeyPair KPair = keyPairGenerator.generateKeyPair();
            if (hostname == null) {
                hostname = System.getProperty(CERT_GEN_MODE, CERT_GEN_MODE_LOCALHOST);
            }
            if (hostname.equals(CERT_GEN_MODE_HOSTNAME)) {
                dn = this.buildDistinguishedName(InetAddress.getLocalHost().getHostName());
                cert = X509CertificateUtil.generateCertificate((String)dn, (KeyPair)KPair, (int)365, (String)"SHA1withRSA");
            } else {
                dn = this.buildDistinguishedName(hostname);
                cert = X509CertificateUtil.generateCertificate((String)dn, (KeyPair)KPair, (int)365, (String)"SHA1withRSA");
            }
            KeyStore privateKS = this.getKeystoreForGateway();
            privateKS.setKeyEntry(alias, KPair.getPrivate(), passphrase, new Certificate[]{cert});
            this.writeKeyStoreToFile(privateKS, Paths.get(this.config.getIdentityKeystorePath(), new String[0]), this.getKeyStorePassword(this.config.getIdentityKeystorePasswordAlias()));
        }
        catch (IOException | GeneralSecurityException e) {
            LOG.failedToAddSeflSignedCertForGateway(alias, e);
            throw new KeystoreServiceException(e);
        }
    }

    private String buildDistinguishedName(String hostname) {
        MessageFormat headerFormatter = new MessageFormat(DN_TEMPLATE, Locale.ROOT);
        String[] paramArray = new String[]{hostname};
        return headerFormatter.format(paramArray);
    }

    public void createCredentialStoreForCluster(String clusterName) throws KeystoreServiceException {
        this.createKeyStore(this.keyStoreDirPath.resolve(clusterName + CREDENTIALS_SUFFIX), CREDENTIALS_STORE_TYPE, this.masterService.getMasterSecret());
    }

    public boolean isCredentialStoreForClusterAvailable(String clusterName) throws KeystoreServiceException {
        Path keyStoreFilePath = this.keyStoreDirPath.resolve(clusterName + CREDENTIALS_SUFFIX);
        try {
            return this.isKeyStoreAvailable(keyStoreFilePath, CREDENTIALS_STORE_TYPE, this.masterService.getMasterSecret());
        }
        catch (IOException | KeyStoreException e) {
            throw new KeystoreServiceException(e);
        }
    }

    public boolean isKeystoreForGatewayAvailable() throws KeystoreServiceException {
        Path keyStoreFilePath = Paths.get(this.config.getIdentityKeystorePath(), new String[0]);
        try {
            return this.isKeyStoreAvailable(keyStoreFilePath, this.config.getIdentityKeystoreType(), this.getKeyStorePassword(this.config.getIdentityKeystorePasswordAlias()));
        }
        catch (IOException | KeyStoreException e) {
            throw new KeystoreServiceException(e);
        }
    }

    public Key getKeyForGateway(char[] passphrase) throws KeystoreServiceException {
        return this.getKeyForGateway(this.config.getIdentityKeyAlias(), passphrase);
    }

    public Key getKeyForGateway(String alias, char[] passphrase) throws KeystoreServiceException {
        return this.getKeyFromKeystore(this.getKeystoreForGateway(), alias, passphrase);
    }

    public Certificate getCertificateForGateway() throws KeystoreServiceException, KeyStoreException {
        KeyStore ks = this.getKeystoreForGateway();
        return ks == null ? null : ks.getCertificate(this.config.getIdentityKeyAlias());
    }

    public Key getSigningKey(String alias, char[] passphrase) throws KeystoreServiceException {
        return this.getSigningKey(null, alias, passphrase);
    }

    public Key getSigningKey(String keystoreName, String alias, char[] passphrase) throws KeystoreServiceException {
        return this.getKeyFromKeystore(this.getSigningKeystore(keystoreName), alias, passphrase);
    }

    private Key getKeyFromKeystore(KeyStore ks, String alias, char[] passphrase) {
        Key key = null;
        if (passphrase == null) {
            passphrase = this.masterService.getMasterSecret();
            LOG.assumingKeyPassphraseIsMaster();
        }
        if (ks != null) {
            try {
                key = ks.getKey(alias, passphrase);
            }
            catch (KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException e) {
                LOG.failedToGetKeyForGateway(alias, e);
            }
        }
        return key;
    }

    public KeyStore getCredentialStoreForCluster(String clusterName) throws KeystoreServiceException {
        return this.getKeystore(this.keyStoreDirPath.resolve(clusterName + CREDENTIALS_SUFFIX), CREDENTIALS_STORE_TYPE, null, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addCredentialForCluster(String clusterName, String alias, String value) throws KeystoreServiceException {
        DefaultKeystoreService defaultKeystoreService = this;
        synchronized (defaultKeystoreService) {
            this.removeFromCache(clusterName, alias);
            KeyStore ks = this.getCredentialStoreForCluster(clusterName);
            if (ks != null) {
                try {
                    SecretKeySpec key = new SecretKeySpec(value.getBytes(StandardCharsets.UTF_8), "AES");
                    ks.setKeyEntry(alias, key, this.masterService.getMasterSecret(), null);
                    Path keyStoreFilePath = this.keyStoreDirPath.resolve(clusterName + CREDENTIALS_SUFFIX);
                    this.writeKeyStoreToFile(ks, keyStoreFilePath, this.masterService.getMasterSecret());
                    this.addToCache(clusterName, alias, value);
                }
                catch (IOException | KeyStoreException | NoSuchAlgorithmException | CertificateException e) {
                    LOG.failedToAddCredentialForCluster(clusterName, e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public char[] getCredentialForCluster(String clusterName, String alias) throws KeystoreServiceException {
        char[] credential;
        DefaultKeystoreService defaultKeystoreService = this;
        synchronized (defaultKeystoreService) {
            KeyStore ks;
            credential = this.checkCache(clusterName, alias);
            if (credential == null && (ks = this.getCredentialStoreForCluster(clusterName)) != null) {
                try {
                    char[] masterSecret = this.masterService.getMasterSecret();
                    Key credentialKey = ks.getKey(alias, masterSecret);
                    if (credentialKey != null) {
                        byte[] credentialBytes = credentialKey.getEncoded();
                        String credentialString = new String(credentialBytes, StandardCharsets.UTF_8);
                        credential = credentialString.toCharArray();
                        this.addToCache(clusterName, alias, credentialString);
                    }
                }
                catch (KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException e) {
                    LOG.failedToGetCredentialForCluster(clusterName, e);
                }
            }
        }
        return credential;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeCredentialForCluster(String clusterName, String alias) throws KeystoreServiceException {
        DefaultKeystoreService defaultKeystoreService = this;
        synchronized (defaultKeystoreService) {
            KeyStore ks = this.getCredentialStoreForCluster(clusterName);
            if (ks != null) {
                try {
                    if (ks.containsAlias(alias)) {
                        ks.deleteEntry(alias);
                    }
                    Path keyStoreFilePath = this.keyStoreDirPath.resolve(clusterName + CREDENTIALS_SUFFIX);
                    this.writeKeyStoreToFile(ks, keyStoreFilePath, this.masterService.getMasterSecret());
                    this.removeFromCache(clusterName, alias);
                }
                catch (IOException | KeyStoreException | NoSuchAlgorithmException | CertificateException e) {
                    LOG.failedToRemoveCredentialForCluster(clusterName, e);
                }
            }
        }
    }

    private char[] checkCache(String clusterName, String alias) {
        String cachedCredential = (String)this.cache.getIfPresent((Object)CacheKey.of(clusterName, alias));
        return cachedCredential == null ? null : cachedCredential.toCharArray();
    }

    private void addToCache(String clusterName, String alias, String credentialString) {
        this.cache.put((Object)CacheKey.of(clusterName, alias), (Object)credentialString);
    }

    private void removeFromCache(String clusterName, String alias) {
        this.cache.invalidate((Object)CacheKey.of(clusterName, alias));
    }

    public String getKeystorePath() {
        return this.config.getIdentityKeystorePath();
    }

    private synchronized KeyStore getKeystore(Path keystorePath, String keystoreType, String alias, boolean failIfNotAccessible) throws KeystoreServiceException {
        if (failIfNotAccessible) {
            if (Files.notExists(keystorePath, new LinkOption[0])) {
                LOG.keystoreFileDoesNotExist(keystorePath.toString());
                throw new KeystoreServiceException("The keystore file does not exist: " + keystorePath.toString());
            }
            if (!Files.isRegularFile(keystorePath, new LinkOption[0])) {
                LOG.keystoreFileIsNotAFile(keystorePath.toString());
                throw new KeystoreServiceException("The keystore file is not a file: " + keystorePath.toString());
            }
            if (!Files.isReadable(keystorePath)) {
                LOG.keystoreFileIsNotAccessible(keystorePath.toString());
                throw new KeystoreServiceException("The keystore file cannot be read: " + keystorePath.toString());
            }
        }
        return this.loadKeyStore(keystorePath, keystoreType, this.getKeyStorePassword(alias));
    }

    private synchronized boolean isKeyStoreAvailable(Path keyStoreFilePath, String storeType, char[] password) throws KeyStoreException, IOException {
        block11: {
            if (Files.exists(keyStoreFilePath, new LinkOption[0]) && Files.isRegularFile(keyStoreFilePath, new LinkOption[0]) && Files.isReadable(keyStoreFilePath)) {
                boolean bl;
                block10: {
                    InputStream input = Files.newInputStream(keyStoreFilePath, new OpenOption[0]);
                    Throwable throwable = null;
                    try {
                        KeyStore keyStore = KeyStore.getInstance(storeType);
                        keyStore.load(input, password);
                        bl = true;
                        if (input == null) break block10;
                    }
                    catch (Throwable throwable2) {
                        try {
                            try {
                                throwable = throwable2;
                                throw throwable2;
                            }
                            catch (Throwable throwable3) {
                                if (input != null) {
                                    DefaultKeystoreService.$closeResource(throwable, input);
                                }
                                throw throwable3;
                            }
                        }
                        catch (NoSuchAlgorithmException | CertificateException e) {
                            LOG.failedToLoadKeystore(keyStoreFilePath.toString(), storeType, e);
                            break block11;
                        }
                        catch (IOException | KeyStoreException e) {
                            LOG.failedToLoadKeystore(keyStoreFilePath.toString(), storeType, e);
                            throw e;
                        }
                    }
                    DefaultKeystoreService.$closeResource(throwable, input);
                }
                return bl;
            }
        }
        return false;
    }

    synchronized KeyStore createKeyStore(Path keystoreFilePath, String keystoreType, char[] password) throws KeystoreServiceException {
        if (Files.notExists(keystoreFilePath, new LinkOption[0])) {
            try {
                Files.createDirectories(keystoreFilePath.getParent(), new FileAttribute[0]);
            }
            catch (IOException e) {
                LOG.failedToCreateKeystore(keystoreFilePath.toString(), keystoreType, e);
                throw new KeystoreServiceException((Exception)e);
            }
        }
        try {
            KeyStore ks = KeyStore.getInstance(keystoreType);
            ks.load(null, null);
            this.writeKeyStoreToFile(ks, keystoreFilePath, password);
            return ks;
        }
        catch (IOException | KeyStoreException | NoSuchAlgorithmException | CertificateException e) {
            LOG.failedToCreateKeystore(keystoreFilePath.toString(), keystoreType, e);
            throw new KeystoreServiceException(e);
        }
    }

    synchronized KeyStore loadKeyStore(Path keyStoreFilePath, String storeType, char[] password) throws KeystoreServiceException {
        try {
            KeyStore keyStore;
            block15: {
                keyStore = KeyStore.getInstance(storeType);
                if (Files.exists(keyStoreFilePath, new LinkOption[0])) {
                    try (FileChannel fileChannel = FileChannel.open(keyStoreFilePath, StandardOpenOption.READ);){
                        fileChannel.lock(0L, Long.MAX_VALUE, true);
                        try (InputStream input = Channels.newInputStream(fileChannel);){
                            keyStore.load(input, password);
                            break block15;
                        }
                    }
                }
                keyStore.load(null, password);
            }
            return keyStore;
        }
        catch (IOException | KeyStoreException | NoSuchAlgorithmException | CertificateException e) {
            LOG.failedToLoadKeystore(keyStoreFilePath.toString(), storeType, e);
            throw new KeystoreServiceException(e);
        }
    }

    synchronized void writeKeyStoreToFile(KeyStore keyStore, Path path, char[] password) throws KeyStoreException, IOException, NoSuchAlgorithmException, CertificateException {
        try (FileChannel fileChannel = FileChannel.open(path, StandardOpenOption.WRITE, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);){
            fileChannel.lock();
            try (OutputStream out = Channels.newOutputStream(fileChannel);){
                keyStore.store(out, password);
            }
        }
    }

    private char[] getKeyStorePassword(String alias) throws KeystoreServiceException {
        char[] password = null;
        if (alias != null && !alias.isEmpty()) {
            password = this.getCredentialForCluster("__gateway", alias);
        }
        return password == null ? this.masterService.getMasterSecret() : password;
    }

    private static class CacheKey {
        private final String clusterName;
        private final String alias;

        private CacheKey(String clusterName, String alias) {
            this.clusterName = clusterName;
            this.alias = alias;
        }

        private static CacheKey of(String clusterName, String alias) {
            return new CacheKey(clusterName, alias);
        }

        public int hashCode() {
            return HashCodeBuilder.reflectionHashCode((Object)this, (String[])new String[0]);
        }

        public boolean equals(Object obj) {
            return EqualsBuilder.reflectionEquals((Object)this, (Object)obj, (String[])new String[0]);
        }
    }
}

