/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.topology.discovery.advanced;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.filefilter.PrefixFileFilter;
import org.apache.commons.lang3.concurrent.BasicThreadFactory;
import org.apache.knox.gateway.config.GatewayConfig;
import org.apache.knox.gateway.i18n.messages.MessagesFactory;
import org.apache.knox.gateway.topology.discovery.advanced.AdvanceServiceDiscoveryConfigurationMessages;
import org.apache.knox.gateway.topology.discovery.advanced.AdvancedServiceDiscoveryConfigChangeListener;

public class AdvancedServiceDiscoveryConfigurationMonitor {
    private static final String ADVANCED_CONFIGURATION_FILE_NAME_PREFIX = "auto-discovery-advanced-configuration-";
    private static final AdvanceServiceDiscoveryConfigurationMessages LOG = (AdvanceServiceDiscoveryConfigurationMessages)MessagesFactory.get(AdvanceServiceDiscoveryConfigurationMessages.class);
    private final List<AdvancedServiceDiscoveryConfigChangeListener> listeners;
    private final String gatewayConfigurationDir;
    private final long monitoringInterval;
    private final Map<Path, FileTime> lastReloadTimes;

    public AdvancedServiceDiscoveryConfigurationMonitor(GatewayConfig gatewayConfig) {
        this.gatewayConfigurationDir = gatewayConfig.getGatewayConfDir();
        this.monitoringInterval = gatewayConfig.getClouderaManagerAdvancedServiceDiscoveryConfigurationMonitoringInterval();
        this.listeners = new ArrayList<AdvancedServiceDiscoveryConfigChangeListener>();
        this.lastReloadTimes = new ConcurrentHashMap<Path, FileTime>();
    }

    public void init() {
        this.monitorAdvancedServiceConfigurations();
        this.setupMonitor();
    }

    private void setupMonitor() {
        if (this.monitoringInterval > 0L) {
            ScheduledExecutorService executorService = Executors.newSingleThreadScheduledExecutor((ThreadFactory)new BasicThreadFactory.Builder().namingPattern("AdvancedServiceDiscoveryConfigurationMonitor-%d").build());
            executorService.scheduleAtFixedRate(() -> this.monitorAdvancedServiceConfigurations(), 0L, this.monitoringInterval, TimeUnit.MILLISECONDS);
            LOG.monitorStarted(this.gatewayConfigurationDir, ADVANCED_CONFIGURATION_FILE_NAME_PREFIX);
        } else {
            LOG.disableMonitoring();
        }
    }

    public void registerListener(AdvancedServiceDiscoveryConfigChangeListener listener) {
        this.listeners.add(listener);
    }

    private void monitorAdvancedServiceConfigurations() {
        File[] advancedConfigurationFiles = new File(this.gatewayConfigurationDir).listFiles((FileFilter)new PrefixFileFilter(ADVANCED_CONFIGURATION_FILE_NAME_PREFIX));
        if (advancedConfigurationFiles != null) {
            for (File advancedConfigurationFile : advancedConfigurationFiles) {
                this.monitorAdvancedServiceConfiguration(Paths.get(advancedConfigurationFile.getAbsolutePath(), new String[0]));
            }
        }
    }

    private void monitorAdvancedServiceConfiguration(Path resourcePath) {
        block14: {
            try {
                if (!Files.exists(resourcePath, new LinkOption[0]) || !Files.isReadable(resourcePath)) break block14;
                FileTime lastModifiedTime = Files.getLastModifiedTime(resourcePath, new LinkOption[0]);
                FileTime lastReloadTime = this.lastReloadTimes.get(resourcePath);
                if (lastReloadTime != null && lastReloadTime.compareTo(lastModifiedTime) >= 0) break block14;
                this.lastReloadTimes.put(resourcePath, lastModifiedTime);
                try (InputStream advanceconfigurationFileInputStream = Files.newInputStream(resourcePath, new OpenOption[0]);){
                    Properties properties = new Properties();
                    properties.load(advanceconfigurationFileInputStream);
                    this.notifyListeners(resourcePath.toString(), properties);
                }
            }
            catch (IOException e) {
                LOG.failedToMonitorClouderaManagerAdvancedConfiguration(e.getMessage(), e);
            }
        }
    }

    private void notifyListeners(String path, Properties properties) {
        LOG.notifyListeners(path);
        this.listeners.forEach(listener -> listener.onAdvancedServiceDiscoveryConfigurationChange(properties));
    }
}

