/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.schemaframework;

import java.io.IOException;
import java.io.Writer;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.databaseaccess.FieldTypeDefinition;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.tools.schemaframework.DatabaseObjectDefinition;

public class VarrayDefinition
extends DatabaseObjectDefinition {
    protected int typeSize;
    protected int size;
    protected Class type;
    protected String typeName;

    public void appendTypeString(Writer writer, AbstractSession session) throws ValidationException {
        try {
            FieldTypeDefinition fieldType = VarrayDefinition.getFieldTypeDefinition(session, this.type, this.typeName);
            writer.write(fieldType.getName());
            if (fieldType.isSizeAllowed() && (this.typeSize != 0 || fieldType.isSizeRequired())) {
                writer.write("(");
                if (this.typeSize == 0) {
                    writer.write(Integer.toString(fieldType.getDefaultSize()));
                } else {
                    writer.write(Integer.toString(this.typeSize));
                }
                writer.write(")");
            }
        }
        catch (IOException ioException) {
            throw ValidationException.fileError(ioException);
        }
    }

    @Override
    public Writer buildCreationWriter(AbstractSession session, Writer writer) throws ValidationException {
        try {
            writer.write("CREATE TYPE ");
            writer.write(this.getFullName());
            writer.write(" AS VARRAY(");
            if (this.size < 1) {
                throw ValidationException.oracleVarrayMaximumSizeNotDefined(this.getFullName());
            }
            writer.write(Integer.toString(this.size));
            writer.write(") OF ");
            this.appendTypeString(writer, session);
        }
        catch (IOException ioException) {
            throw ValidationException.fileError(ioException);
        }
        return writer;
    }

    @Override
    public Writer buildDeletionWriter(AbstractSession session, Writer writer) throws ValidationException {
        try {
            writer.write("DROP TYPE ");
            writer.write(this.getFullName());
        }
        catch (IOException ioException) {
            throw ValidationException.fileError(ioException);
        }
        return writer;
    }

    public int getSize() {
        return this.size;
    }

    public Class getType() {
        return this.type;
    }

    public String getTypeName() {
        return this.typeName;
    }

    public int getTypeSize() {
        return this.typeSize;
    }

    public void setSize(int size) {
        this.size = size;
    }

    public void setType(Class type) {
        this.type = type;
    }

    public void setTypeName(String typeName) {
        this.typeName = typeName;
    }

    public void setTypeSize(int typeSize) {
        this.typeSize = typeSize;
    }
}

