/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.j2e.filter;

import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.pac4j.core.config.Config;
import org.pac4j.core.context.J2EContext;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.engine.CallbackLogic;
import org.pac4j.core.engine.DefaultCallbackLogic;
import org.pac4j.core.http.adapter.HttpActionAdapter;
import org.pac4j.core.http.adapter.J2ENopHttpActionAdapter;
import org.pac4j.core.util.CommonHelper;
import org.pac4j.j2e.filter.AbstractConfigFilter;

public class CallbackFilter
extends AbstractConfigFilter {
    private CallbackLogic<Object, J2EContext> callbackLogic = new DefaultCallbackLogic();
    private String defaultUrl;
    private Boolean saveInSession;
    private Boolean multiProfile;
    private Boolean renewSession;
    private String defaultClient;

    public CallbackFilter() {
    }

    public CallbackFilter(Config config) {
        this.setConfig(config);
    }

    public CallbackFilter(Config config, String defaultUrl) {
        this(config);
        this.defaultUrl = defaultUrl;
    }

    @Override
    public void init(FilterConfig filterConfig) throws ServletException {
        super.init(filterConfig);
        this.defaultUrl = this.getStringParam(filterConfig, "defaultUrl", this.defaultUrl);
        this.saveInSession = this.getBooleanParam(filterConfig, "saveInSession", this.saveInSession);
        this.multiProfile = this.getBooleanParam(filterConfig, "multiProfile", this.multiProfile);
        this.renewSession = this.getBooleanParam(filterConfig, "renewSession", this.renewSession);
        this.defaultClient = this.getStringParam(filterConfig, "defaultClient", this.defaultClient);
        this.checkForbiddenParameter(filterConfig, "clientsFactory");
    }

    @Override
    protected void internalFilter(HttpServletRequest request, HttpServletResponse response, FilterChain chain) throws IOException, ServletException {
        CommonHelper.assertNotNull((String)"callbackLogic", this.callbackLogic);
        Config config = this.getConfig();
        CommonHelper.assertNotNull((String)"config", (Object)config);
        J2EContext context = new J2EContext(request, response, config.getSessionStore());
        this.callbackLogic.perform((WebContext)context, config, (HttpActionAdapter)J2ENopHttpActionAdapter.INSTANCE, this.defaultUrl, this.saveInSession, this.multiProfile, this.renewSession, this.defaultClient);
    }

    public String getDefaultUrl() {
        return this.defaultUrl;
    }

    public void setDefaultUrl(String defaultUrl) {
        this.defaultUrl = defaultUrl;
    }

    public Boolean getSaveInSession() {
        return this.saveInSession;
    }

    public void setSaveInSession(Boolean saveInSession) {
        this.saveInSession = saveInSession;
    }

    public Boolean getMultiProfile() {
        return this.multiProfile;
    }

    public void setMultiProfile(Boolean multiProfile) {
        this.multiProfile = multiProfile;
    }

    public Boolean getRenewSession() {
        return this.renewSession;
    }

    public void setRenewSession(Boolean renewSession) {
        this.renewSession = renewSession;
    }

    public CallbackLogic<Object, J2EContext> getCallbackLogic() {
        return this.callbackLogic;
    }

    public void setCallbackLogic(CallbackLogic<Object, J2EContext> callbackLogic) {
        this.callbackLogic = callbackLogic;
    }

    public String getDefaultClient() {
        return this.defaultClient;
    }

    public void setDefaultClient(String defaultClient) {
        this.defaultClient = defaultClient;
    }
}

