/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.client.session;

import java.io.IOException;
import java.net.SocketAddress;
import java.security.KeyPair;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.sshd.ClientChannel;
import org.apache.sshd.ClientSession;
import org.apache.sshd.client.ClientFactoryManager;
import org.apache.sshd.client.ScpClient;
import org.apache.sshd.client.ServerKeyVerifier;
import org.apache.sshd.client.SftpClient;
import org.apache.sshd.client.UserInteraction;
import org.apache.sshd.client.auth.deprecated.UserAuth;
import org.apache.sshd.client.auth.deprecated.UserAuthAgent;
import org.apache.sshd.client.auth.deprecated.UserAuthKeyboardInteractive;
import org.apache.sshd.client.auth.deprecated.UserAuthPassword;
import org.apache.sshd.client.auth.deprecated.UserAuthPublicKey;
import org.apache.sshd.client.channel.ChannelDirectTcpip;
import org.apache.sshd.client.channel.ChannelExec;
import org.apache.sshd.client.channel.ChannelShell;
import org.apache.sshd.client.channel.ChannelSubsystem;
import org.apache.sshd.client.future.AuthFuture;
import org.apache.sshd.client.future.DefaultAuthFuture;
import org.apache.sshd.client.scp.DefaultScpClient;
import org.apache.sshd.client.session.ClientUserAuthService;
import org.apache.sshd.client.sftp.DefaultSftpClient;
import org.apache.sshd.common.NamedFactory;
import org.apache.sshd.common.Service;
import org.apache.sshd.common.ServiceFactory;
import org.apache.sshd.common.SessionListener;
import org.apache.sshd.common.SshException;
import org.apache.sshd.common.SshdSocketAddress;
import org.apache.sshd.common.cipher.CipherNone;
import org.apache.sshd.common.future.DefaultSshFuture;
import org.apache.sshd.common.future.SshFuture;
import org.apache.sshd.common.io.IoSession;
import org.apache.sshd.common.session.AbstractConnectionService;
import org.apache.sshd.common.session.AbstractSession;
import org.apache.sshd.common.session.ConnectionService;
import org.apache.sshd.common.util.Buffer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClientSessionImpl
extends AbstractSession
implements ClientSession {
    private Map<Object, Object> metadataMap = new HashMap<Object, Object>();
    private boolean initialServiceRequestSent;
    private ServiceFactory currentServiceFactory;
    private Service nextService;
    private ServiceFactory nextServiceFactory;
    private final List<Object> identities = new ArrayList<Object>();
    private UserInteraction userInteraction;
    protected AuthFuture authFuture;

    public ClientSessionImpl(ClientFactoryManager client, IoSession session) throws Exception {
        super(false, client, session);
        this.log.info("Client session created");
        List<ServiceFactory> factories = client.getServiceFactories();
        if (factories == null || factories.isEmpty() || factories.size() > 2) {
            throw new IllegalArgumentException("One or two services must be configured");
        }
        this.currentServiceFactory = factories.get(0);
        this.currentService = this.currentServiceFactory.create(this);
        if (factories.size() > 1) {
            this.nextServiceFactory = factories.get(1);
            this.nextService = this.nextServiceFactory.create(this);
        } else {
            this.nextServiceFactory = null;
        }
        this.authFuture = new DefaultAuthFuture(this.lock);
        this.authFuture.setAuthed(false);
        this.sendClientIdentification();
        this.kexState.set(1);
        this.sendKexInit();
    }

    @Override
    protected Service[] getServices() {
        Service[] services = this.nextService != null ? new Service[]{this.currentService, this.nextService} : (this.currentService != null ? new Service[]{this.currentService} : new Service[]{});
        return services;
    }

    @Override
    public ClientFactoryManager getFactoryManager() {
        return (ClientFactoryManager)this.factoryManager;
    }

    @Override
    public void addPasswordIdentity(String password) {
        this.identities.add(password);
    }

    @Override
    public void addPublicKeyIdentity(KeyPair key) {
        this.identities.add(key);
    }

    @Override
    public UserInteraction getUserInteraction() {
        return this.userInteraction;
    }

    @Override
    public void setUserInteraction(UserInteraction userInteraction) {
        this.userInteraction = userInteraction;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AuthFuture auth() throws IOException {
        if (this.username == null) {
            throw new IllegalStateException("No username specified when the session was created");
        }
        Object object = this.lock;
        synchronized (object) {
            this.authFuture = this.getUserAuthService().auth(this.identities, this.nextServiceName());
            return this.authFuture;
        }
    }

    @Override
    public AuthFuture authAgent(String user) throws IOException {
        return this.tryAuth(user, new UserAuthAgent(this, this.nextServiceName()));
    }

    @Override
    public AuthFuture authPassword(String user, String password) throws IOException {
        return this.tryAuth(user, new UserAuthPassword(this, this.nextServiceName(), password));
    }

    @Override
    public AuthFuture authInteractive(String user, String password) throws IOException {
        return this.tryAuth(user, new UserAuthKeyboardInteractive(this, this.nextServiceName(), password));
    }

    @Override
    public AuthFuture authPublicKey(String user, KeyPair key) throws IOException {
        return this.tryAuth(user, new UserAuthPublicKey(this, this.nextServiceName(), key));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AuthFuture tryAuth(String user, UserAuth auth) throws IOException {
        this.username = user;
        Object object = this.lock;
        synchronized (object) {
            this.authFuture = this.getUserAuthService().auth(auth);
            return this.authFuture;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String nextServiceName() {
        Object object = this.lock;
        synchronized (object) {
            return this.nextServiceFactory.getName();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void switchToNextService() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.nextService == null) {
                throw new IllegalStateException("No service available");
            }
            this.currentServiceFactory = this.nextServiceFactory;
            this.currentService = this.nextService;
            this.nextServiceFactory = null;
            this.nextService = null;
            this.currentService.start();
        }
    }

    @Override
    public SshFuture switchToNoneCipher() throws IOException {
        if (!(this.currentService instanceof AbstractConnectionService) || !((AbstractConnectionService)this.currentService).getChannels().isEmpty()) {
            throw new IllegalStateException("The switch to the none cipher must be done immediately after authentication");
        }
        if (this.kexState.compareAndSet(4, 1)) {
            this.reexchangeFuture = new DefaultSshFuture(null);
            if (!this.serverProposal[2].matches("(^|.*,)none($|,.*)") || !this.serverProposal[3].matches("(^|.*,)none($|,.*)")) {
                this.reexchangeFuture.setValue(new SshException("Server does not support none cipher"));
            } else if (!this.clientProposal[2].matches("(^|.*,)none($|,.*)") || !this.clientProposal[3].matches("(^|.*,)none($|,.*)")) {
                this.reexchangeFuture.setValue(new SshException("Client does not support none cipher"));
            } else {
                this.log.info("Switching to none cipher");
                this.clientProposal[2] = "none";
                this.clientProposal[3] = "none";
                this.I_C = this.sendKexInit(this.clientProposal);
            }
            return this.reexchangeFuture;
        }
        throw new SshException("In flight key exchange");
    }

    @Override
    public ClientChannel createChannel(String type) throws IOException {
        return this.createChannel(type, null);
    }

    @Override
    public ClientChannel createChannel(String type, String subType) throws IOException {
        if ("shell".equals(type)) {
            return this.createShellChannel();
        }
        if ("exec".equals(type)) {
            return this.createExecChannel(subType);
        }
        if ("subsystem".equals(type)) {
            return this.createSubsystemChannel(subType);
        }
        throw new IllegalArgumentException("Unsupported channel type " + type);
    }

    @Override
    public ChannelShell createShellChannel() throws IOException {
        if (this.inCipher instanceof CipherNone || this.outCipher instanceof CipherNone) {
            throw new IllegalStateException("Interactive channels are not supported with none cipher");
        }
        ChannelShell channel = new ChannelShell();
        this.getConnectionService().registerChannel(channel);
        return channel;
    }

    @Override
    public ChannelExec createExecChannel(String command) throws IOException {
        ChannelExec channel = new ChannelExec(command);
        this.getConnectionService().registerChannel(channel);
        return channel;
    }

    @Override
    public ChannelSubsystem createSubsystemChannel(String subsystem) throws IOException {
        ChannelSubsystem channel = new ChannelSubsystem(subsystem);
        this.getConnectionService().registerChannel(channel);
        return channel;
    }

    @Override
    public ChannelDirectTcpip createDirectTcpipChannel(SshdSocketAddress local, SshdSocketAddress remote) throws IOException {
        ChannelDirectTcpip channel = new ChannelDirectTcpip(local, remote);
        this.getConnectionService().registerChannel(channel);
        return channel;
    }

    private ClientUserAuthService getUserAuthService() {
        return this.getService(ClientUserAuthService.class);
    }

    private ConnectionService getConnectionService() {
        return this.getService(ConnectionService.class);
    }

    @Override
    public ScpClient createScpClient() {
        return new DefaultScpClient(this);
    }

    @Override
    public SftpClient createSftpClient() throws IOException {
        return new DefaultSftpClient(this);
    }

    @Override
    public SshdSocketAddress startLocalPortForwarding(SshdSocketAddress local, SshdSocketAddress remote) throws IOException {
        return this.getConnectionService().getTcpipForwarder().startLocalPortForwarding(local, remote);
    }

    @Override
    public void stopLocalPortForwarding(SshdSocketAddress local) throws IOException {
        this.getConnectionService().getTcpipForwarder().stopLocalPortForwarding(local);
    }

    @Override
    public SshdSocketAddress startRemotePortForwarding(SshdSocketAddress remote, SshdSocketAddress local) throws IOException {
        return this.getConnectionService().getTcpipForwarder().startRemotePortForwarding(remote, local);
    }

    @Override
    public void stopRemotePortForwarding(SshdSocketAddress remote) throws IOException {
        this.getConnectionService().getTcpipForwarder().stopRemotePortForwarding(remote);
    }

    @Override
    public SshdSocketAddress startDynamicPortForwarding(SshdSocketAddress local) throws IOException {
        return this.getConnectionService().getTcpipForwarder().startDynamicPortForwarding(local);
    }

    @Override
    public void stopDynamicPortForwarding(SshdSocketAddress local) throws IOException {
        this.getConnectionService().getTcpipForwarder().stopDynamicPortForwarding(local);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void handleMessage(Buffer buffer) throws Exception {
        Object object = this.lock;
        synchronized (object) {
            super.handleMessage(buffer);
        }
    }

    @Override
    public int waitFor(int mask, long timeout) {
        long t = 0L;
        Object object = this.lock;
        synchronized (object) {
            block5: while (true) {
                while (true) {
                    int cond = 0;
                    if (this.closeFuture.isClosed()) {
                        cond |= 2;
                    }
                    if (this.authed) {
                        cond |= 8;
                    }
                    if (this.kexState.get() == 4 && this.authFuture.isFailure()) {
                        cond |= 4;
                    }
                    if ((cond & mask) != 0) {
                        return cond;
                    }
                    if (timeout > 0L) {
                        if (t == 0L) {
                            t = System.currentTimeMillis() + timeout;
                        } else {
                            timeout = t - System.currentTimeMillis();
                            if (timeout <= 0L) {
                                return cond |= 1;
                            }
                        }
                    }
                    try {
                        if (timeout > 0L) {
                            this.lock.wait(timeout);
                            continue block5;
                        }
                        this.lock.wait();
                        continue block5;
                    }
                    catch (InterruptedException e) {
                        continue;
                    }
                    break;
                }
            }
        }
    }

    @Override
    protected boolean readIdentification(Buffer buffer) throws IOException {
        this.serverVersion = this.doReadIdentification(buffer, false);
        if (this.serverVersion == null) {
            return false;
        }
        this.log.info("Server version string: {}", (Object)this.serverVersion);
        if (!this.serverVersion.startsWith("SSH-2.0-") && !this.serverVersion.startsWith("SSH-1.99-")) {
            throw new SshException(8, "Unsupported protocol version: " + this.serverVersion);
        }
        return true;
    }

    private void sendClientIdentification() {
        this.clientVersion = "SSH-2.0-" + this.getFactoryManager().getVersion();
        this.sendIdentification(this.clientVersion);
    }

    @Override
    protected void sendKexInit() throws IOException {
        String algs = NamedFactory.Utils.getNames(this.getFactoryManager().getSignatureFactories());
        this.clientProposal = this.createProposal(algs);
        this.I_C = this.sendKexInit(this.clientProposal);
    }

    @Override
    protected void receiveKexInit(Buffer buffer) throws IOException {
        this.serverProposal = new String[10];
        this.I_S = this.receiveKexInit(buffer, this.serverProposal);
    }

    @Override
    protected void checkKeys() throws SshException {
        SocketAddress remoteAddress;
        ServerKeyVerifier serverKeyVerifier = this.getFactoryManager().getServerKeyVerifier();
        if (!serverKeyVerifier.verifyServerKey(this, remoteAddress = this.ioSession.getRemoteAddress(), this.kex.getServerKey())) {
            throw new SshException("Server key did not validate");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void sendEvent(SessionListener.Event event) throws IOException {
        if (event == SessionListener.Event.KeyEstablished) {
            this.sendInitialServiceRequest();
        }
        Object object = this.lock;
        synchronized (object) {
            this.lock.notifyAll();
        }
        super.sendEvent(event);
    }

    protected void sendInitialServiceRequest() throws IOException {
        if (this.initialServiceRequestSent) {
            return;
        }
        this.initialServiceRequestSent = true;
        this.log.debug("Send SSH_MSG_SERVICE_REQUEST for {}", (Object)this.currentServiceFactory.getName());
        Buffer request = this.createBuffer((byte)5);
        request.putString(this.currentServiceFactory.getName());
        this.writePacket(request);
        this.currentService.start();
    }

    @Override
    public void startService(String name) throws Exception {
        throw new IllegalStateException("Starting services is not supported on the client side");
    }

    @Override
    public Map<Object, Object> getMetadataMap() {
        return this.metadataMap;
    }
}

