/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.storage.internals.log;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.concurrent.ConcurrentNavigableMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.storage.internals.log.LogSegment;

public class LogSegments
implements Closeable {
    private final TopicPartition topicPartition;
    private final ConcurrentNavigableMap<Long, LogSegment> segments = new ConcurrentSkipListMap<Long, LogSegment>();

    public LogSegments(TopicPartition topicPartition) {
        this.topicPartition = topicPartition;
    }

    public boolean isEmpty() {
        return this.segments.isEmpty();
    }

    public boolean nonEmpty() {
        return !this.isEmpty();
    }

    public LogSegment add(LogSegment segment) {
        return this.segments.put(segment.baseOffset(), segment);
    }

    public void remove(long offset) {
        this.segments.remove(offset);
    }

    public void clear() {
        this.segments.clear();
    }

    @Override
    public void close() throws IOException {
        Utils.closeAll((Closeable[])this.values().toArray(new LogSegment[0]));
    }

    public void closeHandlers() {
        for (LogSegment s : this.values()) {
            s.closeHandlers();
        }
    }

    public void updateParentDir(File dir) {
        for (LogSegment s : this.values()) {
            s.updateParentDir(dir);
        }
    }

    public int numberOfSegments() {
        return this.segments.size();
    }

    public Collection<Long> baseOffsets() {
        return this.values().stream().map(LogSegment::baseOffset).collect(Collectors.toList());
    }

    public boolean contains(long offset) {
        return this.segments.containsKey(offset);
    }

    public Optional<LogSegment> get(long offset) {
        return Optional.ofNullable((LogSegment)this.segments.get(offset));
    }

    public Collection<LogSegment> values() {
        return this.segments.values();
    }

    public Collection<LogSegment> values(long from, long to) {
        if (from == to) {
            return Collections.emptyList();
        }
        if (to < from) {
            throw new IllegalArgumentException("Invalid log segment range: requested segments in " + String.valueOf(this.topicPartition) + " from offset " + from + " which is greater than limit offset " + to);
        }
        Long floor = this.segments.floorKey(from);
        if (floor != null) {
            return this.segments.subMap((Object)floor, (Object)to).values();
        }
        return this.segments.headMap((Object)to).values();
    }

    public Collection<LogSegment> nonActiveLogSegmentsFrom(long from) {
        LogSegment activeSegment = this.lastSegment().get();
        if (from > activeSegment.baseOffset()) {
            return Collections.emptyList();
        }
        return this.values(from, activeSegment.baseOffset());
    }

    private Optional<Map.Entry<Long, LogSegment>> floorEntry(long offset) {
        return Optional.ofNullable(this.segments.floorEntry(offset));
    }

    public Optional<LogSegment> floorSegment(long offset) {
        return this.floorEntry(offset).map(Map.Entry::getValue);
    }

    private Optional<Map.Entry<Long, LogSegment>> lowerEntry(long offset) {
        return Optional.ofNullable(this.segments.lowerEntry(offset));
    }

    public Optional<LogSegment> lowerSegment(long offset) {
        return this.lowerEntry(offset).map(Map.Entry::getValue);
    }

    public Optional<Map.Entry<Long, LogSegment>> higherEntry(long offset) {
        return Optional.ofNullable(this.segments.higherEntry(offset));
    }

    public Optional<LogSegment> higherSegment(long offset) {
        return this.higherEntry(offset).map(Map.Entry::getValue);
    }

    public Optional<Map.Entry<Long, LogSegment>> firstEntry() {
        return Optional.ofNullable(this.segments.firstEntry());
    }

    public Optional<LogSegment> firstSegment() {
        return this.firstEntry().map(Map.Entry::getValue);
    }

    public OptionalLong firstSegmentBaseOffset() {
        return this.firstSegment().map(logSegment -> OptionalLong.of(logSegment.baseOffset())).orElseGet(OptionalLong::empty);
    }

    public Optional<Map.Entry<Long, LogSegment>> lastEntry() {
        return Optional.ofNullable(this.segments.lastEntry());
    }

    public Optional<LogSegment> lastSegment() {
        return this.lastEntry().map(Map.Entry::getValue);
    }

    public Collection<LogSegment> higherSegments(long baseOffset) {
        Long higherOffset = this.segments.higherKey(baseOffset);
        if (higherOffset != null) {
            return this.segments.tailMap((Object)higherOffset, true).values();
        }
        return Collections.emptyList();
    }

    public LogSegment activeSegment() {
        return this.lastSegment().get();
    }

    public long sizeInBytes() {
        return LogSegments.sizeInBytes(this.values());
    }

    public Collection<LogSegment> filter(Predicate<LogSegment> predicate) {
        return this.values().stream().filter(predicate).collect(Collectors.toList());
    }

    public static long sizeInBytes(Collection<LogSegment> segments) {
        return segments.stream().mapToLong(LogSegment::size).sum();
    }
}

