/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.coordinator.share;

import java.util.stream.Collectors;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.coordinator.common.runtime.CoordinatorRecord;
import org.apache.kafka.coordinator.share.ShareGroupOffset;
import org.apache.kafka.coordinator.share.generated.ShareSnapshotKey;
import org.apache.kafka.coordinator.share.generated.ShareSnapshotValue;
import org.apache.kafka.coordinator.share.generated.ShareUpdateKey;
import org.apache.kafka.coordinator.share.generated.ShareUpdateValue;
import org.apache.kafka.server.common.ApiMessageAndVersion;

public class ShareCoordinatorRecordHelpers {
    public static CoordinatorRecord newShareSnapshotRecord(String groupId, Uuid topicId, int partitionId, ShareGroupOffset offsetData) {
        return new CoordinatorRecord(new ApiMessageAndVersion((ApiMessage)new ShareSnapshotKey().setGroupId(groupId).setTopicId(topicId).setPartition(partitionId), 0), new ApiMessageAndVersion((ApiMessage)new ShareSnapshotValue().setSnapshotEpoch(offsetData.snapshotEpoch()).setStateEpoch(offsetData.stateEpoch()).setLeaderEpoch(offsetData.leaderEpoch()).setStartOffset(offsetData.startOffset()).setStateBatches(offsetData.stateBatches().stream().map(batch -> new ShareSnapshotValue.StateBatch().setFirstOffset(batch.firstOffset()).setLastOffset(batch.lastOffset()).setDeliveryCount(batch.deliveryCount()).setDeliveryState(batch.deliveryState())).collect(Collectors.toList())), 0));
    }

    public static CoordinatorRecord newShareSnapshotUpdateRecord(String groupId, Uuid topicId, int partitionId, ShareGroupOffset offsetData) {
        return new CoordinatorRecord(new ApiMessageAndVersion((ApiMessage)new ShareUpdateKey().setGroupId(groupId).setTopicId(topicId).setPartition(partitionId), 1), new ApiMessageAndVersion((ApiMessage)new ShareUpdateValue().setSnapshotEpoch(offsetData.snapshotEpoch()).setLeaderEpoch(offsetData.leaderEpoch()).setStartOffset(offsetData.startOffset()).setStateBatches(offsetData.stateBatches().stream().map(batch -> new ShareUpdateValue.StateBatch().setFirstOffset(batch.firstOffset()).setLastOffset(batch.lastOffset()).setDeliveryCount(batch.deliveryCount()).setDeliveryState(batch.deliveryState())).collect(Collectors.toList())), 0));
    }
}

