/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.processor.internals.metrics;

import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.streams.processor.internals.metrics.StreamsMetricsImpl;

public class TopicMetrics {
    private static final String CONSUMED = "consumed";
    private static final String BYTES_CONSUMED = "bytes-consumed";
    private static final String BYTES_CONSUMED_DESCRIPTION = "bytes consumed from this topic";
    private static final String BYTES_CONSUMED_TOTAL_DESCRIPTION = "The total number of bytes consumed from this topic";
    private static final String RECORDS_CONSUMED = "records-consumed";
    private static final String RECORDS_CONSUMED_DESCRIPTION = "records consumed from this topic";
    private static final String RECORDS_CONSUMED_TOTAL_DESCRIPTION = "The total number of records consumed from this topic";
    private static final String PRODUCED = "produced";
    private static final String BYTES_PRODUCED = "bytes-produced";
    private static final String BYTES_PRODUCED_DESCRIPTION = "bytes produced to this topic";
    private static final String BYTES_PRODUCED_TOTAL_DESCRIPTION = "The total number of bytes produced to this topic";
    private static final String RECORDS_PRODUCED = "records-produced";
    private static final String RECORDS_PRODUCED_DESCRIPTION = "records produced to this topic";
    private static final String RECORDS_PRODUCED_TOTAL_DESCRIPTION = "The total number of records produced to this topic";

    public static Sensor consumedSensor(String threadId, String taskId, String processorNodeId, String topic, StreamsMetricsImpl streamsMetrics) {
        Sensor sensor = streamsMetrics.topicLevelSensor(threadId, taskId, processorNodeId, topic, CONSUMED, Sensor.RecordingLevel.INFO, new Sensor[0]);
        StreamsMetricsImpl.addTotalCountAndSumMetricsToSensor(sensor, "stream-topic-metrics", streamsMetrics.topicLevelTagMap(threadId, taskId, processorNodeId, topic), RECORDS_CONSUMED, BYTES_CONSUMED, RECORDS_CONSUMED_TOTAL_DESCRIPTION, BYTES_CONSUMED_TOTAL_DESCRIPTION);
        return sensor;
    }

    public static Sensor producedSensor(String threadId, String taskId, String processorNodeId, String topic, StreamsMetricsImpl streamsMetrics) {
        Sensor sensor = streamsMetrics.topicLevelSensor(threadId, taskId, processorNodeId, topic, PRODUCED, Sensor.RecordingLevel.INFO, new Sensor[0]);
        StreamsMetricsImpl.addTotalCountAndSumMetricsToSensor(sensor, "stream-topic-metrics", streamsMetrics.topicLevelTagMap(threadId, taskId, processorNodeId, topic), RECORDS_PRODUCED, BYTES_PRODUCED, RECORDS_PRODUCED_TOTAL_DESCRIPTION, BYTES_PRODUCED_TOTAL_DESCRIPTION);
        return sensor;
    }
}

