/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import com.typesafe.scalalogging.Logger;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.regex.Pattern;
import kafka.log.LocalLog;
import kafka.log.LocalLog$;
import kafka.log.LogLoader;
import kafka.log.SplitSegmentResult;
import kafka.log.UnifiedLog;
import kafka.server.BrokerTopicStats;
import kafka.utils.Logging;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.errors.KafkaStorageException;
import org.apache.kafka.common.internals.Topic;
import org.apache.kafka.common.record.FileRecords;
import org.apache.kafka.common.record.RecordBatch;
import org.apache.kafka.common.record.RecordVersion;
import org.apache.kafka.common.record.Records;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.server.util.Scheduler;
import org.apache.kafka.storage.internals.checkpoint.LeaderEpochCheckpointFile;
import org.apache.kafka.storage.internals.epoch.LeaderEpochFileCache;
import org.apache.kafka.storage.internals.log.AppendOrigin;
import org.apache.kafka.storage.internals.log.CompletedTxn;
import org.apache.kafka.storage.internals.log.LoadedLogOffsets;
import org.apache.kafka.storage.internals.log.LogConfig;
import org.apache.kafka.storage.internals.log.LogDirFailureChannel;
import org.apache.kafka.storage.internals.log.LogFileUtils;
import org.apache.kafka.storage.internals.log.LogOffsetMetadata;
import org.apache.kafka.storage.internals.log.LogOffsetsListener;
import org.apache.kafka.storage.internals.log.LogSegment;
import org.apache.kafka.storage.internals.log.LogSegments;
import org.apache.kafka.storage.internals.log.LogValidator;
import org.apache.kafka.storage.internals.log.ProducerAppendInfo;
import org.apache.kafka.storage.internals.log.ProducerStateManager;
import org.apache.kafka.storage.internals.log.ProducerStateManagerConfig;
import org.apache.kafka.storage.log.metrics.BrokerTopicMetrics;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.compat.java8.OptionConverters;
import scala.compat.java8.OptionConverters$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

public final class UnifiedLog$
implements Logging {
    public static UnifiedLog$ MODULE$;
    private final String LogFileSuffix;
    private final String IndexFileSuffix;
    private final String TimeIndexFileSuffix;
    private final String TxnIndexFileSuffix;
    private final String CleanedFileSuffix;
    private final String SwapFileSuffix;
    private final String DeleteDirSuffix;
    private final String StrayDirSuffix;
    private final String FutureDirSuffix;
    private final Pattern DeleteDirPattern;
    private final Pattern FutureDirPattern;
    private final long UnknownOffset;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    static {
        new UnifiedLog$();
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public boolean $lessinit$greater$default$9() {
        return false;
    }

    public LogOffsetsListener $lessinit$greater$default$10() {
        return LogOffsetsListener.NO_OP_OFFSETS_LISTENER;
    }

    public String LogFileSuffix() {
        return this.LogFileSuffix;
    }

    public String IndexFileSuffix() {
        return this.IndexFileSuffix;
    }

    public String TimeIndexFileSuffix() {
        return this.TimeIndexFileSuffix;
    }

    public String TxnIndexFileSuffix() {
        return this.TxnIndexFileSuffix;
    }

    public String CleanedFileSuffix() {
        return this.CleanedFileSuffix;
    }

    public String SwapFileSuffix() {
        return this.SwapFileSuffix;
    }

    public String DeleteDirSuffix() {
        return this.DeleteDirSuffix;
    }

    public String StrayDirSuffix() {
        return this.StrayDirSuffix;
    }

    public String FutureDirSuffix() {
        return this.FutureDirSuffix;
    }

    public Pattern DeleteDirPattern() {
        return this.DeleteDirPattern;
    }

    public Pattern FutureDirPattern() {
        return this.FutureDirPattern;
    }

    public long UnknownOffset() {
        return this.UnknownOffset;
    }

    public boolean isRemoteLogEnabled(boolean remoteStorageSystemEnable, LogConfig config, String topic) {
        return remoteStorageSystemEnable && !config.compact && !Topic.isInternal((String)topic) && !"__remote_log_metadata".equals(topic) && !"__cluster_metadata".equals(topic) && config.remoteStorageEnable();
    }

    public UnifiedLog apply(File dir, LogConfig config, long logStartOffset, long recoveryPoint, Scheduler scheduler, BrokerTopicStats brokerTopicStats, Time time, int maxTransactionTimeoutMs, ProducerStateManagerConfig producerStateManagerConfig, int producerIdExpirationCheckIntervalMs, LogDirFailureChannel logDirFailureChannel, boolean lastShutdownClean, Option<Uuid> topicId, boolean keepPartitionMetadataFile, ConcurrentMap<String, Object> numRemainingSegments, boolean remoteStorageSystemEnable, LogOffsetsListener logOffsetsListener) {
        Files.createDirectories(dir.toPath(), new FileAttribute[0]);
        TopicPartition topicPartition = this.parseTopicPartitionName(dir);
        LogSegments segments = new LogSegments(topicPartition);
        Option<LeaderEpochFileCache> leaderEpochCache = this.maybeCreateLeaderEpochCache(dir, topicPartition, logDirFailureChannel, config.recordVersion(), new StringBuilder(30).append("[UnifiedLog partition=").append(topicPartition).append(", dir=").append(dir.getParent()).append("] ").toString(), (Option<LeaderEpochFileCache>)None$.MODULE$, scheduler);
        ProducerStateManager producerStateManager = new ProducerStateManager(topicPartition, dir, maxTransactionTimeoutMs, producerStateManagerConfig, time);
        boolean isRemoteLogEnabled = this.isRemoteLogEnabled(remoteStorageSystemEnable, config, topicPartition.topic());
        LoadedLogOffsets offsets = new LogLoader(dir, topicPartition, config, scheduler, time, logDirFailureChannel, lastShutdownClean, segments, logStartOffset, recoveryPoint, OptionConverters.RichOptionForJava8$.MODULE$.asJava$extension(OptionConverters$.MODULE$.RichOptionForJava8(leaderEpochCache)), producerStateManager, numRemainingSegments, isRemoteLogEnabled).load();
        LocalLog localLog = new LocalLog(dir, config, segments, offsets.recoveryPoint, offsets.nextOffsetMetadata, scheduler, time, topicPartition, logDirFailureChannel);
        return new UnifiedLog(offsets.logStartOffset, localLog, brokerTopicStats, producerIdExpirationCheckIntervalMs, leaderEpochCache, producerStateManager, topicId, keepPartitionMetadataFile, remoteStorageSystemEnable, logOffsetsListener);
    }

    public boolean apply$default$12() {
        return true;
    }

    public ConcurrentMap<String, Object> apply$default$15() {
        return new ConcurrentHashMap<String, Object>();
    }

    public boolean apply$default$16() {
        return false;
    }

    public LogOffsetsListener apply$default$17() {
        return LogOffsetsListener.NO_OP_OFFSETS_LISTENER;
    }

    public String logDeleteDirName(TopicPartition topicPartition) {
        return LocalLog$.MODULE$.logDeleteDirName(topicPartition);
    }

    public String logFutureDirName(TopicPartition topicPartition) {
        return LocalLog$.MODULE$.logFutureDirName(topicPartition);
    }

    public String logStrayDirName(TopicPartition topicPartition) {
        return LocalLog$.MODULE$.logStrayDirName(topicPartition);
    }

    public String logDirName(TopicPartition topicPartition) {
        return LocalLog$.MODULE$.logDirName(topicPartition);
    }

    public File transactionIndexFile(File dir, long offset, String suffix) {
        return LogFileUtils.transactionIndexFile((File)dir, (long)offset, (String)suffix);
    }

    public String transactionIndexFile$default$3() {
        return "";
    }

    public long offsetFromFile(File file) {
        return Predef$.MODULE$.Long2long(LogFileUtils.offsetFromFile((File)file));
    }

    public long sizeInBytes(Collection<LogSegment> segments) {
        return LogSegments.sizeInBytes(segments);
    }

    public TopicPartition parseTopicPartitionName(File dir) {
        return LocalLog$.MODULE$.parseTopicPartitionName(dir);
    }

    public boolean isIndexFile(File file) {
        return LocalLog$.MODULE$.isIndexFile(file);
    }

    public boolean isLogFile(File file) {
        return LocalLog$.MODULE$.isLogFile(file);
    }

    private void loadProducersFromRecords(ProducerStateManager producerStateManager, Records records) {
        Map loadedProducers = Map$.MODULE$.empty();
        ListBuffer completedTxns = (ListBuffer)ListBuffer$.MODULE$.empty();
        records.batches().forEach(batch -> {
            if (batch.hasProducerId()) {
                MODULE$.kafka$log$UnifiedLog$$updateProducers(producerStateManager, (RecordBatch)batch, (Map<Object, ProducerAppendInfo>)loadedProducers, (Option<LogOffsetMetadata>)None$.MODULE$, AppendOrigin.REPLICATION).foreach((Function1 & Serializable & scala.Serializable)x$27 -> completedTxns.$plus$eq(x$27));
                return;
            }
        });
        loadedProducers.values().foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
            producerStateManager.update(x$1);
            return BoxedUnit.UNIT;
        });
        completedTxns.foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
            producerStateManager.completeTxn(x$1);
            return BoxedUnit.UNIT;
        });
    }

    public Option<CompletedTxn> kafka$log$UnifiedLog$$updateProducers(ProducerStateManager producerStateManager, RecordBatch batch, Map<Object, ProducerAppendInfo> producers, Option<LogOffsetMetadata> firstOffsetMetadata, AppendOrigin origin) {
        long producerId = batch.producerId();
        ProducerAppendInfo appendInfo = (ProducerAppendInfo)producers.getOrElseUpdate((Object)BoxesRunTime.boxToLong((long)producerId), (Function0 & Serializable & scala.Serializable)() -> producerStateManager.prepareUpdate(producerId, origin));
        Option completedTxn = OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(appendInfo.append(batch, OptionConverters.RichOptionForJava8$.MODULE$.asJava$extension(OptionConverters$.MODULE$.RichOptionForJava8(firstOffsetMetadata)))));
        if (batch.isTransactional()) {
            producerStateManager.clearVerificationStateEntry(producerId);
        }
        return completedTxn;
    }

    public Option<LeaderEpochFileCache> maybeCreateLeaderEpochCache(File dir, TopicPartition topicPartition, LogDirFailureChannel logDirFailureChannel, RecordVersion recordVersion, String logPrefix, Option<LeaderEpochFileCache> currentCache, Scheduler scheduler) {
        File leaderEpochFile = LeaderEpochCheckpointFile.newFile((File)dir);
        if (recordVersion.precedes(RecordVersion.V2)) {
            if (leaderEpochFile.exists() && this.logger().underlying().isWarnEnabled()) {
                this.logger().underlying().warn(this.msgWithLogIdent(UnifiedLog$.$anonfun$maybeCreateLeaderEpochCache$1(logPrefix, recordVersion)));
            }
            Files.deleteIfExists(leaderEpochFile.toPath());
            return None$.MODULE$;
        }
        LeaderEpochCheckpointFile checkpointFile = new LeaderEpochCheckpointFile(leaderEpochFile, logDirFailureChannel);
        return currentCache.map((Function1 & Serializable & scala.Serializable)x$28 -> x$28.withCheckpoint(checkpointFile)).orElse((Function0 & Serializable & scala.Serializable)() -> new Some((Object)new LeaderEpochFileCache(topicPartition, checkpointFile, scheduler)));
    }

    public Iterable<LogSegment> replaceSegments(LogSegments existingSegments, Seq<LogSegment> newSegments, Seq<LogSegment> oldSegments, File dir, TopicPartition topicPartition, LogConfig config, Scheduler scheduler, LogDirFailureChannel logDirFailureChannel, String logPrefix, boolean isRecoveredSwapFile) {
        return LocalLog$.MODULE$.replaceSegments(existingSegments, newSegments, oldSegments, dir, topicPartition, config, scheduler, logDirFailureChannel, logPrefix, isRecoveredSwapFile);
    }

    public boolean replaceSegments$default$10() {
        return false;
    }

    public void deleteSegmentFiles(scala.collection.immutable.Iterable<LogSegment> segmentsToDelete, boolean asyncDelete, File dir, TopicPartition topicPartition, LogConfig config, Scheduler scheduler, LogDirFailureChannel logDirFailureChannel, String logPrefix) {
        LocalLog$.MODULE$.deleteSegmentFiles(segmentsToDelete, asyncDelete, dir, topicPartition, config, scheduler, logDirFailureChannel, logPrefix);
    }

    public void rebuildProducerState(ProducerStateManager producerStateManager, LogSegments segments, long logStartOffset, long lastOffset, RecordVersion recordVersion, Time time, boolean reloadFromCleanShutdown, String logPrefix) {
        .colon.colon offsetsToSnapshot;
        .colon.colon colon2;
        if (segments.nonEmpty()) {
            long lastSegmentBaseOffset = ((LogSegment)segments.lastSegment().get()).baseOffset();
            Option nextLatestSegmentBaseOffset = OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(segments.lowerSegment(lastSegmentBaseOffset))).map((Function1 & Serializable & scala.Serializable)x$29 -> BoxesRunTime.boxToLong((long)x$29.baseOffset()));
            colon2 = new .colon.colon((Object)nextLatestSegmentBaseOffset, (List)new .colon.colon((Object)new Some((Object)BoxesRunTime.boxToLong((long)lastSegmentBaseOffset)), (List)new .colon.colon((Object)new Some((Object)BoxesRunTime.boxToLong((long)lastOffset)), (List)Nil$.MODULE$)));
        } else {
            colon2 = offsetsToSnapshot = new .colon.colon((Object)new Some((Object)BoxesRunTime.boxToLong((long)lastOffset)), (List)Nil$.MODULE$);
        }
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info(this.msgWithLogIdent(UnifiedLog$.$anonfun$rebuildProducerState$2(logPrefix, lastOffset, recordVersion)));
        }
        if (recordVersion.value < 2 || !producerStateManager.latestSnapshotOffset().isPresent() && reloadFromCleanShutdown) {
            ((IterableLike)offsetsToSnapshot.flatten((Function1 & Serializable & scala.Serializable)xo -> Option$.MODULE$.option2Iterable(xo))).foreach((Function1)(JFunction1.mcVJ.sp & Serializable & scala.Serializable)offset -> {
                producerStateManager.updateMapEndOffset(offset);
                producerStateManager.takeSnapshot();
            });
            return;
        }
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info(this.msgWithLogIdent(UnifiedLog$.$anonfun$rebuildProducerState$5(logPrefix, lastOffset)));
        }
        boolean isEmptyBeforeTruncation = producerStateManager.isEmpty() && producerStateManager.mapEndOffset() >= lastOffset;
        long producerStateLoadStart = time.milliseconds();
        producerStateManager.truncateAndReload(logStartOffset, lastOffset, time.milliseconds());
        long segmentRecoveryStart = time.milliseconds();
        if (lastOffset > producerStateManager.mapEndOffset() && !isEmptyBeforeTruncation) {
            Optional segmentOfLastOffset = segments.floorSegment(lastOffset);
            segments.values(producerStateManager.mapEndOffset(), lastOffset).forEach(arg_0 -> UnifiedLog$.$anonfun$rebuildProducerState$6(producerStateManager, logStartOffset, (Seq)offsetsToSnapshot, segmentOfLastOffset, lastOffset, arg_0));
        }
        producerStateManager.updateMapEndOffset(lastOffset);
        producerStateManager.takeSnapshot();
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info(this.msgWithLogIdent(UnifiedLog$.$anonfun$rebuildProducerState$9(logPrefix, segmentRecoveryStart, producerStateLoadStart, time, lastOffset)));
            return;
        }
    }

    public SplitSegmentResult splitOverflowedSegment(LogSegment segment, LogSegments existingSegments, File dir, TopicPartition topicPartition, LogConfig config, Scheduler scheduler, LogDirFailureChannel logDirFailureChannel, String logPrefix) {
        return LocalLog$.MODULE$.splitOverflowedSegment(segment, existingSegments, dir, topicPartition, config, scheduler, logDirFailureChannel, logPrefix);
    }

    public void deleteProducerSnapshots(Iterable<LogSegment> segments, ProducerStateManager producerStateManager, boolean asyncDelete, Scheduler scheduler, LogConfig config, LogDirFailureChannel logDirFailureChannel, String parentDir, TopicPartition topicPartition) {
        Iterable snapshotsToDelete = (Iterable)segments.flatMap((Function1 & Serializable & scala.Serializable)segment -> Option$.MODULE$.option2Iterable(OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(producerStateManager.removeAndMarkSnapshotForDeletion(segment.baseOffset())))), Iterable$.MODULE$.canBuildFrom());
        if (asyncDelete) {
            scheduler.scheduleOnce("delete-producer-snapshot", () -> UnifiedLog$.deleteProducerSnapshots$1(logDirFailureChannel, parentDir, topicPartition, snapshotsToDelete), config.fileDeleteDelayMs);
            return;
        }
        UnifiedLog$.deleteProducerSnapshots$1(logDirFailureChannel, parentDir, topicPartition, snapshotsToDelete);
    }

    public LogSegment createNewCleanedSegment(File dir, LogConfig logConfig, long baseOffset) {
        return LocalLog$.MODULE$.createNewCleanedSegment(dir, logConfig, baseOffset);
    }

    public LogValidator.MetricsRecorder newValidatorMetricsRecorder(BrokerTopicMetrics allTopicsStats) {
        return new LogValidator.MetricsRecorder(allTopicsStats){
            private final BrokerTopicMetrics allTopicsStats$1;

            public void recordInvalidMagic() {
                this.allTopicsStats$1.invalidMagicNumberRecordsPerSec().mark();
            }

            public void recordInvalidOffset() {
                this.allTopicsStats$1.invalidOffsetOrSequenceRecordsPerSec().mark();
            }

            public void recordInvalidSequence() {
                this.allTopicsStats$1.invalidOffsetOrSequenceRecordsPerSec().mark();
            }

            public void recordInvalidChecksums() {
                this.allTopicsStats$1.invalidMessageCrcRecordsPerSec().mark();
            }

            public void recordNoKeyCompactedTopic() {
                this.allTopicsStats$1.noKeyCompactedTopicRecordsPerSec().mark();
            }
            {
                this.allTopicsStats$1 = allTopicsStats$1;
            }
        };
    }

    public long localRetentionMs(LogConfig config, boolean remoteLogEnabledAndRemoteCopyEnabled) {
        if (remoteLogEnabledAndRemoteCopyEnabled) {
            return config.localRetentionMs();
        }
        return config.retentionMs;
    }

    public long localRetentionSize(LogConfig config, boolean remoteLogEnabledAndRemoteCopyEnabled) {
        if (remoteLogEnabledAndRemoteCopyEnabled) {
            return config.localRetentionBytes();
        }
        return config.retentionSize;
    }

    public static final /* synthetic */ String $anonfun$maybeCreateLeaderEpochCache$1(String logPrefix$1, RecordVersion recordVersion$1) {
        return new StringBuilder(73).append(logPrefix$1).append("Deleting non-empty leader epoch cache due to incompatible message format ").append(recordVersion$1).toString();
    }

    public static final /* synthetic */ String $anonfun$rebuildProducerState$2(String logPrefix$2, long lastOffset$2, RecordVersion recordVersion$2) {
        return new StringBuilder(64).append(logPrefix$2).append("Loading producer state till offset ").append(lastOffset$2).append(" with message format version ").append(recordVersion$2.value).toString();
    }

    public static final /* synthetic */ String $anonfun$rebuildProducerState$5(String logPrefix$2, long lastOffset$2) {
        return new StringBuilder(75).append(logPrefix$2).append("Reloading from producer snapshot and rebuilding producer state from offset ").append(lastOffset$2).toString();
    }

    public static final /* synthetic */ int $anonfun$rebuildProducerState$8(LogSegment segment$3) {
        return segment$3.size();
    }

    /*
     * Unable to fully structure code
     */
    public static final /* synthetic */ void $anonfun$rebuildProducerState$6(ProducerStateManager producerStateManager$3, long logStartOffset$1, Seq offsetsToSnapshot$1, Optional segmentOfLastOffset$1, long lastOffset$2, LogSegment segment) {
        startOffset = Utils.max((long)segment.baseOffset(), (long[])new long[]{producerStateManager$3.mapEndOffset(), logStartOffset$1});
        producerStateManager$3.updateMapEndOffset(startOffset);
        if (offsetsToSnapshot$1.contains((Object)new Some((Object)BoxesRunTime.boxToLong((long)segment.baseOffset())))) {
            producerStateManager$3.takeSnapshot();
        }
        if (!segmentOfLastOffset$1.isPresent()) ** GOTO lbl-1000
        v0 = segmentOfLastOffset$1.get();
        if (v0 != null && v0.equals(segment)) {
            v1 = BoxesRunTime.unboxToInt((Object)Option$.MODULE$.apply((Object)segment.translateOffset(lastOffset$2)).map((Function1)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$rebuildProducerState$7$adapted(org.apache.kafka.common.record.FileRecords$LogOffsetPosition ), (Lorg/apache/kafka/common/record/FileRecords$LogOffsetPosition;)Ljava/lang/Object;)()).getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()I, $anonfun$rebuildProducerState$8(org.apache.kafka.storage.internals.log.LogSegment ), ()I)((LogSegment)segment)));
        } else lbl-1000:
        // 2 sources

        {
            v1 = segment.size();
        }
        maxPosition = v1;
        fetchDataInfo = segment.read(startOffset, 0x7FFFFFFF, (long)maxPosition);
        if (fetchDataInfo != null) {
            UnifiedLog$.MODULE$.loadProducersFromRecords(producerStateManager$3, fetchDataInfo.records);
            return;
        }
    }

    public static final /* synthetic */ String $anonfun$rebuildProducerState$9(String logPrefix$2, long segmentRecoveryStart$1, long producerStateLoadStart$1, Time time$1, long lastOffset$2) {
        return new StringBuilder(90).append(logPrefix$2).append("Producer state recovery took ").append(segmentRecoveryStart$1 - producerStateLoadStart$1).append("ms for snapshot load ").append("and ").append(time$1.milliseconds() - segmentRecoveryStart$1).append("ms for segment recovery from offset ").append(lastOffset$2).toString();
    }

    public static final /* synthetic */ String $anonfun$deleteProducerSnapshots$2(TopicPartition topicPartition$2, String parentDir$1) {
        return new StringBuilder(58).append("Error while deleting producer state snapshots for ").append(topicPartition$2).append(" in dir ").append(parentDir$1).toString();
    }

    private static final void deleteProducerSnapshots$1(LogDirFailureChannel logDirFailureChannel$1, String parentDir$1, TopicPartition topicPartition$2, Iterable snapshotsToDelete$1) {
        if (LocalLog$.MODULE$ == null) {
            throw null;
        }
        if (logDirFailureChannel$1.hasOfflineLogDir(parentDir$1)) {
            throw new KafkaStorageException(new StringBuilder(63).append("The log dir ").append(parentDir$1).append(" is already offline due to a previous IO exception.").toString());
        }
        try {
            snapshotsToDelete$1.foreach((Function1 & Serializable & scala.Serializable)snapshot -> BoxesRunTime.boxToBoolean((boolean)snapshot.deleteIfExists()));
            return;
        }
        catch (IOException maybeHandleIOException_e) {
            logDirFailureChannel$1.maybeAddOfflineLogDir(parentDir$1, UnifiedLog$.$anonfun$deleteProducerSnapshots$2(topicPartition$2, parentDir$1), maybeHandleIOException_e);
            throw new KafkaStorageException(UnifiedLog$.$anonfun$deleteProducerSnapshots$2(topicPartition$2, parentDir$1), (Throwable)maybeHandleIOException_e);
        }
    }

    private UnifiedLog$() {
        MODULE$ = this;
        Logging.$init$(this);
        this.LogFileSuffix = ".log";
        this.IndexFileSuffix = ".index";
        this.TimeIndexFileSuffix = ".timeindex";
        this.TxnIndexFileSuffix = ".txnindex";
        this.CleanedFileSuffix = LocalLog$.MODULE$.CleanedFileSuffix();
        this.SwapFileSuffix = LocalLog$.MODULE$.SwapFileSuffix();
        this.DeleteDirSuffix = LocalLog$.MODULE$.DeleteDirSuffix();
        this.StrayDirSuffix = LocalLog$.MODULE$.StrayDirSuffix();
        this.FutureDirSuffix = LocalLog$.MODULE$.FutureDirSuffix();
        this.DeleteDirPattern = LocalLog$.MODULE$.DeleteDirPattern();
        this.FutureDirPattern = LocalLog$.MODULE$.FutureDirPattern();
        this.UnknownOffset = LocalLog$.MODULE$.UnknownOffset();
    }

    public static final /* synthetic */ Object $anonfun$rebuildProducerState$7$adapted(FileRecords.LogOffsetPosition x$30) {
        return BoxesRunTime.boxToInteger((int)x$30.position);
    }
}

