/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.coordinator.group;

import java.util.Objects;
import org.apache.kafka.server.common.ApiMessageAndVersion;

public class CoordinatorRecord {
    private final ApiMessageAndVersion key;
    private final ApiMessageAndVersion value;

    public CoordinatorRecord(ApiMessageAndVersion key, ApiMessageAndVersion value) {
        this.key = Objects.requireNonNull(key);
        this.value = value;
    }

    public ApiMessageAndVersion key() {
        return this.key;
    }

    public ApiMessageAndVersion value() {
        return this.value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CoordinatorRecord record = (CoordinatorRecord)o;
        if (!Objects.equals(this.key, record.key)) {
            return false;
        }
        return Objects.equals(this.value, record.value);
    }

    public int hashCode() {
        int result = this.key.hashCode();
        result = 31 * result + (this.value != null ? this.value.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "CoordinatorRecord(key=" + this.key + ", value=" + this.value + ")";
    }
}

