/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.config.internals;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.kafka.common.config.ConfigException;

public class AllowedPaths {
    private final List<Path> allowedPaths;

    public AllowedPaths(String configValue) {
        this.allowedPaths = this.getAllowedPaths(configValue);
    }

    private List<Path> getAllowedPaths(String configValue) {
        if (configValue != null && !configValue.isEmpty()) {
            ArrayList<Path> allowedPaths = new ArrayList<Path>();
            Arrays.stream(configValue.split(",")).forEach(b -> {
                Path normalisedPath = Paths.get(b, new String[0]).normalize();
                if (!normalisedPath.isAbsolute()) {
                    throw new ConfigException("Path " + normalisedPath + " is not absolute");
                }
                if (!Files.exists(normalisedPath, new LinkOption[0])) {
                    throw new ConfigException("Path " + normalisedPath + " does not exist");
                }
                allowedPaths.add(normalisedPath);
            });
            return allowedPaths;
        }
        return null;
    }

    public Path parseUntrustedPath(String path) {
        Path parsedPath = Paths.get(path, new String[0]);
        if (this.allowedPaths != null) {
            Path normalisedPath = parsedPath.normalize();
            long allowed = this.allowedPaths.stream().filter(allowedPath -> normalisedPath.startsWith((Path)allowedPath)).count();
            if (allowed == 0L) {
                return null;
            }
            return normalisedPath;
        }
        return parsedPath;
    }
}

