/*
 * Decompiled with CFR 0.152.
 */
package org.apache.johnzon.jsonschema.spi.builtin;

import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Stream;
import javax.json.JsonArray;
import javax.json.JsonNumber;
import javax.json.JsonValue;
import org.apache.johnzon.jsonschema.ValidationResult;
import org.apache.johnzon.jsonschema.spi.ValidationContext;
import org.apache.johnzon.jsonschema.spi.ValidationExtension;
import org.apache.johnzon.jsonschema.spi.builtin.BaseValidation;

public class MinItemsValidation
implements ValidationExtension {
    @Override
    public Optional<Function<JsonValue, Stream<ValidationResult.ValidationError>>> create(ValidationContext model) {
        return Optional.ofNullable(model.getSchema().get((Object)"minItems")).filter(it -> it.getValueType() == JsonValue.ValueType.NUMBER).map(it -> ((JsonNumber)JsonNumber.class.cast(it)).intValue()).filter(it -> it >= 0).map(max -> new Impl(model.toPointer(), model.getValueProvider(), (int)max));
    }

    private static class Impl
    extends BaseValidation {
        private final int bound;

        private Impl(String pointer, Function<JsonValue, JsonValue> extractor, int bound) {
            super(pointer, extractor, JsonValue.ValueType.ARRAY);
            this.bound = bound;
        }

        @Override
        protected Stream<ValidationResult.ValidationError> onArray(JsonArray array) {
            if (array.size() < this.bound) {
                return Stream.of(new ValidationResult.ValidationError(this.pointer, "Not enough items in the array (< " + this.bound + ")"));
            }
            return Stream.empty();
        }

        public String toString() {
            return "MinItems{min=" + this.bound + ", pointer='" + this.pointer + '\'' + '}';
        }
    }
}

