/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.ui.tabbedpane;

import com.github.weisj.darklaf.components.uiresource.JButtonUIResource;
import com.github.weisj.darklaf.ui.tabbedpane.DarkTabbedPaneUI;
import com.github.weisj.darklaf.ui.tabbedpane.TabButtonContainer;
import java.awt.Component;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.UIManager;

public class MoreTabsButton
extends TabButtonContainer {
    protected static final String INFINITY = "\u221e";
    private final int pad = UIManager.getInt("TabbedPane.moreTabsButton.pad");

    public MoreTabsButton(DarkTabbedPaneUI ui) {
        super(ui);
        this.button.setMargin(new Insets(this.pad, this.pad, this.pad, this.pad));
    }

    @Override
    protected JButton createButton() {
        JButtonUIResource button = new JButtonUIResource();
        button.setForeground(UIManager.getColor("TabbedPane.moreTabsButton.foreground"));
        button.setFont(UIManager.getFont("TabbedPane.moreTabsButton.font"));
        button.setIcon(new MoreTabsIcon(this.ui.getMoreTabsIcon(), this));
        button.putClientProperty("JButton.variant", "borderless");
        button.putClientProperty("JButton.thin", true);
        button.setFocusable(false);
        button.setRolloverEnabled(true);
        button.setOpaque(false);
        return button;
    }

    protected String getLabelString() {
        int invisible = Math.min(this.ui.minVisible - 1 + this.ui.tabPane.getTabCount() - this.ui.maxVisible, this.ui.tabPane.getTabCount());
        return invisible >= 100 ? INFINITY : String.valueOf(invisible);
    }

    protected static class MoreTabsIcon
    implements Icon {
        private final Icon icon;
        private final MoreTabsButton button;

        protected MoreTabsIcon(Icon icon, MoreTabsButton button) {
            this.icon = icon;
            this.button = button;
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            this.icon.paintIcon(c, g, x, y + this.getIconHeight() - this.icon.getIconHeight());
            String text = this.button.getLabelString();
            g.setColor(this.button.getForeground());
            g.drawString(text, x + this.icon.getIconWidth() + this.button.pad, y + this.icon.getIconHeight());
        }

        @Override
        public int getIconWidth() {
            String text = this.button.getLabelString();
            FontMetrics fm = this.button.getFontMetrics(this.button.getFont());
            int textWidth = fm.stringWidth(this.button.getLabelString());
            if (text.equals(MoreTabsButton.INFINITY)) {
                textWidth = Math.max(textWidth, fm.stringWidth("00"));
            }
            return this.icon.getIconWidth() + textWidth + this.button.pad;
        }

        @Override
        public int getIconHeight() {
            return this.icon.getIconHeight();
        }
    }
}

