/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.protocol.http.control;

import org.apache.http.auth.AuthScheme;
import org.apache.http.impl.auth.SPNegoScheme;
import org.apache.http.impl.auth.SPNegoSchemeFactory;
import org.apache.http.protocol.HttpContext;
import org.apache.jmeter.protocol.http.control.DelegatingSPNegoScheme;
import org.apache.jmeter.util.JMeterUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DynamicSPNegoSchemeFactory
extends SPNegoSchemeFactory {
    static final String CONTEXT_ATTRIBUTE_STRIP_PORT = "__jmeter.K_SP__";
    static final String CONTEXT_ATTRIBUTE_DELEGATE_CRED = "__jmeter.K_DT__";
    static final boolean DELEGATE_CRED = JMeterUtils.getPropDefault((String)"kerberos.spnego.delegate_cred", (boolean)false);
    private static final Logger log = LoggerFactory.getLogger(DynamicSPNegoSchemeFactory.class);

    public DynamicSPNegoSchemeFactory(boolean stripPort, boolean useCanonicalHostname) {
        super(stripPort, useCanonicalHostname);
    }

    public AuthScheme create(HttpContext context) {
        boolean stripPort = DynamicSPNegoSchemeFactory.isEnabled(context.getAttribute(CONTEXT_ATTRIBUTE_STRIP_PORT), this.isStripPort());
        if (DynamicSPNegoSchemeFactory.isEnabled(context.getAttribute(CONTEXT_ATTRIBUTE_DELEGATE_CRED), DELEGATE_CRED)) {
            log.debug("Use DelegatingSPNegoScheme");
            return new DelegatingSPNegoScheme(stripPort, this.isStripPort());
        }
        log.debug("Use SPNegoScheme");
        return new SPNegoScheme(stripPort, this.isUseCanonicalHostname());
    }

    private static boolean isEnabled(Object contextAttribute, boolean defaultValue) {
        if (contextAttribute instanceof Boolean) {
            return (Boolean)contextAttribute;
        }
        return defaultValue;
    }
}

