/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.store;

import java.io.IOException;
import java.lang.foreign.FunctionDescriptor;
import java.lang.foreign.Linker;
import java.lang.foreign.MemoryLayout;
import java.lang.foreign.MemorySegment;
import java.lang.foreign.SymbolLookup;
import java.lang.foreign.ValueLayout;
import java.lang.invoke.MethodHandle;
import java.util.Locale;
import java.util.Optional;
import java.util.logging.Logger;
import org.apache.lucene.store.NativeAccess;
import org.apache.lucene.store.ReadAdvice;

final class PosixNativeAccess
extends NativeAccess {
    private static final Logger LOG = Logger.getLogger(PosixNativeAccess.class.getName());
    public static final int POSIX_MADV_NORMAL = 0;
    public static final int POSIX_MADV_RANDOM = 1;
    public static final int POSIX_MADV_SEQUENTIAL = 2;
    public static final int POSIX_MADV_WILLNEED = 3;
    public static final int POSIX_MADV_DONTNEED = 4;
    private static final MethodHandle MH$posix_madvise;
    private static final int PAGE_SIZE;
    private static final Optional<NativeAccess> INSTANCE;

    private PosixNativeAccess() {
    }

    static Optional<NativeAccess> getInstance() {
        return INSTANCE;
    }

    private static MethodHandle lookupMadvise(Linker linker, SymbolLookup stdlib) {
        return PosixNativeAccess.findFunction(linker, stdlib, "posix_madvise", FunctionDescriptor.of(ValueLayout.JAVA_INT, ValueLayout.ADDRESS, ValueLayout.JAVA_LONG, ValueLayout.JAVA_INT));
    }

    private static MethodHandle lookupGetPageSize(Linker linker, SymbolLookup stdlib) {
        return PosixNativeAccess.findFunction(linker, stdlib, "getpagesize", FunctionDescriptor.of(ValueLayout.JAVA_INT, new MemoryLayout[0]));
    }

    private static MethodHandle findFunction(Linker linker, SymbolLookup lookup, String name, FunctionDescriptor desc) {
        MemorySegment symbol = lookup.find(name).orElseThrow(() -> new UnsupportedOperationException("Platform has no symbol for '" + name + "' in libc."));
        return linker.downcallHandle(symbol, desc, new Linker.Option[0]);
    }

    @Override
    public void madvise(MemorySegment segment, ReadAdvice readAdvice) throws IOException {
        int advice = this.mapReadAdvice(readAdvice);
        this.madvise(segment, advice);
    }

    @Override
    public void madviseWillNeed(MemorySegment segment) throws IOException {
        this.madvise(segment, 3);
    }

    private void madvise(MemorySegment segment, int advice) throws IOException {
        int ret;
        if (segment.byteSize() == 0L) {
            return;
        }
        try {
            ret = MH$posix_madvise.invokeExact(segment, segment.byteSize(), advice);
        }
        catch (Throwable th) {
            throw new AssertionError((Object)th);
        }
        if (ret != 0) {
            throw new IOException(String.format(Locale.ENGLISH, "Call to posix_madvise with address=0x%08X and byteSize=%d failed with return code %d.", segment.address(), segment.byteSize(), ret));
        }
    }

    private int mapReadAdvice(ReadAdvice readAdvice) {
        return switch (readAdvice) {
            default -> throw new MatchException(null, null);
            case ReadAdvice.NORMAL -> 0;
            case ReadAdvice.RANDOM -> 1;
            case ReadAdvice.SEQUENTIAL -> 2;
            case ReadAdvice.RANDOM_PRELOAD -> 0;
        };
    }

    @Override
    public int getPageSize() {
        return PAGE_SIZE;
    }

    static {
        Linker linker = Linker.nativeLinker();
        SymbolLookup stdlib = linker.defaultLookup();
        MethodHandle adviseHandle = null;
        int pagesize = -1;
        PosixNativeAccess instance = null;
        try {
            adviseHandle = PosixNativeAccess.lookupMadvise(linker, stdlib);
            pagesize = PosixNativeAccess.lookupGetPageSize(linker, stdlib).invokeExact();
            instance = new PosixNativeAccess();
        }
        catch (UnsupportedOperationException uoe) {
            LOG.warning(uoe.getMessage());
        }
        catch (IllegalCallerException ice) {
            LOG.warning(String.format(Locale.ENGLISH, "Lucene has no access to native functions. To enable access to native functions, pass the following on command line: --enable-native-access=%s", Optional.ofNullable(PosixNativeAccess.class.getModule().getName()).orElse("ALL-UNNAMED")));
        }
        catch (Error | RuntimeException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new AssertionError((Object)e);
        }
        MH$posix_madvise = adviseHandle;
        PAGE_SIZE = pagesize;
        INSTANCE = Optional.ofNullable(instance);
    }
}

