/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.store.raw.data;

import org.apache.derby.iapi.store.raw.Page;
import org.apache.derby.impl.store.raw.data.AllocExtent;
import org.apache.derby.impl.store.raw.data.AllocPage;
import org.apache.derby.impl.store.raw.data.BaseContainerHandle;
import org.apache.derby.impl.store.raw.data.SpaceInformation;
import org.apache.derby.shared.common.error.StandardException;

class AllocationCache {
    private int numExtents = 0;
    private long[] lowRange;
    private long[] hiRange;
    private boolean[] isDirty;
    private AllocExtent[] extents;
    private long[] extentPageNums;
    private boolean isValid = false;

    protected AllocationCache() {
    }

    protected void reset() {
        this.numExtents = 0;
        this.isValid = false;
        if (this.lowRange != null) {
            for (int i = 0; i < this.lowRange.length; ++i) {
                this.lowRange[i] = -1L;
                this.hiRange[i] = -1L;
                this.extentPageNums[i] = -1L;
                this.extents[i] = null;
                this.isDirty[i] = false;
            }
        }
    }

    protected long getAllocPageNumber(BaseContainerHandle baseContainerHandle, long l, long l2) throws StandardException {
        int n;
        for (n = 0; n < this.numExtents; ++n) {
            if (this.lowRange[n] > l || l > this.hiRange[n]) continue;
            return this.extentPageNums[n];
        }
        if (!this.isValid) {
            this.validate(baseContainerHandle, l2);
            for (n = 0; n < this.numExtents; ++n) {
                if (this.lowRange[n] > l || l > this.hiRange[n]) continue;
                return this.extentPageNums[n];
            }
        }
        return -1L;
    }

    protected long getLastPageNumber(BaseContainerHandle baseContainerHandle, long l) throws StandardException {
        if (!this.isValid) {
            this.validate(baseContainerHandle, l);
        }
        return this.hiRange[this.numExtents - 1];
    }

    protected void trackUnfilledPage(long l, boolean bl) {
        if (!this.isValid || this.numExtents <= 0) {
            return;
        }
        for (int i = 0; i < this.numExtents; ++i) {
            if (this.lowRange[i] > l || l > this.hiRange[i]) continue;
            AllocExtent allocExtent = this.extents[i];
            if (allocExtent == null || !allocExtent.trackUnfilledPage(l, bl) || this.extents[i] == null) break;
            this.isDirty[i] = true;
            break;
        }
    }

    protected long getUnfilledPageNumber(BaseContainerHandle baseContainerHandle, long l, long l2) throws StandardException {
        if (!this.isValid) {
            this.validate(baseContainerHandle, l);
        }
        if (l2 == -1L) {
            for (int i = 0; i < this.numExtents; ++i) {
                if (this.extents[i] == null) continue;
                return this.extents[i].getUnfilledPageNumber(l2);
            }
        } else {
            for (int i = 0; i < this.numExtents; ++i) {
                if (l2 > this.hiRange[i] || this.extents[i] == null) continue;
                return this.extents[i].getUnfilledPageNumber(l2);
            }
        }
        return -1L;
    }

    protected long getEstimatedPageCount(BaseContainerHandle baseContainerHandle, long l) throws StandardException {
        if (!this.isValid) {
            this.validate(baseContainerHandle, l);
        }
        long l2 = 0L;
        for (int i = 0; i < this.numExtents; ++i) {
            if (this.extents[i] == null) continue;
            l2 += (long)this.extents[i].getAllocatedPageCount();
        }
        return l2;
    }

    protected SpaceInformation getAllPageCounts(BaseContainerHandle baseContainerHandle, long l) throws StandardException {
        long l2 = 0L;
        long l3 = 0L;
        long l4 = 0L;
        long l5 = 0L;
        if (!this.isValid) {
            this.validate(baseContainerHandle, l);
        }
        for (int i = 0; i < this.numExtents; ++i) {
            if (this.extents[i] == null) continue;
            l2 = this.extents[i].getAllocatedPageCount();
            l3 += l2;
            l5 += (long)this.extents[i].getUnfilledPageCount();
            l4 += (long)this.extents[i].getTotalPageCount() - l2;
        }
        return new SpaceInformation(l3, l4, l5);
    }

    protected void invalidate() {
        for (int i = 0; i < this.numExtents; ++i) {
            this.isDirty[i] = false;
            this.extents[i] = null;
        }
        this.isValid = false;
    }

    protected void invalidate(AllocPage allocPage, long l) throws StandardException {
        this.isValid = false;
        if (this.numExtents == 0) {
            return;
        }
        for (int i = 0; i < this.numExtents; ++i) {
            if (this.extentPageNums[i] != l) continue;
            if (allocPage != null && this.extents[i] != null && this.isDirty[i]) {
                allocPage.updateUnfilledPageInfo(this.extents[i]);
                this.isDirty[i] = false;
            }
            this.extents[i] = null;
            return;
        }
        if (l > this.hiRange[this.numExtents - 1]) {
            return;
        }
    }

    protected void invalidateLastExtent() {
        this.isValid = false;
        if (this.numExtents > 0) {
            this.extents[this.numExtents - 1] = null;
        }
    }

    protected long getLastValidPage(BaseContainerHandle baseContainerHandle, long l) throws StandardException {
        AllocExtent allocExtent = null;
        long l2 = -1L;
        if (!this.isValid) {
            this.validate(baseContainerHandle, l);
        }
        if (this.numExtents == 0) {
            return -1L;
        }
        for (int i = this.numExtents - 1; i >= 0 && (l2 = (allocExtent = this.extents[i]).getLastValidPageNumber()) == -1L; --i) {
        }
        return l2;
    }

    protected long getNextValidPage(BaseContainerHandle baseContainerHandle, long l, long l2) throws StandardException {
        int n;
        if (!this.isValid) {
            this.validate(baseContainerHandle, l2);
        }
        if (this.numExtents == 0) {
            return -1L;
        }
        AllocExtent allocExtent = null;
        for (n = 0; n < this.numExtents; ++n) {
            if (l >= this.hiRange[n]) continue;
            allocExtent = this.extents[n];
            break;
        }
        if (allocExtent == null) {
            return -1L;
        }
        long l3 = -1L;
        while (n < this.numExtents && (l3 = (allocExtent = this.extents[n]).getNextValidPageNumber(l)) == -1L) {
            ++n;
        }
        return l3;
    }

    protected int getPageStatus(BaseContainerHandle baseContainerHandle, long l, long l2) throws StandardException {
        int n;
        AllocExtent allocExtent = null;
        for (n = 0; n < this.numExtents; ++n) {
            if (this.lowRange[n] > l || l > this.hiRange[n]) continue;
            allocExtent = this.extents[n];
            break;
        }
        if (allocExtent == null) {
            if (!this.isValid) {
                this.validate(baseContainerHandle, l2);
            }
            for (n = 0; n < this.numExtents; ++n) {
                if (this.lowRange[n] > l || l > this.hiRange[n]) continue;
                allocExtent = this.extents[n];
                break;
            }
        }
        return allocExtent.getPageStatus(l);
    }

    private void validate(BaseContainerHandle baseContainerHandle, long l) throws StandardException {
        if (this.numExtents == 0) {
            long l2 = l;
            while (!this.isValid) {
                this.growArrays(++this.numExtents);
                Page page = baseContainerHandle.getAllocPage(l2);
                AllocPage allocPage = (AllocPage)page;
                this.setArrays(this.numExtents - 1, allocPage);
                if (allocPage.isLast()) {
                    this.isValid = true;
                } else {
                    l2 = allocPage.getNextAllocPageNumber();
                }
                allocPage.unlatch();
            }
        } else {
            for (int i = 0; i < this.numExtents - 1; ++i) {
                if (this.extents[i] != null) continue;
                AllocPage allocPage = (AllocPage)baseContainerHandle.getAllocPage(this.extentPageNums[i]);
                this.setArrays(i, allocPage);
                allocPage.unlatch();
            }
            long l3 = this.extentPageNums[this.numExtents - 1];
            while (!this.isValid) {
                AllocPage allocPage = (AllocPage)baseContainerHandle.getAllocPage(l3);
                if (this.extents[this.numExtents - 1] == null) {
                    this.setArrays(this.numExtents - 1, allocPage);
                }
                if (!allocPage.isLast()) {
                    this.growArrays(++this.numExtents);
                    l3 = allocPage.getNextAllocPageNumber();
                } else {
                    this.isValid = true;
                }
                allocPage.unlatch();
            }
        }
    }

    private void setArrays(int n, AllocPage allocPage) {
        AllocExtent allocExtent;
        this.extents[n] = allocExtent = allocPage.getAllocExtent();
        this.lowRange[n] = allocExtent.getFirstPagenum();
        this.hiRange[n] = allocExtent.getLastPagenum();
        this.extentPageNums[n] = allocPage.getPageNumber();
    }

    private void growArrays(int n) {
        int n2 = this.lowRange == null || this.lowRange.length == 0 ? 0 : this.lowRange.length;
        if (n2 >= n) {
            return;
        }
        long[] lArray = this.lowRange;
        long[] lArray2 = this.hiRange;
        AllocExtent[] allocExtentArray = this.extents;
        boolean[] blArray = this.isDirty;
        long[] lArray3 = this.extentPageNums;
        this.lowRange = new long[n];
        this.hiRange = new long[n];
        this.isDirty = new boolean[n];
        this.extents = new AllocExtent[n];
        this.extentPageNums = new long[n];
        if (n2 > 0) {
            System.arraycopy(lArray, 0, this.lowRange, 0, lArray.length);
            System.arraycopy(lArray2, 0, this.hiRange, 0, lArray2.length);
            System.arraycopy(blArray, 0, this.isDirty, 0, blArray.length);
            System.arraycopy(allocExtentArray, 0, this.extents, 0, allocExtentArray.length);
            System.arraycopy(lArray3, 0, this.extentPageNums, 0, lArray3.length);
        }
        for (int i = n2; i < n; ++i) {
            this.lowRange[i] = -1L;
            this.hiRange[i] = -1L;
            this.isDirty[i] = false;
            this.extentPageNums[i] = -1L;
            this.extents[i] = null;
        }
    }

    protected void dumpAllocationCache() {
    }
}

