/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mailbox.tools.indexer;

import java.time.Clock;
import java.util.Optional;
import javax.inject.Inject;
import org.apache.james.mailbox.indexer.ReIndexer;
import org.apache.james.task.Task;
import org.apache.james.task.TaskExecutionDetails;
import org.apache.james.task.TaskType;
import org.apache.mailbox.tools.indexer.ReIndexerPerformer;
import org.apache.mailbox.tools.indexer.ReIndexingContext;
import org.apache.mailbox.tools.indexer.ReIndexingContextInformationDTO;
import reactor.core.publisher.Mono;

public class FullReindexingTask
implements Task {
    public static final TaskType FULL_RE_INDEXING = TaskType.of((String)"full-reindexing");
    private final ReIndexerPerformer reIndexerPerformer;
    private final ReIndexingContext reIndexingContext;
    private final ReIndexer.RunningOptions runningOptions;

    @Inject
    public FullReindexingTask(ReIndexerPerformer reIndexerPerformer, ReIndexer.RunningOptions runningOptions) {
        this.reIndexerPerformer = reIndexerPerformer;
        this.reIndexingContext = new ReIndexingContext();
        this.runningOptions = runningOptions;
    }

    public Task.Result run() {
        return (Task.Result)this.reIndexerPerformer.reIndexAllMessages(this.reIndexingContext, this.runningOptions).onErrorResume(e -> Mono.just((Object)Task.Result.PARTIAL)).block();
    }

    public TaskType type() {
        return FULL_RE_INDEXING;
    }

    public ReIndexer.RunningOptions getRunningOptions() {
        return this.runningOptions;
    }

    public Optional<TaskExecutionDetails.AdditionalInformation> details() {
        return Optional.of(new ReIndexingContextInformationDTO.ReIndexingContextInformationForFullReindexingTask(this.reIndexingContext.successfullyReprocessedMailCount(), this.reIndexingContext.failedReprocessingMailCount(), this.reIndexingContext.failures(), Clock.systemUTC().instant(), this.runningOptions));
    }
}

