/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.draft.model;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.Optional;
import java.util.Set;
import org.apache.james.jmap.draft.model.MessageProperties;

@JsonDeserialize(builder=Builder.class)
public class SetError {
    private final Type type;
    private final Optional<String> description;
    private final Optional<ImmutableSet<MessageProperties.MessageProperty>> properties;

    public static Builder builder() {
        return new Builder();
    }

    @VisibleForTesting
    SetError(Type type, Optional<String> description, Optional<ImmutableSet<MessageProperties.MessageProperty>> properties) {
        this.type = type;
        this.description = description;
        this.properties = properties;
    }

    protected SetError(SetError setError) {
        this.type = setError.type;
        this.description = setError.description;
        this.properties = setError.properties;
    }

    @JsonSerialize
    public String getType() {
        return this.type.asString();
    }

    @JsonSerialize
    public Optional<String> getDescription() {
        return this.description;
    }

    @JsonSerialize
    public Optional<ImmutableSet<MessageProperties.MessageProperty>> getProperties() {
        return this.properties;
    }

    public boolean equals(Object obj) {
        if (obj instanceof SetError) {
            SetError other = (SetError)obj;
            return Objects.equal((Object)((Object)this.type), (Object)((Object)other.type)) && Objects.equal(this.description, other.description) && Objects.equal(this.properties, other.properties);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.type, this.description, this.properties});
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("description", this.description).add("type", (Object)this.type).add("properties", this.properties).toString();
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        private Type type;
        private String description;
        private Optional<ImmutableSet<MessageProperties.MessageProperty>> properties = Optional.empty();

        protected Builder() {
        }

        public Builder type(Type type) {
            this.type = type;
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            return this;
        }

        public Builder properties(MessageProperties.MessageProperty ... properties) {
            return this.properties((Set<MessageProperties.MessageProperty>)ImmutableSet.copyOf((Object[])properties));
        }

        public Builder properties(Set<MessageProperties.MessageProperty> properties) {
            this.properties = Optional.of(Sets.union((Set)((Set)this.properties.orElse((ImmutableSet<MessageProperties.MessageProperty>)ImmutableSet.of())), Optional.ofNullable(properties).orElse((Set<MessageProperties.MessageProperty>)ImmutableSet.of())).immutableCopy());
            return this;
        }

        public SetError build() {
            Preconditions.checkState((this.type != null ? 1 : 0) != 0, (Object)"'type' is mandatory");
            return new SetError(this.type, Optional.ofNullable(this.description), this.properties);
        }
    }

    public static enum Type {
        INVALID_ARGUMENTS("invalidArguments"),
        INVALID_PROPERTIES("invalidProperties"),
        ERROR("anErrorOccurred"),
        MAX_QUOTA_REACHED("maxQuotaReached"),
        MAILBOX_HAS_CHILD("mailboxHasChild"),
        NOT_FOUND("notFound");

        private final String stringValue;

        private Type(String stringValue) {
            this.stringValue = stringValue;
        }

        public String asString() {
            return this.stringValue;
        }
    }
}

