/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds.tools;

import com.unboundid.ldap.sdk.Attribute;
import com.unboundid.ldap.sdk.BindResult;
import com.unboundid.ldap.sdk.CompareResult;
import com.unboundid.ldap.sdk.Control;
import com.unboundid.ldap.sdk.Entry;
import com.unboundid.ldap.sdk.ExtendedResult;
import com.unboundid.ldap.sdk.LDAPConnection;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.LDAPResult;
import com.unboundid.ldap.sdk.LDAPRuntimeException;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.SearchResult;
import com.unboundid.ldap.sdk.SearchResultEntry;
import com.unboundid.ldap.sdk.SearchResultReference;
import com.unboundid.ldap.sdk.unboundidds.tools.LDAPResultWriter;
import com.unboundid.ldap.sdk.unboundidds.tools.ResultUtils;
import com.unboundid.util.Base64;
import com.unboundid.util.Debug;
import com.unboundid.util.NotNull;
import com.unboundid.util.Nullable;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.json.JSONBuffer;
import com.unboundid.util.json.JSONException;
import com.unboundid.util.json.JSONObject;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;

@ThreadSafety(level=ThreadSafetyLevel.NOT_THREADSAFE)
public final class JSONLDAPResultWriter
extends LDAPResultWriter {
    @NotNull
    private final ArrayList<String> formattedLines = new ArrayList(10);
    @NotNull
    private final JSONBuffer jsonBuffer = new JSONBuffer(null, 0, true);

    public JSONLDAPResultWriter(@NotNull OutputStream outputStream) {
        super(outputStream);
    }

    @Override
    public void writeComment(@NotNull String comment) {
    }

    @Override
    public void writeHeader() {
    }

    @Override
    public void writeSearchResultEntry(@NotNull SearchResultEntry entry) {
        this.jsonBuffer.clear();
        JSONLDAPResultWriter.toJSON(entry, this.jsonBuffer, this.formattedLines);
        this.println(this.jsonBuffer.toString());
    }

    @NotNull
    public static JSONObject toJSON(@NotNull Entry entry) {
        try {
            JSONBuffer jsonBuffer = new JSONBuffer();
            JSONLDAPResultWriter.toJSON(entry, jsonBuffer);
            return jsonBuffer.toJSONObject();
        }
        catch (JSONException e) {
            Debug.debugException(e);
            throw new LDAPRuntimeException(new LDAPException(ResultCode.ENCODING_ERROR, e.getMessage(), e));
        }
    }

    public static void toJSON(@NotNull Entry entry, @NotNull JSONBuffer jsonBuffer) {
        JSONLDAPResultWriter.toJSON(entry, jsonBuffer, null);
    }

    private static void toJSON(@NotNull Entry entry, @NotNull JSONBuffer jsonBuffer, @Nullable List<String> formattedLines) {
        SearchResultEntry searchResultEntry;
        Control[] controls;
        jsonBuffer.beginObject();
        jsonBuffer.appendString("result-type", "entry");
        jsonBuffer.appendString("dn", entry.getDN());
        jsonBuffer.beginArray("attributes");
        for (Attribute a : entry.getAttributes()) {
            jsonBuffer.beginObject();
            jsonBuffer.appendString("name", a.getName());
            jsonBuffer.beginArray("values");
            for (String value : a.getValues()) {
                jsonBuffer.appendString(value);
            }
            jsonBuffer.endArray();
            jsonBuffer.endObject();
        }
        jsonBuffer.endArray();
        if (entry instanceof SearchResultEntry && (controls = (searchResultEntry = (SearchResultEntry)entry).getControls()) != null && controls.length > 0) {
            if (formattedLines == null) {
                JSONLDAPResultWriter.handleControls(controls, jsonBuffer, new ArrayList<String>());
            } else {
                JSONLDAPResultWriter.handleControls(controls, jsonBuffer, formattedLines);
            }
        }
        jsonBuffer.endObject();
    }

    @Override
    public void writeSearchResultReference(@NotNull SearchResultReference ref) {
        this.jsonBuffer.clear();
        JSONLDAPResultWriter.toJSON(ref, this.jsonBuffer, this.formattedLines);
        this.println(this.jsonBuffer.toString());
    }

    @NotNull
    public static JSONObject toJSON(@NotNull SearchResultReference ref) {
        try {
            JSONBuffer jsonBuffer = new JSONBuffer();
            JSONLDAPResultWriter.toJSON(ref, jsonBuffer);
            return jsonBuffer.toJSONObject();
        }
        catch (JSONException e) {
            Debug.debugException(e);
            throw new LDAPRuntimeException(new LDAPException(ResultCode.ENCODING_ERROR, e.getMessage(), e));
        }
    }

    public static void toJSON(@NotNull SearchResultReference ref, @NotNull JSONBuffer jsonBuffer) {
        JSONLDAPResultWriter.toJSON(ref, jsonBuffer, null);
    }

    private static void toJSON(@NotNull SearchResultReference ref, @NotNull JSONBuffer jsonBuffer, @Nullable List<String> formattedLines) {
        jsonBuffer.beginObject();
        jsonBuffer.appendString("result-type", "reference");
        jsonBuffer.beginArray("referral-urls");
        for (String url : ref.getReferralURLs()) {
            jsonBuffer.appendString(url);
        }
        jsonBuffer.endArray();
        Control[] controls = ref.getControls();
        if (controls != null && controls.length > 0) {
            if (formattedLines == null) {
                JSONLDAPResultWriter.handleControls(controls, jsonBuffer, new ArrayList<String>());
            } else {
                JSONLDAPResultWriter.handleControls(controls, jsonBuffer, formattedLines);
            }
        }
        jsonBuffer.endObject();
    }

    @Override
    public void writeResult(@NotNull LDAPResult result) {
        this.jsonBuffer.clear();
        JSONLDAPResultWriter.toJSON(result, this.jsonBuffer, this.formattedLines);
        this.println(this.jsonBuffer.toString());
    }

    @NotNull
    public static JSONObject toJSON(@NotNull LDAPResult result) {
        try {
            JSONBuffer jsonBuffer = new JSONBuffer();
            JSONLDAPResultWriter.toJSON(result, jsonBuffer);
            return jsonBuffer.toJSONObject();
        }
        catch (JSONException e) {
            Debug.debugException(e);
            throw new LDAPRuntimeException(new LDAPException(ResultCode.ENCODING_ERROR, e.getMessage(), e));
        }
    }

    public static void toJSON(@NotNull LDAPResult result, @NotNull JSONBuffer jsonBuffer) {
        JSONLDAPResultWriter.toJSON(result, jsonBuffer, null);
    }

    private static void toJSON(@NotNull LDAPResult result, @NotNull JSONBuffer jsonBuffer, @Nullable List<String> formattedLines) {
        String[] referralURLs;
        String matchedDN;
        jsonBuffer.beginObject();
        if (result instanceof SearchResult) {
            jsonBuffer.appendString("result-type", "search-result");
        } else if (result instanceof BindResult) {
            jsonBuffer.appendString("result-type", "bind-result");
        } else if (result instanceof CompareResult) {
            jsonBuffer.appendString("result-type", "compare-result");
        } else if (result instanceof ExtendedResult) {
            jsonBuffer.appendString("result-type", "extended-result");
        } else {
            jsonBuffer.appendString("result-type", "ldap-result");
        }
        jsonBuffer.appendNumber("result-code", result.getResultCode().intValue());
        jsonBuffer.appendString("result-code-name", result.getResultCode().getName());
        String diagnosticMessage = result.getDiagnosticMessage();
        if (diagnosticMessage != null) {
            jsonBuffer.appendString("diagnostic-message", diagnosticMessage);
        }
        if ((matchedDN = result.getMatchedDN()) != null) {
            jsonBuffer.appendString("matched-dn", matchedDN);
        }
        if ((referralURLs = result.getReferralURLs()) != null && referralURLs.length > 0) {
            jsonBuffer.beginArray("referral-urls");
            for (String url : referralURLs) {
                jsonBuffer.appendString(url);
            }
            jsonBuffer.endArray();
        }
        if (result instanceof SearchResult) {
            SearchResult searchResult = (SearchResult)result;
            jsonBuffer.appendNumber("entries-returned", searchResult.getEntryCount());
            jsonBuffer.appendNumber("references-returned", searchResult.getReferenceCount());
        } else if (result instanceof ExtendedResult) {
            ExtendedResult extendedResult = (ExtendedResult)result;
            String oid = extendedResult.getOID();
            if (oid != null) {
                jsonBuffer.appendString("oid", oid);
            }
            if (extendedResult.hasValue()) {
                jsonBuffer.appendString("base64-encoded-value", Base64.encode(extendedResult.getValue().getValue()));
            }
        }
        Control[] controls = result.getResponseControls();
        if (controls != null && controls.length > 0) {
            if (formattedLines == null) {
                JSONLDAPResultWriter.handleControls(controls, jsonBuffer, new ArrayList<String>());
            } else {
                JSONLDAPResultWriter.handleControls(controls, jsonBuffer, formattedLines);
            }
        }
        jsonBuffer.endObject();
    }

    @Override
    public void writeUnsolicitedNotification(@NotNull LDAPConnection connection, @NotNull ExtendedResult notification) {
        String[] referralURLs;
        String matchedDN;
        this.jsonBuffer.clear();
        this.jsonBuffer.beginObject();
        this.jsonBuffer.appendString("result-type", "unsolicited-notification");
        String oid = notification.getOID();
        if (oid != null) {
            this.jsonBuffer.appendString("oid", oid);
        }
        if (notification.hasValue()) {
            this.jsonBuffer.appendString("base64-encoded-value", Base64.encode(notification.getValue().getValue()));
        }
        this.jsonBuffer.appendNumber("result-code", notification.getResultCode().intValue());
        this.jsonBuffer.appendString("result-code-name", notification.getResultCode().getName());
        String diagnosticMessage = notification.getDiagnosticMessage();
        if (diagnosticMessage != null) {
            this.jsonBuffer.appendString("diagnostic-message", diagnosticMessage);
        }
        if ((matchedDN = notification.getMatchedDN()) != null) {
            this.jsonBuffer.appendString("matched-dn", matchedDN);
        }
        if ((referralURLs = notification.getReferralURLs()) != null && referralURLs.length > 0) {
            this.jsonBuffer.beginArray("referral-urls");
            for (String url : referralURLs) {
                this.jsonBuffer.appendString(url);
            }
            this.jsonBuffer.endArray();
        }
        this.handleControls(notification.getResponseControls());
        this.formattedLines.clear();
        ResultUtils.formatUnsolicitedNotification(this.formattedLines, notification, false, 0, Integer.MAX_VALUE);
        this.jsonBuffer.beginArray("formatted-unsolicited-notification-lines");
        for (String line : this.formattedLines) {
            this.jsonBuffer.appendString(line.trim());
        }
        this.jsonBuffer.endArray();
        this.jsonBuffer.endObject();
        this.println(this.jsonBuffer.toString());
    }

    private void handleControls(@Nullable Control[] controls) {
        JSONLDAPResultWriter.handleControls(controls, this.jsonBuffer, this.formattedLines);
    }

    private static void handleControls(@Nullable Control[] controls, @NotNull JSONBuffer jsonBuffer, @NotNull List<String> formattedLines) {
        jsonBuffer.beginArray("controls");
        for (Control c : controls) {
            jsonBuffer.beginObject();
            jsonBuffer.appendString("oid", c.getOID());
            jsonBuffer.appendBoolean("criticality", c.isCritical());
            if (c.hasValue()) {
                jsonBuffer.appendString("base64-encoded-value", Base64.encode(c.getValue().getValue()));
            }
            formattedLines.clear();
            ResultUtils.formatResponseControl(formattedLines, c, false, 0, Integer.MAX_VALUE);
            jsonBuffer.beginArray("formatted-control-lines");
            for (String line : formattedLines) {
                jsonBuffer.appendString(line.trim());
            }
            jsonBuffer.endArray();
            jsonBuffer.endObject();
        }
        jsonBuffer.endArray();
    }
}

