/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.modules.mailbox;

import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.Session;
import com.google.inject.AbstractModule;
import com.google.inject.Binder;
import com.google.inject.Inject;
import com.google.inject.Provides;
import com.google.inject.Scopes;
import com.google.inject.Singleton;
import com.google.inject.multibindings.Multibinder;
import com.google.inject.name.Named;
import com.google.inject.name.Names;
import java.lang.annotation.Annotation;
import java.util.Set;
import org.apache.james.backends.cassandra.components.CassandraModule;
import org.apache.james.backends.cassandra.init.KeyspaceFactory;
import org.apache.james.backends.cassandra.init.SessionWithInitializedTablesFactory;
import org.apache.james.backends.cassandra.init.configuration.ClusterConfiguration;
import org.apache.james.backends.cassandra.init.configuration.KeyspaceConfiguration;
import org.apache.james.modules.mailbox.KeyspacesConfiguration;

public class CassandraCacheSessionModule
extends AbstractModule {
    protected void configure() {
        this.bind(InitializedCacheCluster.class).in(Scopes.SINGLETON);
        Multibinder.newSetBinder((Binder)this.binder(), CassandraModule.class, (Annotation)Names.named((String)"cache"));
    }

    @Named(value="cache")
    @Provides
    @Singleton
    KeyspaceConfiguration provideCacheKeyspaceConfiguration(KeyspacesConfiguration keyspacesConfiguration) {
        return keyspacesConfiguration.cacheKeyspaceConfiguration();
    }

    @Singleton
    @Named(value="cache")
    @Provides
    Session provideSession(@Named(value="cache") KeyspaceConfiguration keyspaceConfiguration, InitializedCacheCluster cluster, @Named(value="cache") CassandraModule module) {
        return new SessionWithInitializedTablesFactory(keyspaceConfiguration, cluster.cluster, module).get();
    }

    @Named(value="cache")
    @Provides
    @Singleton
    CassandraModule composeCacheDefinitions(@Named(value="cache") Set<CassandraModule> modules) {
        return CassandraModule.aggregateModules(modules);
    }

    static class InitializedCacheCluster {
        private final Cluster cluster;

        @Inject
        private InitializedCacheCluster(Cluster cluster, ClusterConfiguration clusterConfiguration, KeyspacesConfiguration keyspacesConfiguration) {
            this.cluster = cluster;
            if (clusterConfiguration.shouldCreateKeyspace()) {
                KeyspaceFactory.createKeyspace((KeyspaceConfiguration)keyspacesConfiguration.cacheKeyspaceConfiguration(), (Cluster)cluster);
            }
        }
    }
}

